/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.ReportCell;
import inform.agent.web.reports.controls.ReportTable;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.VeerKey;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportColumn
extends WebControl {
    private static final int TAG_WEB_TABLE_COLUMN_DEF_MARGINS = 41;
    private static final int TAG_WEB_TABLE_COLUMN_VEER = 42;
    private static final int TAG_WEB_VEER_VEER_KEY = 1;
    private static final int TAG_WEB_VEER_DATA_KEY = 2;
    private static final int TAG_WEB_TABLE_COLUMN_EXTRA_VEER = 43;
    private static final int TAG_WEB_TABLE_COLUMN_GROUPED = 44;
    private static final int TAG_WEB_TABLE_COLUMN_SUPPRESSBLANK = 45;
    int controlIndex = -1;
    final ReportTable table;
    final TableMargins cellMargins;
    VeerKey veer = null;
    VeerKey veerData = null;
    Object veerKey = null;
    boolean extraVeer = false;
    boolean grouped = false;
    boolean suppressBlank = false;
    ReportCell[] sourceCells = null;
    ReportColumn mainColumn = null;

    public ReportColumn(Task task, ReportTable table, ComponentHeader header) {
        super(task, null, header);
        this.table = table;
        this.cellMargins = new TableMargins(null);
    }

    public ReportColumn(Task task, ReportTable table, int id, String name) {
        super(task, null, id, name);
        this.table = table;
        this.cellMargins = new TableMargins(null);
    }

    public void updateCellMargins(TableMargins margins) {
        margins.updateLeft(this.cellMargins.getLeft());
        margins.updateRight(this.cellMargins.getRight());
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 41: {
                this.cellMargins.load(in.getSubStreamReader());
                break;
            }
            case 42: {
                TaggedReader veerIn = in.getSubStreamReader();
                this.veer = new VeerKey();
                this.veer.load(veerIn);
                break;
            }
            case 43: {
                this.extraVeer = true;
                break;
            }
            case 44: {
                this.grouped = true;
                break;
            }
            case 45: {
                this.suppressBlank = true;
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        if (this.veer != null) {
            this.veer.adterLoad(this.getTask());
            this.extraVeer = false;
        }
    }

    @Override
    public void print(Writer out) throws IOException {
    }

    @Override
    public String getClassName() {
        return "ReportColumn";
    }

    @Override
    public int getIndex() {
        return this.controlIndex;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public TableMargins getMargins() {
        return this.cellMargins;
    }

    public TableMargins getCellMargins() {
        return this.cellMargins;
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof ReportTable);
        return this.createClone(task, (ReportTable)scope);
    }

    public ReportColumn createClone(Task task, ReportTable table) {
        String name = this.getName();
        if (name != null && table.columns.getByName(name) != null) {
            name = null;
        }
        ReportColumn column = new ReportColumn(task, table, task.generateId(), name);
        column.assignProps(this);
        column.cellMargins.assign(this.cellMargins);
        column.sourceCells = this.table.getColumnCells(this.controlIndex);
        if (this.veer != null) {
            column.veer = new VeerKey(this.veer);
        }
        if (this.veerData != null) {
            column.veerData = new VeerKey(this.veerData);
        }
        column.grouped = this.grouped;
        column.suppressBlank = this.suppressBlank;
        return column;
    }

    public boolean isVeer() {
        return this.veerData != null;
    }

    public boolean veerLocate() throws Exception {
        if (this.veerData == null) {
            return true;
        }
        return this.veerData.veerLocate(this.veerKey);
    }

    public boolean isVeerDataSelected() throws Exception {
        if (this.veerData == null) {
            return true;
        }
        return this.veerData.isDataSelected(this.veerKey);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.mainColumn == null || this.mainColumn.isVisible());
    }

    public boolean getGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public boolean getSuppressBlank() {
        return this.suppressBlank;
    }

    public void setSuppressBlank(boolean suppressBlank) {
        this.suppressBlank = suppressBlank;
    }
}

