/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.BandItem;
import inform.agent.web.reports.controls.PageSettings;
import inform.agent.web.reports.controls.ReportBand;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.controls.SheetProtection;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.TableMargins;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportPageBreak
extends WebControlContainer<WebControl>
implements BandItem {
    public static final int TAG_WEB_PAGEBREAK_CAPTION = 40;
    public static final int TAG_WEB_PAGEBREAK_NEWSHEET = 41;
    public static final int TAG_WEB_PAGEBREAK_ORIENTATION = 42;
    public static final int TAG_WEB_PAGEBREAK_PAGEWIDTH = 43;
    public static final int TAG_WEB_PAGEBREAK_PAGEHEIGHT = 44;
    public static final int TAG_WEB_PAGEBREAK_OVERRIDEPAGE = 49;
    public static final int TAG_WEB_PAGEBREAK_PAGETOP = 50;
    public static final int TAG_WEB_PAGEBREAK_PAGEBOTTOM = 51;
    public static final int TAG_WEB_PAGEBREAK_PAGELEFT = 52;
    public static final int TAG_WEB_PAGEBREAK_PAGERIGHT = 53;
    public static final int TAG_WEB_PAGEBREAK_PAGE_PROTECTION = 54;
    private String pageCaption = "";
    private boolean newSheet = true;
    private boolean pageSetupEnabled;
    private final SheetProtection pageProtection;
    private final PageSettings pageSettings = new PageSettings(null);

    public ReportPageBreak(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
        this.pageProtection = new SheetProtection(null);
    }

    protected ReportPageBreak(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
        this.pageProtection = new SheetProtection(null);
    }

    @Override
    public DocSection generate(Document document, DocSection section) throws Exception {
        if (!this.getVisible()) {
            return section;
        }
        if (this.newSheet) {
            short scale = section.getScale();
            boolean useScale = section.isUseXlsScale();
            boolean gridNotShow = section.getGridNotShow();
            PageSettings p = document.getRootPageSettings();
            if (this.pageSetupEnabled) {
                this.pageSettings.assignRoot(p);
                p = this.pageSettings;
            }
            section = document.appendSection();
            section.setPageCaption(this.pageCaption);
            section.setPageSettings(p);
            section.setScale(scale);
            section.setUseXlsScale(useScale);
            section.setGridNotShow(gridNotShow);
            if (this.pageProtection.getEnabled()) {
                section.setAllPageProtection(this.pageProtection);
            }
        } else {
            section.addPageBreak();
        }
        return section;
    }

    @Override
    public int getOutputRegion() {
        return 0;
    }

    @Override
    public int getOutputRegionPages() {
        return 0;
    }

    @Override
    protected WebControl createElementControl(ComponentHeader header) throws IOException, InformException {
        throw new IllegalStateException();
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) throws InformException {
        assert (scope instanceof ReportBand);
        ReportBand band = (ReportBand)scope;
        ReportPageBreak p = new ReportPageBreak(task, null, task.generateId(), ReportPageBreak.cloneName(band, this.getName()));
        p.assignProps(this);
        return p;
    }

    @Override
    public void print(Writer out) throws IOException {
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, TaggedReaderException {
        switch (tag) {
            case 40: {
                this.pageCaption = in.getString();
                break;
            }
            case 41: {
                this.newSheet = in.getBoolean();
                break;
            }
            case 42: {
                this.pageSettings.orientation = ReportPageOrientation.create(in.getInt());
                break;
            }
            case 43: {
                this.pageSettings.pageWidth = in.getDouble();
                break;
            }
            case 44: {
                this.pageSettings.pageHeight = in.getDouble();
                break;
            }
            case 49: {
                this.pageSetupEnabled = in.getBoolean();
                break;
            }
            case 50: {
                this.pageSettings.pageMargins.setTop(in.getDouble());
                break;
            }
            case 51: {
                this.pageSettings.pageMargins.setBottom(in.getDouble());
                break;
            }
            case 52: {
                this.pageSettings.pageMargins.setLeft(in.getDouble());
                break;
            }
            case 53: {
                this.pageSettings.pageMargins.setRight(in.getDouble());
                break;
            }
            case 54: {
                this.pageProtection.load(in.getSubStreamReader());
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    public boolean getNewSheet() {
        return this.newSheet;
    }

    public void setNewSheet(boolean newSheet) {
        this.newSheet = newSheet;
    }

    public ReportPageOrientation getOrientation() {
        return this.pageSettings.orientation;
    }

    public void setOrientation(ReportPageOrientation orientation) {
        this.pageSettings.orientation = orientation;
    }

    public String getPageCaption() {
        return this.pageCaption;
    }

    public void setPageCaption(String pageCaption) {
        this.pageCaption = pageCaption;
    }

    public double getPageHeight() {
        return this.pageSettings.pageHeight;
    }

    public void setPageHeight(double pageHeight) {
        this.pageSettings.pageHeight = pageHeight;
    }

    public TableMargins getPageMargins() {
        return this.pageSettings.pageMargins;
    }

    public boolean getPageSetupEnabled() {
        return this.pageSetupEnabled;
    }

    public void setPageSetupEnabled(boolean pageSetupEnabled) {
        this.pageSetupEnabled = pageSetupEnabled;
    }

    public double getPageWidth() {
        return this.pageSettings.pageWidth;
    }

    public void setPageWidth(double pageWidth) {
        this.pageSettings.pageWidth = pageWidth;
    }

    @Override
    protected void assignProps(WebControl control) {
        super.assignProps(control);
        if (!(control instanceof ReportPageBreak)) {
            return;
        }
        ReportPageBreak p = (ReportPageBreak)control;
        this.pageCaption = p.pageCaption;
        this.newSheet = p.newSheet;
        this.pageSettings.assign(p.pageSettings);
        this.pageSetupEnabled = p.pageSetupEnabled;
        this.pageProtection.assign(this.pageProtection);
    }
}

