/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.BandItem;
import inform.agent.web.reports.controls.ReportBand;
import inform.agent.web.reports.controls.ReportCell;
import inform.agent.web.reports.controls.ReportColumn;
import inform.agent.web.reports.controls.ReportColumns;
import inform.agent.web.reports.controls.ReportRow;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.VeerKey;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ReportTable
extends WebControlContainer<ReportRow>
implements BandItem {
    private static final int TAG_WEB_TABLE_COLUMNS = 40;
    private static final int TAG_WEB_TABLE_DEF_MARGINS = 41;
    private static final int TAG_WR_TABLE_OUTPUT_REGION = 42;
    final ReportColumns columns;
    final Borders borders;
    DocTable docTable = null;
    final TableMargins cellMargins;
    HorizontalAlign align = HorizontalAlign.LEFT;
    int outputRegion = 0;
    int outputRegionPages = 0;

    public ReportTable(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
        this.borders = new Borders(null);
        this.cellMargins = new TableMargins(null);
        this.columns = new ReportColumns(null);
    }

    public ReportTable(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
        this.borders = new Borders(null);
        this.cellMargins = new TableMargins(null);
        this.columns = new ReportColumns(null);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) throws InformException {
        assert (scope instanceof ReportBand);
        return this.createClone(task, (ReportBand)scope);
    }

    public ReportTable createClone(Task task, ReportBand band) throws InformException {
        ReportTable table = new ReportTable(task, null, task.generateId(), ReportTable.cloneName(band, this.getName()));
        table.assignProps(this);
        table.borders.assignCopy(this.borders);
        table.cellMargins.assign(this.cellMargins);
        table.columns.assignColumns(task, this.columns);
        for (ReportRow row : this.controls) {
            ReportRow r = row.createRowClone(task, table, true);
            table.controls.add(r);
        }
        return table;
    }

    public Collection<ReportColumn> getColumnList() {
        return this.columns.values();
    }

    public void updateCellMargins(TableMargins margins) {
        margins.updateLeft(this.cellMargins.getLeft());
        margins.updateRight(this.cellMargins.getRight());
        margins.updateTop(this.cellMargins.getTop());
        margins.updateBottom(this.cellMargins.getBottom());
    }

    @Override
    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 4: {
                this.align = HorizontalAlign.create(in.getInt());
                break;
            }
            case 40: {
                this.loadColumns(in.getSubStreamReader());
                break;
            }
            case 11: {
                this.borders.load(in.getSubStreamReader());
                break;
            }
            case 41: {
                this.cellMargins.load(in.getSubStreamReader());
                break;
            }
            case 42: {
                TaggedReader reader = in.getSubStreamReader();
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            this.outputRegion = reader.getInt();
                            break;
                        }
                        case 2: {
                            this.outputRegionPages = reader.getInt();
                        }
                    }
                }
                reader = null;
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        super.afterLoad();
        for (ReportColumn column : this.columns.values()) {
            column.afterLoad();
        }
    }

    @Override
    protected ReportRow createElementControl(ComponentHeader header) throws IOException, InformException {
        return new ReportRow(this.task, this, header);
    }

    @Override
    public void print(Writer out) throws IOException {
        out.append("<table>");
        for (ReportRow c : this.controls) {
            c.print(out);
        }
        out.append("</table>");
    }

    @Override
    public String getClassName() {
        return "Table";
    }

    private void loadColumns(TaggedReader in) throws IOException, InformException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    ComponentHeader header = new ComponentHeader(in.getInt(), in.getInt(3), 0);
                    ReportColumn column = new ReportColumn(this.task, this, header);
                    this.columns.add(column);
                    column.load(in.getSubStreamReader());
                    this.registerControl(column);
                }
            }
        }
    }

    void shiftCellIndex(int colIndex) {
        for (ReportRow row : this.controls) {
            for (ReportCell cell : row.controls) {
                if (cell.columnIndex < colIndex) continue;
                ++cell.columnIndex;
            }
        }
    }

    ReportCell getCell(int colIndex, int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.controls.size()) {
            return null;
        }
        ReportRow row = (ReportRow)this.controls.get(rowIndex);
        for (ReportCell cell : row.controls) {
            if (cell.columnIndex == colIndex) {
                return cell;
            }
            if (cell.columnIndex < colIndex) continue;
            break;
        }
        return null;
    }

    ReportCell findCell(int colIndex, int rowIndex) {
        int r = 0;
        for (ReportRow row : this.controls) {
            for (ReportCell cell : row.controls) {
                if (cell.columnIndex > colIndex) break;
                int endIndex = cell.columnIndex + cell.getColSpan() - 1;
                if (cell.columnIndex > colIndex || colIndex > endIndex) continue;
                int endRowIndex = r + cell.getRowSpan() - 1;
                if (r > rowIndex || rowIndex > endRowIndex) continue;
                return cell;
            }
            if (++r <= rowIndex) continue;
            break;
        }
        return null;
    }

    ReportCell[] getColumnCells(int columnIndex) {
        ReportCell[] cells = new ReportCell[this.controls.size()];
        for (int rowIndex = 0; rowIndex < this.controls.size(); ++rowIndex) {
            cells[rowIndex] = this.getCell(columnIndex, rowIndex);
        }
        return cells;
    }

    public TableMargins getCellMargins() {
        return this.cellMargins;
    }

    public TableMargins getMargins() {
        return this.cellMargins;
    }

    public Borders getBorders() {
        return this.borders;
    }

    public ReportColumns getColumns() {
        return this.columns;
    }

    public int getAlign() {
        return this.align.value();
    }

    public void setAlign(int value) {
        this.align = HorizontalAlign.create(value, this.align);
    }

    private ReportColumn createColumn(ReportColumn templateColumn) throws InformException {
        ReportColumn column = templateColumn != null ? templateColumn.createClone(this.task, this) : new ReportColumn(this.task, this, this.task.generateId(), null);
        if (column != null) {
            column.afterLoad();
        }
        return column;
    }

    private void internalInsertColumn(int columnIndex, ReportColumn column) throws InformException {
        this.columns.insert(columnIndex, column);
        this.shiftCellIndex(columnIndex);
        ReportCell sourceCell = null;
        for (int rowIndex = 0; rowIndex < this.controls.size(); ++rowIndex) {
            if (column.sourceCells != null) {
                sourceCell = rowIndex < column.sourceCells.length ? column.sourceCells[rowIndex] : null;
            }
            ReportRow row = (ReportRow)this.controls.get(rowIndex);
            ReportCell cell = this.findCell(columnIndex, rowIndex);
            if (cell == null || cell.getColSpan() == 1) {
                int insertIndex = -1;
                int i = 0;
                for (ReportCell c : row.controls) {
                    if (c.columnIndex >= columnIndex) {
                        insertIndex = i;
                        break;
                    }
                    ++i;
                }
                if (insertIndex < 0) {
                    insertIndex = row.controls.size();
                }
                cell = sourceCell != null ? sourceCell.createClone(this.task, row) : new ReportCell(this.task, row, this.task.generateId(), null);
                cell.columnIndex = columnIndex;
                row.controls.add(insertIndex, cell);
                cell.afterLoad();
                continue;
            }
            if (cell.row != row || sourceCell == null) continue;
            ++cell.colSpan;
        }
    }

    public static Object insertColumn(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Object control;
        ReportTable self = (ReportTable)thisObj;
        int columnIndex = self.columns.size();
        if (args.length > 0) {
            try {
                columnIndex = ValueCaster.toInt(args[0]);
                if (columnIndex < 0) {
                    columnIndex = 0;
                }
                if (columnIndex > self.columns.size()) {
                    columnIndex = self.columns.size();
                }
            }
            catch (Exception ex) {
                columnIndex = self.columns.size();
            }
        }
        ReportColumn templateColumn = null;
        if (args.length > 1 && (control = args[1]) != null && control instanceof ReportColumn) {
            templateColumn = (ReportColumn)control;
        }
        ReportColumn column = self.createColumn(templateColumn);
        self.internalInsertColumn(columnIndex, column);
        return column;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.validIndex(index)) {
            return this.controls.get(index);
        }
        return Scriptable.NOT_FOUND;
    }

    ReportRow createRow(ReportRow rowTemplate) throws InformException {
        ReportRow row = rowTemplate != null ? rowTemplate.createRowClone(this.task, this, false) : new ReportRow(this.task, this, this.task.generateId(), null);
        if (row != null) {
            row.afterLoad();
        }
        return row;
    }

    public static Object insertRow(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Object control;
        ReportTable self = (ReportTable)thisObj;
        int rowIndex = self.controls.size();
        if (args.length > 0) {
            try {
                rowIndex = ValueCaster.toInt(args[0]);
            }
            catch (Exception ex) {
                rowIndex = self.controls.size();
            }
        }
        ReportRow templateRow = null;
        if (args.length > 1 && (control = args[1]) != null && control instanceof ReportRow) {
            templateRow = (ReportRow)control;
        }
        ReportRow row = self.createRow(templateRow);
        for (int colIndex = 0; colIndex < self.columns.size(); ++colIndex) {
            ReportCell newCell;
            ReportCell cell = self.findCell(colIndex, rowIndex);
            if (cell != null && cell.rowSpan > 1) {
                int r = self.controls.indexOf(cell.row);
                int beforeRowSpan = r - rowIndex + 1;
                int afterRowSpan = cell.rowSpan - beforeRowSpan;
                cell.rowSpan = beforeRowSpan;
                ReportRow nextRow = (ReportRow)self.controls.get(rowIndex + 1);
                int nextColIndex = -1;
                int i = 0;
                while (i < nextRow.controls.size()) {
                    ReportCell c = (ReportCell)nextRow.controls.get(i);
                    if (c.columnIndex >= colIndex) break;
                    nextColIndex = i++;
                }
                if (nextColIndex >= 0) {
                    ReportCell nextCell = new ReportCell(self.task, nextRow, self.task.generateId(), null);
                    nextCell.rowSpan = afterRowSpan;
                    nextRow.controls.add(nextColIndex, nextCell);
                }
            }
            if (row.sourceCells != null && colIndex < row.sourceCells.length && row.sourceCells[colIndex] != null) {
                newCell = row.sourceCells[colIndex].createClone(self.task, row);
                newCell.rowSpan = 1;
                if (colIndex + newCell.colSpan > self.columns.size()) {
                    newCell.colSpan = self.columns.size() - colIndex;
                }
                row.controls.add(newCell);
                newCell.afterLoad();
                continue;
            }
            newCell = new ReportCell(self.task, row, self.task.generateId(), null);
            newCell.columnIndex = colIndex;
            row.controls.add(newCell);
            newCell.afterLoad();
        }
        self.controls.add(rowIndex, row);
        return row;
    }

    private void expandVeerColumns() throws Exception {
        for (int index = 0; index < this.columns.size(); ++index) {
            ReportColumn column = this.columns.get(index);
            if (!column.isGenerated() || !column.getVisible() || column.veer == null || column.veer.isEmpty()) continue;
            int veerSize = 1;
            int veerCount = 1;
            for (int v = index + 1; v < this.columns.size(); ++v) {
                ReportColumn c = this.columns.get(v);
                if (!c.extraVeer) break;
                if (c.isGenerated() && c.getVisible()) {
                    ++veerSize;
                }
                ++veerCount;
            }
            ReportColumn[] clonedColumns = new ReportColumn[veerSize];
            int veerIndex = 0;
            for (int i = 0; i < veerCount; ++i) {
                ReportColumn c = this.columns.get(index + i);
                if (!c.isGenerated() || !c.getVisible()) continue;
                clonedColumns[veerIndex++] = c;
            }
            VeerKey veer = column.veer;
            for (ReportColumn c : clonedColumns) {
                c.veerData = veer;
                c.veer = null;
            }
            veer.selectVeer();
            boolean firstColumn = true;
            int inserionIndex = index + veerSize;
            while (veer.next()) {
                ReportColumn mainColumn = null;
                Object veerKey = veer.getVeerValue();
                if (firstColumn) {
                    firstColumn = false;
                    for (ReportColumn c : clonedColumns) {
                        if (mainColumn == null) {
                            mainColumn = c;
                        } else {
                            c.mainColumn = mainColumn;
                        }
                        c.veerKey = veerKey;
                    }
                    continue;
                }
                for (ReportColumn c : clonedColumns) {
                    ReportColumn newColumn = c.createClone(this.getTask(), this);
                    if (mainColumn == null) {
                        mainColumn = newColumn;
                    } else {
                        newColumn.mainColumn = mainColumn;
                    }
                    newColumn.veerKey = veerKey;
                    this.internalInsertColumn(inserionIndex++, newColumn);
                }
            }
        }
    }

    @Override
    public void beforeGenerate() {
        int rowIndex = -1;
        for (ReportRow row : this.controls) {
            if (!row.isGenerated()) continue;
            row.rowIndex = ++rowIndex;
            row.beforeGenerate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocSection generate(Document document, DocSection section) throws Exception {
        this.expandVeerColumns();
        this.docTable = null;
        if (section != null && this.getVisible()) {
            int color = this.getColor();
            Font font = this.getFont();
            if (document.getUseBlackAndWhite()) {
                color = 0x1FFFFFFF;
                font.setColor(0);
            }
            this.docTable = section.addTable(this);
            this.docTable.setVisible(this.isVisible());
            this.docTable.setFont(font);
            this.docTable.setColor(color);
            this.docTable.setAlign(this.align);
            this.docTable.bottomMargin(this.marginBottom);
            this.cellMargins.update();
            this.docTable.setCellMargins(this.cellMargins);
            this.docTable.setWidth(this.width);
        }
        try {
            for (ReportRow reportRow : this.controls) {
                if (!reportRow.isGenerated()) continue;
                reportRow.beginGenerate(document, this.docTable);
            }
            for (ReportRow reportRow : this.controls) {
                if (!reportRow.isGenerated() || reportRow.isDependent()) continue;
                reportRow.doGenerate(document, this.docTable, 0);
            }
            for (ReportRow reportRow : this.controls) {
                if (!reportRow.isGenerated()) continue;
                reportRow.endGenerate(document, this.docTable);
            }
            for (DocRow docRow : this.docTable.rows()) {
                ArrayList<DocCell> cells = docRow.getCells();
                int i = 0;
                for (int j = 0; j < this.getColumns().size(); ++j) {
                    if (this.getColumns().get(j).getVisible()) {
                        ++i;
                        continue;
                    }
                    cells.remove(i);
                }
            }
            int i = 0;
            while (i < this.docTable.getColumns().size()) {
                if (this.docTable.getColumns().get(i).getVisible()) {
                    ++i;
                    continue;
                }
                this.docTable.getColumns().remove(i);
            }
        }
        finally {
            this.docTable = null;
        }
        return section;
    }

    @Override
    public int getOutputRegion() {
        return this.outputRegion;
    }

    public void setOutputRegion(int outputRegion) {
        this.outputRegion = outputRegion;
    }

    @Override
    public int getOutputRegionPages() {
        return this.outputRegionPages;
    }

    public void setOutputRegionPages(int outputRegionPages) {
        this.outputRegionPages = outputRegionPages;
    }
}

