/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.reports.ReportTask;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Font;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public abstract class WebControl
extends ServerSideComponent {
    public static final int TAG_WEB_WIDTH = 2;
    public static final int TAG_WEB_HEIGHT = 3;
    public static final int TAG_WEB_HORZ_ALIGN = 4;
    public static final int TAG_WEB_VERT_ALIGN = 5;
    public static final int TAG_WEB_FONT = 6;
    public static final int TAG_WEB_COLOR = 7;
    public static final int TAG_WEB_INVISIBLE = 8;
    public static final int TAG_WEB_TOP_MARGIN = 9;
    public static final int TAG_WEB_BOTTOM_MARGIN = 10;
    public static final int TAG_WEB_BORDERS = 11;
    public static final int TAG_WEB_ON_GETDATA = 12;
    public static final int TAG_WEB_EXCLUDE_GENERATE = 13;
    protected double width;
    protected double height;
    protected double marginTop;
    protected double marginBottom;
    private WebControlContainer parent = null;
    private final Font font = new Font();
    private int color = 0x1FFFFFFF;
    private boolean visible = true;
    private boolean generated = true;
    boolean hasBindedData = false;

    public WebControl(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
        if (scope instanceof WebControlContainer) {
            this.parent = (WebControlContainer)scope;
        }
        if (this.parent != null) {
            this.font.setParent(this.parent.getFont());
        }
    }

    protected WebControl(Task task, Scriptable scope, int id, String name) {
        super(task, name, id);
        if (scope instanceof WebControlContainer) {
            this.parent = (WebControlContainer)scope;
        }
        if (this.parent != null) {
            this.font.setParent(this.parent.getFont());
        }
    }

    public abstract WebControl createClone(Task var1, Scriptable var2) throws InformException;

    public void setupDatamodel(Datamodel datamodel) {
    }

    protected void assignProps(WebControl control) {
        this.width = control.width;
        this.marginBottom = control.marginBottom;
        this.marginTop = control.marginTop;
        this.font.assignValues(control.font);
        this.color = control.color;
        this.visible = control.visible;
        this.generated = control.generated;
    }

    public void setParentControl(WebControlContainer parent) {
        this.parent = parent;
        if (parent != null) {
            this.font.setParent(parent.getFont());
        }
    }

    Document getDocument() {
        return ((ReportTask)this.task).getDocument();
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void beforeGenerate() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 6: {
                this.font.load(in.getStreamReader());
                break;
            }
            case 7: {
                this.color = in.getInt();
                break;
            }
            case 8: {
                this.visible = false;
                break;
            }
            case 2: {
                this.width = in.getDouble();
                break;
            }
            case 3: {
                this.height = in.getDouble();
                break;
            }
            case 9: {
                this.marginTop = in.getDouble();
                break;
            }
            case 10: {
                this.marginBottom = in.getDouble();
                break;
            }
            case 13: {
                this.generated = false;
            }
        }
    }

    public static String cloneName(WebControlContainer controlContainer, String name) {
        if (name != null && controlContainer != null && controlContainer.getByName(name) == null) {
            return name;
        }
        return null;
    }

    public boolean isSubControl() {
        return false;
    }

    @Override
    public abstract void afterLoad() throws InformException;

    public abstract void print(Writer var1) throws IOException;

    public WebControl getParent() {
        return this.parent;
    }

    public int getIndex() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.controls.indexOf(this);
    }

    public Font getFont() {
        return this.font;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

