/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.document.Type;
import java.io.IOException;
import java.util.ArrayList;

public class Components {
    final ArrayList<DocComponent> elements = new ArrayList();

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public DocComponent add(DocComponent element) {
        this.elements.add(element);
        return element;
    }

    public DocComponent addText(Document report, Object[] args) throws InformException {
        DocText result = null;
        for (Object arg : args) {
            DocText text = arg == null ? new DocText((IDocumentElement)report) : new DocText(report, ValueCaster.toString(arg));
            this.elements.add(text);
            if (result != null) continue;
            result = text;
        }
        if (result == null) {
            result = new DocText((IDocumentElement)report);
            this.elements.add(result);
        }
        return result;
    }

    public void prepareStore() {
        for (DocComponent element : this.elements) {
            element.prepareStore();
        }
    }

    public void cleanup() {
        for (DocComponent element : this.elements) {
            element.finalizeDocument();
        }
    }

    public void store(TaggedWriter out, ByteArrayOutputStream value) throws InformException, IOException {
        out.putEmpty(39);
        if (value != null && value.size() != 0) {
            out.putInt32(1, Type.TEXT.value());
            out.putRaw(202, value);
        }
        for (DocComponent element : this.elements) {
            if (!element.isVisible()) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(stream);
            element.store(writer);
            writer.flush();
            if (stream.size() == 0) continue;
            out.putInt32(1, element.getType().value());
            out.putRaw(202, stream);
        }
    }
}

