/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.DataType;
import inform.agent.scripts.format.Format;
import inform.agent.web.reports.controls.ReportCell;
import inform.agent.web.reports.document.Components;
import inform.agent.web.reports.document.Container;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocColumn;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocElement;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.document.Type;
import inform.agent.web.reports.style.CellStyle;
import inform.agent.web.reports.style.DocCellStyle;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.FormattedValue;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.KeyValues;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.TextOrientation;
import inform.agent.web.utils.VerticalAlign;
import java.io.IOException;
import java.util.Collections;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class DocCell
implements Container,
IDocumentElement {
    ProxyDocCell _proxyCell = null;
    ReportCell control = null;
    boolean generated = false;
    private final Components components = new Components();
    DocColumn column;
    final DocRow row;
    private boolean isBegin;
    boolean isFormula = false;
    String urlLink = "";
    DocCell effectiveCell = null;
    FormattedValue value = null;
    long hashKey = 0L;
    protected final Document _document;

    public DocCell(DocColumn column, DocRow row) {
        this._document = row.document;
        this.column = column;
        this.row = row;
    }

    public DocTable getTable() {
        if (this.row == null) {
            return null;
        }
        return this.row.getTable();
    }

    public boolean isVisible() {
        return this.column.isVisible();
    }

    public void setControl(ReportCell control) {
        this.control = control;
        this.generated = true;
    }

    @Override
    public Document getDocument() {
        return this._document;
    }

    @Override
    public IDocumentElement getParent() {
        return this.row;
    }

    @Override
    public Type getType() {
        return Type.CELL;
    }

    @Override
    public int getEffectiveColor() {
        int color = this._document.getFattyCellStyleById(this.hashKey).getColor();
        if (color == 0x1FFFFFFF) {
            int rowColor = this.row.getEffectiveColor();
            if (rowColor == 0x1FFFFFFF) {
                return this.column.getEffectiveColor();
            }
            return rowColor;
        }
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            color = this._proxyCell.getColor();
            if (color == 0x1FFFFFFF) {
                int rowColor = this.row.getEffectiveColor();
                if (rowColor == 0x1FFFFFFF) {
                    return this.column.getEffectiveColor();
                }
                return rowColor;
            }
            return color;
        }
        return color;
    }

    @Override
    public Font getEffectiveFont() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getEffectiveFont();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getFont();
    }

    public int getColor() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getColor();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getColor();
    }

    public FormattedValue getCellValue() {
        return this.value;
    }

    public boolean isCellValueEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    public boolean isCellWordWrap() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.wordWrap;
        }
        return this._document.getFattyCellStyleById(this.hashKey).getWord_wrap();
    }

    public boolean isCellFormula() {
        return this.isFormula;
    }

    public DataType getDataType() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.dataType;
        }
        return DataType.getDataTypeById(this._document.getFattyCellStyleById(this.hashKey).getDataType());
    }

    public boolean isCellFormatSeparateThausand() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.isCellFormatSeparateThausand();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getIsFormatSeparateThausand();
    }

    public int getCellFormatScale() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getCellFormatScale();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getFormatScale();
    }

    public int getCellFormatId() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getCellFormatId();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getFormatId();
    }

    public boolean isCellFormatKeepTailZero() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.isCellFormatKeepTailZero();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getIsKeepTailZero();
    }

    public Borders effectiveBorders() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.effectiveBorders();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getBorders();
    }

    public void prepareStore() {
        this.components.prepareStore();
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            this._proxyCell.prepareStore();
        } else if (this.value != null) {
            this.value.fixateValue();
        }
    }

    public HorizontalAlign horizontalAlign() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.horizontalAlign();
        }
        return HorizontalAlign.create(this._document.getFattyCellStyleById(this.hashKey).getHorizontalAlign());
    }

    public VerticalAlign verticalAlign() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.verticalAlign();
        }
        return VerticalAlign.create(this._document.getFattyCellStyleById(this.hashKey).getVerticalAlign());
    }

    public boolean isGenerated() {
        return this.generated && this == this.effectiveCell;
    }

    public void store(TaggedWriter out) throws InformException, IOException {
        if (!this.generated || this != this.effectiveCell) {
            return;
        }
    }

    public String getUrlLink() {
        return this.urlLink;
    }

    public int borders() {
        return DocBorders.assign(this._document, this.effectiveBorders());
    }

    public void beforeLoad() throws InformException, IOException {
        this.generated = true;
        this.isBegin = false;
    }

    public void afterLoad() throws InformException, IOException {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            this._proxyCell.afterLoad();
        }
    }

    public void load(TaggedReader in) throws InformException, IOException {
        this.beforeLoad();
        while (in.next()) {
            this.readTag(in.getCurrentTag(), in);
        }
        this.afterLoad();
    }

    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 55: {
                this.hashKey = in.getUnsignedInt();
                this.column = this.row.getTable().getColumns().get(this._document.getFattyCellStyleById(this.hashKey).getCol_index());
                break;
            }
            case 46: {
                this._proxyCell = new ProxyDocCell();
                this._proxyCell.colIdx = in.getInt();
                this.column = this.row.getTable().getColumns().get(this._proxyCell.colIdx);
                this._proxyCell.beforeLoad();
                break;
            }
            case 53: {
                this._proxyCell._left = in.getDouble();
                break;
            }
            case 2: {
                this._proxyCell.borders.load(in.getSubStreamReader());
                break;
            }
            case 3: {
                this._proxyCell.hAlign = HorizontalAlign.create(in.getInt());
                break;
            }
            case 4: {
                this._proxyCell.vAlign = VerticalAlign.create(in.getInt());
                break;
            }
            case 41: {
                this._proxyCell.colSpan = in.getInt();
                break;
            }
            case 42: {
                this._proxyCell.rowSpan = in.getInt();
                break;
            }
            case 5: {
                this._proxyCell.width = in.getDouble();
                break;
            }
            case 40: {
                TaggedReader reader = in.getSubStreamReader();
                this._proxyCell.cellMargins.load(reader);
                this._proxyCell.cellMargins.update();
                break;
            }
            case 43: {
                this._proxyCell.suppress = in.getInt();
                break;
            }
            case 54: {
                this.urlLink = in.getAnsi();
                break;
            }
            case 44: {
                this._proxyCell.wordWrap = true;
                break;
            }
            case 47: {
                this.isFormula = true;
                break;
            }
            case 48: {
                this._proxyCell.dataType = DataType.getDataTypeById(in.getInt());
                break;
            }
            case 49: {
                this._proxyCell.isFormatSeparateThausand = true;
                break;
            }
            case 50: {
                this._proxyCell.formatScale = in.getInt();
                break;
            }
            case 51: {
                this._proxyCell.isKeepTailZero = true;
                break;
            }
            case 52: {
                this._proxyCell.formatId = in.getInt();
                break;
            }
            case 45: {
                this._proxyCell.orientation = TextOrientation.create(in.getInt());
                break;
            }
            case 39: {
                this.isBegin = true;
                break;
            }
            case 1: {
                if (!this.isBegin) break;
                Type type = Type.create(in.getInt());
                switch (type) {
                    case TEXT: {
                        DocText text = this.addText();
                        text.load(in.getStreamReader());
                        break;
                    }
                    case IMAGE: {
                        DocImage image = this.addImage();
                        image.load(in.getStreamReader());
                        break;
                    }
                    case PARAGRAPH: {
                        DocParagraph parag = this.addParagraph();
                        parag.load(in.getStreamReader());
                    }
                }
                break;
            }
            default: {
                this._proxyCell.readTag(tag, in);
            }
        }
    }

    public String getClassName() {
        return "ReportCell";
    }

    @Override
    public DocText addText() {
        return (DocText)this.components.add(new DocText(this));
    }

    @Override
    public DocImage addImage() {
        return (DocImage)this.components.add(new DocImage(this));
    }

    private DocParagraph addParagraph() {
        DocSection section = (DocSection)this.row.table.getParent();
        return (DocParagraph)this.components.add(new DocParagraph(section));
    }

    public static Object appendText(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        DocCell cell = (DocCell)((Object)thisObj);
        return cell.components.addText(cell._document, args);
    }

    public int getAlign() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getAlign();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getHorizontalAlign();
    }

    public int getVertAlign() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getVertAlign();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getVerticalAlign();
    }

    public int getTextOrientation() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getTextOrientation();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getOrientation();
    }

    public TableMargins getSimpleCellMargins() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getSimpleCellMargins();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getMargins();
    }

    public TableMargins getCellMargins() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getCellMargins();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getMargins();
    }

    public TableMargins getMargins() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getMargins();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getMargins();
    }

    public Iterable<DocComponent> components() {
        return Collections.unmodifiableCollection(this.components.elements);
    }

    @Override
    public double getWidth() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getWidth();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getWidth();
    }

    public double left() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell._left;
        }
        return this._document.getFattyCellStyleById(this.hashKey).getLeft();
    }

    public int colSpan() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.colSpan;
        }
        return this._document.getFattyCellStyleById(this.hashKey).getColspan();
    }

    public int rowSpan() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.rowSpan;
        }
        return this._document.getFattyCellStyleById(this.hashKey).getRowspan();
    }

    public long getHashKey() {
        return this.hashKey;
    }

    public void setEffectiveCell(DocCell cell) {
        this.effectiveCell = cell;
    }

    public int getColIdx() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.colIdx;
        }
        return this._document.getFattyCellStyleById(this.hashKey).getCol_index();
    }

    public DocCell effectiveCell() {
        if (this.effectiveCell != null) {
            return this.effectiveCell;
        }
        return this;
    }

    @Override
    public Font getFont() {
        if (!this._document.useHashedCellStyle && this._proxyCell != null) {
            return this._proxyCell.getFont();
        }
        return this._document.getFattyCellStyleById(this.hashKey).getFont();
    }

    private class ProxyDocCell
    extends DocElement {
        private double _left;
        private Borders borders;
        private HorizontalAlign hAlign;
        private VerticalAlign vAlign;
        private int docBorders;
        private int colSpan;
        private int rowSpan;
        private int colIdx;
        private KeyValues downMergeKey;
        private KeyValues rightMergeKey;
        private int summaryFunction;
        private int suppress;
        private boolean wordWrap;
        private TextOrientation orientation;
        private DataType dataType;
        private boolean isFormatSeparateThausand;
        private boolean isKeepTailZero;
        private int formatScale;
        private int formatId;
        private TableMargins cellMargins;

        public ProxyDocCell() {
            super(DocCell.this._document);
            this._left = 0.0;
            this.hAlign = null;
            this.vAlign = null;
            this.docBorders = 0;
            this.colIdx = -1;
            this.downMergeKey = null;
            this.rightMergeKey = null;
            this.summaryFunction = 0;
            this.suppress = 0;
            this.wordWrap = false;
            this.orientation = null;
            this.dataType = DataType.NONE;
            this.isFormatSeparateThausand = false;
            this.isKeepTailZero = false;
            this.formatScale = -1;
            this.formatId = 0;
            this.cellMargins = new TableMargins();
            this.borders = new Borders(null);
        }

        @Override
        public IDocumentElement getParent() {
            return DocCell.this.row;
        }

        @Override
        public Type getType() {
            return Type.CELL;
        }

        public DocCellStyle cellStyle() {
            return (DocCellStyle)this.textStyle();
        }

        @Override
        public int getEffectiveColor() {
            int color = this.getColor();
            if (color == 0x1FFFFFFF) {
                int rowColor = DocCell.this.row.getEffectiveColor();
                if (rowColor == 0x1FFFFFFF) {
                    return DocCell.this.column.getEffectiveColor();
                }
                return rowColor;
            }
            return color;
        }

        @Override
        public void setColor(int color) {
            super.setColor(color);
        }

        public void setDownMergeKey(KeyValues downMergeKey) {
            if (downMergeKey == null || downMergeKey.isEmpty()) {
                this.downMergeKey = null;
                return;
            }
            if (this.downMergeKey == null) {
                this.downMergeKey = new KeyValues(null, null);
            }
            this.downMergeKey.assign(downMergeKey);
        }

        public void setRightMergeKey(KeyValues rightMergeKey) {
            if (rightMergeKey == null || rightMergeKey.isEmpty()) {
                this.rightMergeKey = null;
                return;
            }
            if (this.rightMergeKey == null) {
                this.rightMergeKey = new KeyValues(null, null);
            }
            this.rightMergeKey.assign(rightMergeKey);
        }

        public void setSummaryFunction(int summaryFunction) {
            this.summaryFunction = summaryFunction;
        }

        public boolean isCellWordWrap() {
            return this.wordWrap;
        }

        public boolean isCellFormula() {
            return DocCell.this.isFormula;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public boolean isCellFormatSeparateThausand() {
            return this.isFormatSeparateThausand;
        }

        public int getCellFormatScale() {
            return this.formatScale;
        }

        public int getCellFormatId() {
            return this.formatId;
        }

        public boolean isCellFormatKeepTailZero() {
            return this.isKeepTailZero;
        }

        public Borders effectiveBorders() {
            if (this.borders.isInherited() && DocCell.this.control != null) {
                return DocCell.this.control.getBorders();
            }
            return this.borders;
        }

        @Override
        public void prepareStore() {
            super.prepareStore();
            if (DocCell.this.value != null) {
                DocCell.this.value.fixateValue();
            }
        }

        public void setHAlign(HorizontalAlign hAlign) {
            this.hAlign = hAlign;
        }

        public HorizontalAlign horizontalAlign() {
            HorizontalAlign ha = this.hAlign != null ? this.hAlign : (DocCell.this.control != null ? DocCell.this.control.horizontalAlign() : HorizontalAlign.DEFAULT);
            if (ha == HorizontalAlign.DEFAULT) {
                Format format;
                ha = HorizontalAlign.LEFT;
                if (DocCell.this.value != null && (format = DocCell.this.value.getFormat()) != null) {
                    ha = format.getAlignment().toTextAlign();
                }
            }
            return ha;
        }

        public void setVAlign(VerticalAlign vAlign) {
            this.vAlign = vAlign;
        }

        public VerticalAlign verticalAlign() {
            if (this.vAlign != null) {
                return this.vAlign;
            }
            if (DocCell.this.control != null) {
                return DocCell.this.control.verticalAlign();
            }
            return VerticalAlign.DEFAULT;
        }

        @Override
        public void beforeLoad() throws InformException, IOException {
            super.beforeLoad();
            this.hAlign = HorizontalAlign.DEFAULT;
            this.vAlign = VerticalAlign.DEFAULT;
        }

        @Override
        public void afterLoad() throws InformException, IOException {
            Font font = this.getEffectiveFont();
            this.docStyle = this.document.cellStyles().add(this.document, font, this.getEffectiveColor(), this.cellMargins);
            this.style = null;
        }

        public int getAlign() {
            if (this.hAlign != null) {
                return this.hAlign.value();
            }
            if (DocCell.this.control != null) {
                return DocCell.this.control.getAlign();
            }
            return HorizontalAlign.LEFT.value();
        }

        public void setAlign(int hAlign) {
            this.hAlign = HorizontalAlign.create(hAlign);
        }

        public int getVertAlign() {
            if (this.vAlign != null) {
                return this.vAlign.value();
            }
            if (DocCell.this.control != null) {
                return DocCell.this.control.getVertAlign();
            }
            return VerticalAlign.DEFAULT.value();
        }

        public void setVertAlign(int vAlign) {
            this.vAlign = VerticalAlign.create(vAlign);
        }

        public int getTextOrientation() {
            if (this.orientation != null) {
                return this.orientation.value();
            }
            return TextOrientation.LEFT_RIGHT.value();
        }

        public TableMargins getSimpleCellMargins() {
            return this.cellMargins;
        }

        public TableMargins getCellMargins() {
            if (this.docStyle == null) {
                this.actualizeStyle();
            }
            return ((DocCellStyle)this.docStyle).getMargins();
        }

        public TableMargins getMargins() {
            this.createStyle();
            return ((CellStyle)this.style).getMargins();
        }

        @Override
        protected void createStyle() {
            if (this.style == null) {
                if (this.docStyle != null) {
                    DocCellStyle s = (DocCellStyle)this.docStyle;
                    this.style = new CellStyle(s.getFont(), s.getColor(), s.getMargins());
                } else {
                    this.style = new CellStyle(this.document.getFont());
                }
            }
        }

        @Override
        protected void actualizeStyle(Document document) {
            if (this.style == null && this.docStyle != null) {
                return;
            }
            Font font = this.getFont();
            this.docStyle = document.cellStyles().add(document, font, this.getEffectiveColor(), this.getMargins());
            this.style = null;
        }
    }
}

