/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.generators;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.AbstractHash;
import inform.adt.collections.Hashing;
import inform.agent.db.types.DataType;
import inform.agent.web.reports.controls.PageNumbers;
import inform.agent.web.reports.controls.ReportPageOrientation;
import inform.agent.web.reports.controls.SheetProtection;
import inform.agent.web.reports.document.DocBorders;
import inform.agent.web.reports.document.DocCell;
import inform.agent.web.reports.document.DocComponent;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.DocParagraph;
import inform.agent.web.reports.document.DocRow;
import inform.agent.web.reports.document.DocSection;
import inform.agent.web.reports.document.DocTable;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.Type;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.ImageInfo;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.TextOrientation;
import inform.agent.web.utils.VerticalAlign;
import inform.common.Base64BinString;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ODSGenerator
implements WebReportGenerator {
    private final Document doc;
    private final String caption;
    private static final double K_MMP096 = 3.593;
    private static final int ALIGN_REGION_DEFAULT = -1;
    private static final int ALIGN_REGION_LEFT = 0;
    private static final int ALIGN_REGION_CENTER = 1;
    private static final int ALIGN_REGION_RIGHT = 2;
    private int _clientSpan;
    private double _clientWidth;
    private int _colStyleIndex;
    private int _tableStyleIndex;
    private double _YPos;
    private int _sectionIndex;
    private int _cellIndex;
    private int _prevCellIndex;
    private int _rowIndex;
    private int _tableIndex;
    private String _sectionCaption;
    private boolean _pageBreakStarted;
    private double _rowHeight;
    private String _activeListName;
    private String _currentListName;
    private int _frozenRowCount;
    private int _frozenColCount;
    private int _zoom = 100;
    private DocSection _firstSection = null;
    private DocSection _currSection = null;
    private boolean _sectionBodyStarted;
    private String _startRowDef;
    private boolean _tableHeaderStarted;
    private boolean _hasAutoFilter;
    private boolean _isAutoFilter;
    private int _autoFilterBeginRowIndex;
    private int _autoFilterEndRowIndex;
    private int _autoFilterBeginCellIndex;
    private int _autoFilterEndCellIndex;
    CellParams _cellParams = new CellParams();
    RowParams _rowParams = new RowParams();
    String _cellText = "";
    DocTable _currTable = null;
    StringBuilder _headerText = new StringBuilder();
    StringBuilder _footerText = new StringBuilder();
    int _headerAlign = -1;
    int _footerAlign = -1;
    private boolean _useHeaderText = false;
    private boolean _useFooterText = false;
    private Font _headerFont = null;
    private Font _footerFont = null;
    private final CellStyleTable _cellStyleTable = new CellStyleTable();
    private final RowStyleTable _rowStyleTable = new RowStyleTable();
    private ZipOutputStream _zipOutputStream = null;
    private final StringBuilder _manifestContent = new StringBuilder();
    private final StringBuilder _settingsContent = new StringBuilder();
    private final StringBuilder _contentHeadContent = new StringBuilder();
    private final StringBuilder _contentAutomaticStylesContent = new StringBuilder();
    private final StringBuilder _contentBodyContent = new StringBuilder();
    private final StringBuilder _stylesHeadContent = new StringBuilder();
    private final StringBuilder _stylesAutomaticStylesContent = new StringBuilder();
    private final StringBuilder _stylesMasterStylesContent = new StringBuilder();
    private StringBuilder _settingsBuffer = new StringBuilder();
    private StringBuilder _shapesBuffer = new StringBuilder();
    private StringBuilder _rowBuffer = new StringBuilder();
    private final StringBuilder _rangeBuffer = new StringBuilder();
    private final ArrayList<String> _mediaFileNames = new ArrayList();
    private final ArrayList<ImageDef> _imageDefs = new ArrayList();
    private double[] _widths = null;
    private int[] _mergedRows = null;

    public ODSGenerator(Document doc, String caption) throws Exception {
        this.doc = doc;
        this.caption = URLEncoder.encode(caption, "UTF-8").replace('+', ' ');
    }

    @Override
    public void generateHeaders(HttpServletResponse resp) throws Exception {
        resp.setContentType("application/vnd.oasis.opendocument.text ");
        resp.setHeader("Content-disposition", String.format("attachment; filename*=\"utf8'ru-ru'%s.ods\"", this.caption.isEmpty() ? "noname" : this.caption));
    }

    @Override
    public void generateBody(OutputStream out, String encoding) throws Exception {
        this._colStyleIndex = 0;
        this._tableStyleIndex = 0;
        this._YPos = 0.0;
        this._sectionIndex = 0;
        this._cellIndex = 0;
        this._prevCellIndex = 0;
        this._rowIndex = 0;
        this._sectionCaption = "";
        this._pageBreakStarted = false;
        this._rowHeight = 0.0;
        this._activeListName = "";
        this._currentListName = "";
        this._tableIndex = 0;
        this._settingsContent.append(this.getSettingsTemplate());
        this._manifestContent.append(this.getManifestTemplate());
        this._contentHeadContent.append(this.getContentTemplate());
        this._contentAutomaticStylesContent.append("<office:automatic-styles>");
        this._contentBodyContent.append("<office:body><office:spreadsheet");
        this._stylesHeadContent.append(this.getStylesTemplate());
        this._stylesAutomaticStylesContent.append("<office:automatic-styles>");
        this._stylesMasterStylesContent.append("<office:master-styles>");
        this._rangeBuffer.append("<table:database-ranges>");
        for (DocSection s : this.doc.sections()) {
            if (this._firstSection == null) {
                this._firstSection = s;
                this._zoom = this._firstSection.getZoom();
                this.fillHeaderFooterText(this._firstSection.getFirstPageHeader(), true);
                this.fillHeaderFooterText(this._firstSection.getOtherPageHeader(), true);
                this.fillHeaderFooterText(this._firstSection.getAllPagesHeader(), true);
                this.fillHeaderFooterText(this._firstSection.getFirstPageFooter(), false);
                this.fillHeaderFooterText(this._firstSection.getOtherPageFooter(), false);
                this.fillHeaderFooterText(this._firstSection.getAllPagesFooter(), false);
                this.putHeaderFooterStyle();
                this._useHeaderText = !this._headerText.toString().isEmpty();
                this._useFooterText = !this._footerText.toString().isEmpty();
            }
            this._currSection = s;
            this.beginSection(s);
            this.beginSectionBody();
            this.generateComponents(s.elements());
            this.endSectionBody();
            this.endSection();
        }
        this._rangeBuffer.append("</table:database-ranges>");
        this._contentBodyContent.append(this._rangeBuffer.toString());
        this._stylesAutomaticStylesContent.append("</office:automatic-styles>");
        this._stylesMasterStylesContent.append("</office:master-styles></office:document-styles>");
        this._contentAutomaticStylesContent.append("</office:automatic-styles>");
        this._contentBodyContent.append("</office:spreadsheet></office:body></office:document-content>");
        this._manifestContent.append("</manifest:manifest>");
        this._settingsContent.append("</config:config-item-map-named><config:config-item config:name=\"ActiveTable\" config:type=\"string\">");
        this._settingsContent.append(this._activeListName);
        this._settingsContent.append("</config:config-item>");
        this._settingsContent.append(this.getSettingsEndTemplate());
        this._zipOutputStream = new ZipOutputStream(out);
        this._zipOutputStream.setMethod(8);
        this.putMimeType();
        this.putMeta();
        this.putStyles();
        this.putContent();
        this.putSettings();
        this.putManifest();
        this.putMedia();
        this._zipOutputStream.finish();
    }

    private static String getODSHash(String value) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] hashInBytes = md.digest(value.getBytes(StandardCharsets.UTF_16LE));
        return Base64BinString.Encode(hashInBytes);
    }

    private void beginSection(DocSection section) throws Exception {
        int i;
        ++this._sectionIndex;
        this._sectionCaption = section.getPageCaption();
        if (this._sectionIndex == 1) {
            if (section.getPassword().isEmpty()) {
                this._contentBodyContent.append(">");
            } else {
                this._contentBodyContent.append(" table:protection-key=\"");
                this._contentBodyContent.append(ODSGenerator.getODSHash(section.getPassword()));
                this._contentBodyContent.append("\" table:structure-protected=\"true\">");
            }
        }
        this._clientSpan = section.widths.size();
        if (this._clientSpan == 0) {
            this._clientSpan = 1;
        }
        this._clientWidth = section.getPageWidth() - section.margins().getLeft() - section.margins().getRight();
        if (this._clientSpan == 1) {
            this._widths = new double[1];
            this._widths[0] = this._clientWidth;
        } else {
            this._widths = new double[this._clientSpan];
            for (i = 0; i < this._clientSpan; ++i) {
                this._widths[i] = section.widths.get(i);
            }
        }
        this._mergedRows = new int[this._clientSpan];
        for (i = 0; i < this._mergedRows.length; ++i) {
            this._mergedRows[i] = 0;
        }
        this._rowIndex = 0;
        this._YPos = 0.0;
        StringBuilder style = new StringBuilder();
        style.append(String.format("<style:page-layout style:name=\"PL%d\">", this._sectionIndex));
        style.append("<style:page-layout-properties");
        String buffer = section.getOrientation() == ReportPageOrientation.PORTRAIT ? "portrait" : "landscape";
        style.append(String.format(" style:print-orientation=\"%s\"", buffer));
        buffer = ODSGenerator.getInchStrFromMM(section.getPageWidth());
        style.append(String.format(" fo:page-width=\"%sin\"", buffer));
        buffer = ODSGenerator.getInchStrFromMM(section.getPageHeight());
        style.append(String.format(" fo:page-height=\"%sin\"", buffer));
        buffer = ODSGenerator.getInchStrFromMM(section.margins().getLeft());
        style.append(String.format(" fo:margin-left=\"%sin\"", buffer));
        buffer = ODSGenerator.getInchStrFromMM(section.margins().getRight());
        style.append(String.format(" fo:margin-right=\"%sin\"", buffer));
        buffer = ODSGenerator.getInchStrFromMM(section.margins().getTop());
        style.append(String.format(" fo:margin-top=\"%sin\"", buffer));
        buffer = ODSGenerator.getInchStrFromMM(section.margins().getBottom());
        style.append(String.format(" fo:margin-bottom=\"%sin\"", buffer));
        style.append(" style:num-format=\"1\"");
        style.append("></style:page-layout-properties>");
        PageNumbers pageNumber = this._firstSection.getPageNumbers();
        if (pageNumber.enabled && pageNumber.location == 0 || this._useHeaderText) {
            style.append("<style:header-style>");
            style.append("<style:header-footer-properties");
            style.append(" fo:margin-bottom=\"0.25cm\"");
            style.append(" fo:margin-right=\"0cm\"");
            style.append(" fo:margin-left=\"0cm\"");
            style.append(" fo:min-height=\"0.75cm\"/>");
            style.append("</style:header-style>");
        }
        if (pageNumber.enabled && pageNumber.location == 1 || this._useFooterText) {
            style.append("<style:footer-style>");
            style.append("<style:header-footer-properties");
            style.append(" fo:margin-top=\"0.25cm\"");
            style.append(" fo:margin-right=\"0cm\"");
            style.append(" fo:margin-left=\"0cm\"");
            style.append(" fo:min-height=\"0.75cm\"/>");
            style.append("</style:footer-style>");
        }
        style.append("</style:page-layout>");
        this._stylesAutomaticStylesContent.append(style.toString());
        style = new StringBuilder();
        style.append(String.format("<style:master-page style:name=\"MP%d\" style:page-layout-name=\"PL%d\">", this._sectionIndex, this._sectionIndex));
        this._stylesMasterStylesContent.append(style.toString());
        if (this._sectionIndex == 1) {
            this.putSectionHeader();
            this.putSectionFooter();
        }
    }

    private void beginSectionBody() throws Exception {
        int i;
        this._frozenRowCount = 0;
        this._frozenColCount = 0;
        String protectStr = this.getTableProtectString();
        ++this._tableStyleIndex;
        StringBuilder style = new StringBuilder();
        StringBuilder content = new StringBuilder();
        style.append("<style:style");
        style.append(String.format(" style:name=\"ta%d\"", this._tableStyleIndex));
        style.append(String.format(" style:master-page-name=\"MP%d\"", this._sectionIndex));
        style.append(" style:family=\"table\">");
        style.append("<style:table-properties");
        style.append(" table:border-model=\"collapsing\"");
        style.append(" style:writing-mode=\"lr-tb\" table:display=\"true\"");
        style.append("/></style:style>");
        if (this._sectionCaption.isEmpty()) {
            if (protectStr.isEmpty()) {
                content.append(String.format("<table:table table:name=\"\u041b\u0438\u0441\u0442%d\" table:style-name=\"ta%d\">", this._sectionIndex, this._tableStyleIndex));
            } else {
                content.append(String.format("<table:table table:name=\"\u041b\u0438\u0441\u0442%d\" table:style-name=\"ta%d\"%s", this._sectionIndex, this._tableStyleIndex, protectStr));
            }
            this._settingsBuffer.append(String.format("<config:config-item-map-entry config:name=\"\u041b\u0438\u0441\u0442%d\">", this._sectionIndex));
            this._currentListName = String.format("\u041b\u0438\u0441\u0442%d", this._sectionIndex);
            if (this._activeListName.isEmpty()) {
                this._activeListName = this._currentListName;
            }
        } else {
            if (protectStr.isEmpty()) {
                content.append(String.format("<table:table table:name=\"%s\" table:style-name=\"ta%d\">", this._sectionCaption, this._tableStyleIndex));
            } else {
                content.append(String.format("<table:table table:name=\"%s\" table:style-name=\"ta%d\"%s", this._sectionCaption, this._tableStyleIndex, protectStr));
            }
            this._settingsBuffer.append(String.format("<config:config-item-map-entry config:name=\"%s\">", this._sectionCaption));
            this._currentListName = this._sectionCaption;
            if (this._activeListName.isEmpty()) {
                this._activeListName = this._sectionCaption;
            }
        }
        this._imageDefs.clear();
        for (i = 0; i < this._clientSpan; ++i) {
            this._imageDefs.add(new ImageDef());
        }
        if (this._clientSpan > 1) {
            for (i = 0; i < this._clientSpan; ++i) {
                this._imageDefs.get(i).clear();
                ++this._colStyleIndex;
                content.append("<table:table-column table:default-cell-style-name=\"Default\"");
                content.append(String.format(" table:style-name=\"co%d\"/>", this._colStyleIndex));
                style.append("<style:style");
                style.append(String.format(" style:name=\"co%d\" style:family=\"table-column\">", this._colStyleIndex));
                style.append("<style:table-column-properties fo:break-before=\"auto\"");
                style.append(String.format(" style:column-width=\"%scm\"/>", ODSGenerator.getCmStrFromMM(this._widths[i])));
                style.append("</style:style>");
            }
        } else {
            this._imageDefs.get(0).clear();
            ++this._colStyleIndex;
            content.append("<table:table-column table:default-cell-style-name=\"Default\"");
            content.append(String.format(" table:style-name=\"co%d\"/>", this._colStyleIndex));
            style.append("<style:style");
            style.append(String.format(" style:name=\"co%d\" style:family=\"table-column\">", this._colStyleIndex));
            style.append("<style:table-column-properties fo:break-before=\"auto\"");
            style.append(String.format(" style:column-width=\"%scm\"/>", ODSGenerator.getCmStrFromMM(this._clientWidth)));
            style.append("</style:style>");
        }
        this._shapesBuffer = new StringBuilder();
        this._shapesBuffer.append("<table:shapes>");
        this._contentBodyContent.append(content.toString());
        this._contentAutomaticStylesContent.append(style.toString());
        this._sectionBodyStarted = true;
    }

    private String getHeaderFooterFontStyleDef(Font font, String name) throws Exception {
        StringBuilder content = new StringBuilder();
        content.append(String.format("<style:style style:name=\"%s\" style:family=\"text\">", name));
        content.append("<style:text-properties");
        String buffer = ODSGenerator.getColorString(font.getColor());
        if (!buffer.isEmpty()) {
            content.append(String.format(" fo:color=\"%s\"", buffer));
        }
        content.append(String.format(" fo:font-family=\"%s\"", font.getName()));
        content.append(String.format(" fo:font-size=\"%dpt\"", font.getSize()));
        buffer = "normal";
        if ((font.getStyle() & 2) != 0) {
            buffer = "italic";
        }
        content.append(String.format(" fo:font-style=\"%s\"", buffer));
        buffer = "normal";
        if ((font.getStyle() & 1) != 0) {
            buffer = "bold";
        }
        content.append(String.format(" fo:font-weight=\"%s\"", buffer));
        content.append(String.format(" style:font-name=\"%s\"", font.getName()));
        if ((font.getStyle() & 8) != 0) {
            content.append(" style:text-line-through-type=\"single\" style:text-line-through-style=\"solid\"");
        }
        buffer = "none";
        if ((font.getStyle() & 4) != 0) {
            buffer = "solid";
        }
        content.append(String.format(" style:text-underline-style=\"%s\"", buffer));
        if (buffer.equals("solid")) {
            content.append(" style:text-underline-color=\"font-color\"");
            content.append(" style:text-underline-mode=\"continuous\"");
        }
        content.append("/></style:style>");
        return content.toString();
    }

    private void putHeaderFooterStyle() throws Exception {
        Font footerFont;
        Font headerFont = this._headerFont;
        if (headerFont == null) {
            headerFont = this._firstSection.getFont();
        }
        if ((footerFont = this._footerFont) == null) {
            footerFont = this._firstSection.getFont();
        }
        this._stylesAutomaticStylesContent.append(this.getHeaderFooterFontStyleDef(headerFont, "headerTextStyle"));
        this._stylesAutomaticStylesContent.append(this.getHeaderFooterFontStyleDef(footerFont, "footerTextStyle"));
    }

    private void putSectionFooter() throws Exception {
        this._stylesMasterStylesContent.append(this.getHeaderText(false));
    }

    private void putSectionHeader() throws Exception {
        this._stylesMasterStylesContent.append(this.getHeaderText(true));
    }

    private void endSection() {
        if (this._sectionBodyStarted) {
            this.endSectionBody();
        }
        this._stylesMasterStylesContent.append("</style:master-page>");
    }

    private void endSectionBody() {
        this._shapesBuffer.append("</table:shapes>");
        this._contentBodyContent.append(this._shapesBuffer.toString());
        this._contentBodyContent.append("</table:table>");
        this._settingsBuffer.append("<config:config-item config:name=\"CursorPositionX\" config:type=\"int\">0</config:config-item>");
        this._settingsBuffer.append("<config:config-item config:name=\"CursorPositionY\" config:type=\"int\">0</config:config-item>");
        this._settingsBuffer.append("<config:config-item");
        this._settingsBuffer.append(" config:name=\"HorizontalSplitMode\"");
        this._settingsBuffer.append(" config:type=\"short\">");
        if (this._frozenColCount > 0) {
            this._settingsBuffer.append(2);
        } else {
            this._settingsBuffer.append(0);
        }
        this._settingsBuffer.append("</config:config-item>");
        this._settingsBuffer.append("<config:config-item");
        this._settingsBuffer.append(" config:name=\"VerticalSplitMode\"");
        this._settingsBuffer.append(" config:type=\"short\">");
        if (this._frozenRowCount > 0) {
            this._settingsBuffer.append(2);
        } else {
            this._settingsBuffer.append(0);
        }
        this._settingsBuffer.append("</config:config-item>");
        this._settingsBuffer.append("<config:config-item");
        this._settingsBuffer.append(" config:name=\"HorizontalSplitPosition\"");
        this._settingsBuffer.append(" config:type=\"int\">");
        this._settingsBuffer.append(String.format("%d", this._frozenColCount));
        this._settingsBuffer.append("</config:config-item>");
        this._settingsBuffer.append("<config:config-item");
        this._settingsBuffer.append(" config:name=\"VerticalSplitPosition\"");
        this._settingsBuffer.append(" config:type=\"int\">");
        this._settingsBuffer.append(String.format("%d", this._frozenRowCount));
        this._settingsBuffer.append("</config:config-item>");
        this._settingsBuffer.append("<config:config-item");
        this._settingsBuffer.append(" config:name=\"ActiveSplitRange\"");
        this._settingsBuffer.append(" config:type=\"short\">");
        if (this._frozenRowCount > 0 || this._frozenColCount > 0) {
            this._settingsBuffer.append(0);
        } else {
            this._settingsBuffer.append(2);
        }
        this._settingsBuffer.append("</config:config-item>");
        this._settingsBuffer.append("<config:config-item config:name=\"PositionLeft\" config:type=\"int\">0</config:config-item>");
        this._settingsBuffer.append(String.format("<config:config-item config:name=\"PositionRight\" config:type=\"int\">%d</config:config-item>", this._frozenColCount));
        this._settingsBuffer.append("<config:config-item config:name=\"PositionTop\" config:type=\"int\">0</config:config-item>");
        this._settingsBuffer.append(String.format("<config:config-item config:name=\"PositionBottom\" config:type=\"int\">%d</config:config-item>", this._frozenRowCount));
        this._settingsBuffer.append("<config:config-item config:name=\"ZoomType\" config:type=\"short\">0</config:config-item>");
        this._settingsBuffer.append(String.format("<config:config-item config:name=\"ZoomValue\" config:type=\"int\">%d</config:config-item>", this._zoom));
        this._settingsBuffer.append("<config:config-item config:name=\"PageViewZoomValue\" config:type=\"int\">60</config:config-item>");
        if (!this._firstSection.getGridNotShow()) {
            this._settingsBuffer.append("<config:config-item config:name=\"ShowGrid\" config:type=\"boolean\">true</config:config-item>");
        } else {
            this._settingsBuffer.append("<config:config-item config:name=\"ShowGrid\" config:type=\"boolean\">false</config:config-item>");
        }
        this._settingsBuffer.append("</config:config-item-map-entry>");
        this._settingsContent.append(this._settingsBuffer.toString());
        this._settingsBuffer = new StringBuilder();
        this._frozenRowCount = 0;
        this._frozenColCount = 0;
        this._sectionBodyStarted = false;
    }

    private void putMimeType() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("mimetype"));
        this._zipOutputStream.write("application/vnd.oasis.opendocument.spreadsheet".getBytes("UTF-8"));
    }

    private void putMeta() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("meta.xml"));
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-meta");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        content.append("    office:version=\"1.1\">");
        content.append("    <office:meta>");
        content.append("        <meta:generator>ASMO</meta:generator>");
        content.append("        <meta:initial-creator>");
        content.append("        </meta:initial-creator>");
        content.append("        <dc:creator>");
        content.append("        </dc:creator>");
        content.append("        <meta:creation-date>");
        content.append(DateTime.toString(DateTime.currentDate()));
        content.append("        </meta:creation-date>");
        content.append("        <dc:date></dc:date>");
        content.append("        <meta:template xlink:href=\"Normal\" xlink:type=\"simple\"/>");
        content.append("    </office:meta>");
        content.append("</office:document-meta>");
        this._zipOutputStream.write(content.toString().getBytes("UTF-8"));
    }

    private void putSettings() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("settings.xml"));
        this._zipOutputStream.write(this._settingsContent.toString().getBytes("UTF-8"));
    }

    private String getSettingsTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        content.append("<office:document-settings xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" office:version=\"1.2\">");
        content.append("  <office:settings>");
        content.append("    <config:config-item-set config:name=\"ooo:view-settings\">");
        content.append("      <config:config-item config:name=\"VisibleAreaTop\" config:type=\"int\">0</config:config-item>");
        content.append("      <config:config-item config:name=\"VisibleAreaLeft\" config:type=\"int\">0</config:config-item>");
        content.append("      <config:config-item config:name=\"VisibleAreaWidth\" config:type=\"int\">2257</config:config-item>");
        content.append("      <config:config-item config:name=\"VisibleAreaHeight\" config:type=\"int\">451</config:config-item>");
        content.append("      <config:config-item-map-indexed config:name=\"Views\">");
        content.append("        <config:config-item-map-entry>");
        content.append("          <config:config-item config:name=\"ViewId\" config:type=\"string\">view1</config:config-item>");
        content.append("          <config:config-item-map-named config:name=\"Tables\">");
        return content.toString();
    }

    private String getSettingsEndTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("          <config:config-item config:name=\"HorizontalScrollbarWidth\" config:type=\"int\">1255</config:config-item>");
        content.append("          <config:config-item config:name=\"ZoomType\" config:type=\"short\">0</config:config-item>");
        content.append("          <config:config-item config:name=\"ZoomValue\" config:type=\"int\">100</config:config-item>");
        content.append("          <config:config-item config:name=\"PageViewZoomValue\" config:type=\"int\">60</config:config-item>");
        content.append("          <config:config-item config:name=\"ShowPageBreakPreview\" config:type=\"boolean\">false</config:config-item>");
        content.append("          <config:config-item config:name=\"ShowZeroValues\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"ShowNotes\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"ShowGrid\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"GridColor\" config:type=\"long\">12632256</config:config-item>");
        content.append("          <config:config-item config:name=\"ShowPageBreaks\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"HasColumnRowHeaders\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"HasSheetTabs\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"IsOutlineSymbolsSet\" config:type=\"boolean\">true</config:config-item>");
        content.append("          <config:config-item config:name=\"IsValueHighlightingEnabled\" config:type=\"boolean\">false</config:config-item>");
        content.append("          <config:config-item config:name=\"IsSnapToRaster\" config:type=\"boolean\">false</config:config-item>");
        content.append("          <config:config-item config:name=\"RasterIsVisible\" config:type=\"boolean\">false</config:config-item>");
        content.append("          <config:config-item config:name=\"RasterResolutionX\" config:type=\"int\">1000</config:config-item>");
        content.append("          <config:config-item config:name=\"RasterResolutionY\" config:type=\"int\">1000</config:config-item>");
        content.append("          <config:config-item config:name=\"RasterSubdivisionX\" config:type=\"int\">1</config:config-item>");
        content.append("          <config:config-item config:name=\"RasterSubdivisionY\" config:type=\"int\">1</config:config-item>");
        content.append("          <config:config-item config:name=\"IsRasterAxisSynchronized\" config:type=\"boolean\">true</config:config-item>");
        content.append("        </config:config-item-map-entry>");
        content.append("      </config:config-item-map-indexed>");
        content.append("    </config:config-item-set>");
        content.append("    <config:config-item-set config:name=\"ooo:configuration-settings\">");
        content.append("      <config:config-item config:name=\"HasSheetTabs\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"ShowNotes\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"ShowZeroValues\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"ShowGrid\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"GridColor\" config:type=\"long\">12632256</config:config-item>");
        content.append("      <config:config-item config:name=\"ShowPageBreaks\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"IsKernAsianPunctuation\" config:type=\"boolean\">false</config:config-item>");
        content.append("      <config:config-item config:name=\"IsOutlineSymbolsSet\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"LinkUpdateMode\" config:type=\"short\">3</config:config-item>");
        content.append("      <config:config-item config:name=\"HasColumnRowHeaders\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"IsSnapToRaster\" config:type=\"boolean\">false</config:config-item>");
        content.append("      <config:config-item config:name=\"RasterIsVisible\" config:type=\"boolean\">false</config:config-item>");
        content.append("      <config:config-item config:name=\"RasterResolutionX\" config:type=\"int\">1000</config:config-item>");
        content.append("      <config:config-item config:name=\"RasterResolutionY\" config:type=\"int\">1000</config:config-item>");
        content.append("      <config:config-item config:name=\"RasterSubdivisionX\" config:type=\"int\">1</config:config-item>");
        content.append("      <config:config-item config:name=\"RasterSubdivisionY\" config:type=\"int\">1</config:config-item>");
        content.append("      <config:config-item config:name=\"IsRasterAxisSynchronized\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"AutoCalculate\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"ApplyUserData\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"PrinterName\" config:type=\"string\"/>");
        content.append("      <config:config-item config:name=\"PrinterSetup\" config:type=\"base64Binary\"/>");
        content.append("      <config:config-item config:name=\"CharacterCompressionType\" config:type=\"short\">0</config:config-item>");
        content.append("      <config:config-item config:name=\"SaveVersionOnClose\" config:type=\"boolean\">false</config:config-item>");
        content.append("      <config:config-item config:name=\"UpdateFromTemplate\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"AllowPrintJobCancel\" config:type=\"boolean\">true</config:config-item>");
        content.append("      <config:config-item config:name=\"LoadReadonly\" config:type=\"boolean\">false</config:config-item>");
        content.append("      <config:config-item config:name=\"IsDocumentShared\" config:type=\"boolean\">false</config:config-item>");
        content.append("      <config:config-item config:name=\"EmbedFonts\" config:type=\"boolean\">false</config:config-item>");
        content.append("    </config:config-item-set>");
        content.append("  </office:settings>");
        content.append("</office:document-settings>");
        return content.toString();
    }

    private String getStylesTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-styles");
        content.append("    xmlns:msoxl=\"http://schemas.microsoft.com/office/excel/formula\"");
        content.append("    xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        content.append("    xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        content.append("    xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        content.append("    xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        content.append("    xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        content.append("    xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\">");
        content.append("    <office:styles>");
        content.append("        <number:number-style");
        content.append("            style:name=\"N0\">");
        content.append("            <number:number");
        content.append("                number:min-integer-digits=\"1\"/>");
        content.append("        </number:number-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDDpMMpYYYY\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:month");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleMMpYYYY\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:month");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleYYYY\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDD\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDDpMM\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:month");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDDspMMMMspYYYY\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text> </number:text>");
        content.append("            <number:month");
        content.append("                number:style=\"long\"");
        content.append("                number:textual=\"true\"");
        content.append("                number:possessive-gorm=\"true\"/>");
        content.append("            <number:text> </number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleMMMMspYYYY\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:month");
        content.append("                number:style=\"long\"");
        content.append("                number:textual=\"true\"/>");
        content.append("            <number:text> </number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDDspMMMM\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text> </number:text>");
        content.append("            <number:month");
        content.append("                number:style=\"long\"");
        content.append("                number:textual=\"true\"");
        content.append("                number:possessive-gorm=\"true\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleMMMM\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:month");
        content.append("                number:style=\"long\"");
        content.append("                number:textual=\"true\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleQpYYYY\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:quarter");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleQ\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:quarter");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDDpMMpYYYYspHH\u0441MM\u0441SS\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:month");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text> </number:text>");
        content.append("            <number:hours");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>:</number:text>");
        content.append("            <number:minutes");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>:</number:text>");
        content.append("            <number:seconds");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleDDpMMpYYYYspHH\u0441MM\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:day");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:month");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>.</number:text>");
        content.append("            <number:year");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text> </number:text>");
        content.append("            <number:hours");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>:</number:text>");
        content.append("            <number:minutes");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleHH\u0441MM\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:hours");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>:</number:text>");
        content.append("            <number:minutes");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleHH\u0441MM\u0441SS\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:hours");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>:</number:text>");
        content.append("            <number:minutes");
        content.append("                number:style=\"long\"/>");
        content.append("            <number:text>:</number:text>");
        content.append("            <number:seconds");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <number:date-style");
        content.append("            style:name=\"dataStyleHH\"");
        content.append("            number:automatic-order=\"true\">");
        content.append("            <number:hours");
        content.append("                number:style=\"long\"/>");
        content.append("        </number:date-style>");
        content.append("        <style:style");
        content.append("            style:name=\"Default\"");
        content.append("            style:data-style-name=\"N0\"");
        content.append("            style:family=\"table-cell\">");
        content.append("            <style:table-cell-properties");
        content.append("                fo:background-color=\"transparent\"");
        content.append("                style:vertical-align=\"automatic\"/>");
        content.append("            <style:text-properties");
        content.append("                style:font-size-complex=\"11pt\"");
        content.append("                style:font-size-asian=\"11pt\"");
        content.append("                fo:font-size=\"11pt\"");
        content.append("                style:font-name-complex=\"Calibri\"");
        content.append("                style:font-name-asian=\"Calibri\"");
        content.append("                style:font-name=\"Calibri\"");
        content.append("                fo:color=\"#000000\"/>");
        content.append("        </style:style>");
        content.append("        <style:default-style");
        content.append("            style:family=\"graphic\">");
        content.append("            <style:graphic-properties");
        content.append("                svg:stroke-opacity=\"100%\"");
        content.append("                svg:stroke-color=\"#385d8a\"");
        content.append("                svg:stroke-width=\"0.02778in\"");
        content.append("                draw:stroke=\"solid\"");
        content.append("                draw:opacity=\"100%\"");
        content.append("                draw:fill-color=\"#4f81bd\"");
        content.append("                draw:fill=\"solid\"/>");
        content.append("        </style:default-style>");
        content.append("    </office:styles>");
        return content.toString();
    }

    private String getManifestTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<manifest:manifest");
        content.append("    xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"/\"");
        content.append("        manifest:media-type=\"application/vnd.oasis.opendocument.spreadsheet\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"META-INF/manifest.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"content.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"meta.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"settings.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"mimetype\"");
        content.append("        manifest:media-type=\"text/plain\"/>");
        content.append("    <manifest:file-entry");
        content.append("        manifest:full-path=\"styles.xml\"");
        content.append("        manifest:media-type=\"text/xml\"/>");
        return content.toString();
    }

    private String getContentTemplate() {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        content.append("<office:document-content");
        content.append("    xmlns:msoxl=\"http://schemas.microsoft.com/office/excel/formula\"");
        content.append("    xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        content.append("    xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\"");
        content.append("    xmlns:loext=\"urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0\"");
        content.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        content.append("    xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        content.append("    xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        content.append("    xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        content.append("    xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        content.append("    xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        content.append("    xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        content.append("    xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\">");
        return content.toString();
    }

    private void putStyles() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("styles.xml"));
        StringBuilder content = new StringBuilder();
        content.append(this._stylesHeadContent.toString());
        content.append(this._stylesAutomaticStylesContent.toString());
        content.append(this._stylesMasterStylesContent.toString());
        this._zipOutputStream.write(content.toString().getBytes("UTF-8"));
    }

    private void putContent() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("content.xml"));
        StringBuilder content = new StringBuilder();
        content.append(this._contentHeadContent.toString());
        content.append(this._contentAutomaticStylesContent.toString());
        content.append(this._contentBodyContent.toString());
        this._zipOutputStream.write(content.toString().getBytes("UTF-8"));
    }

    private void putManifest() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("META-INF/manifest.xml"));
        this._zipOutputStream.write(this._manifestContent.toString().getBytes("UTF-8"));
    }

    private void putMedia() throws Exception {
        if (!this._mediaFileNames.isEmpty()) {
            this._zipOutputStream.putNextEntry(new ZipEntry("pictures/"));
            for (int i = 0; i < this._mediaFileNames.size(); ++i) {
                this._zipOutputStream.putNextEntry(new ZipEntry("pictures/" + this._mediaFileNames.get(i)));
                this._zipOutputStream.write(this.doc.getImageContent(i));
            }
        }
    }

    private void generateComponents(Iterable<? extends DocComponent> components) throws Exception {
        for (DocComponent docComponent : components) {
            switch (docComponent.getType()) {
                case PARAGRAPH: {
                    this.generateParagraph((DocParagraph)docComponent);
                    break;
                }
                case PageBreak: {
                    break;
                }
                case TABLE: {
                    this.generateTable((DocTable)docComponent);
                    break;
                }
                case TEXT: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0435\u043a\u0441\u0442\u0430 \u0432\u043d\u0435 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430");
                }
            }
        }
    }

    private void beginParagraph(DocParagraph p) throws Exception {
        if (!this._sectionBodyStarted) {
            this.beginSectionBody();
        }
        if (!this._tableHeaderStarted) {
            this._tableHeaderStarted = true;
        }
        this._cellParams.clear();
        this._cellParams.colSpan = this._clientSpan;
        this._cellParams.width = this._clientWidth;
        this._cellParams.rowSpan = 1;
        this._cellParams.borders = DocBorders.assign(this.doc, p.getBorders());
        this._cellParams.align = p.align().value();
        this._cellParams.vertAlign = VerticalAlign.MIDDLE.value();
        this._cellParams.color = p.getColor();
        this._cellParams.dataType = DataType.STRING.getTypeId();
        this._cellParams.wordWrap = p.getWordWrap();
        this._cellText = "";
        this._rowHeight = p.getHeight();
        ImageDef def = this._imageDefs.get(0);
        def.x = 0.0;
        def.y = this._YPos;
        def.cellWidth = this._cellParams.width;
        this._imageDefs.get((int)0).margins.assign(this._cellParams.margins);
        def.horzAlign = this._cellParams.align;
        def.vertAlign = this._cellParams.vertAlign;
        this._cellIndex = 1;
        ++this._rowIndex;
    }

    private void endParagraph() throws Exception {
        this._rowBuffer = new StringBuilder();
        String startRowDef = "<table:table-row table:style-name=\"%s\">";
        CellStyleEntry cellStyleEntry = this._cellStyleTable.add(this._cellParams);
        this._rowBuffer.append(String.format("<table:table-cell table:style-name=\"%s\"", cellStyleEntry.getStyleName()));
        if (this._clientSpan > 1) {
            this._rowBuffer.append(String.format(" table:number-columns-spanned=\"%d\"", this._clientSpan));
        }
        this._rowBuffer.append(" office:value-type=\"string\"");
        this._rowBuffer.append(">");
        ImageDef def = this._imageDefs.get(0);
        if (!def.imageStarted) {
            this._rowBuffer.append(String.format("<text:p>%s</text:p>", this._cellText));
        } else {
            def.x = 0.0;
            def.y = this._YPos;
            this._rowHeight = Math.max(this._rowHeight, def.height);
            HorizontalAlign al = HorizontalAlign.create(def.horzAlign);
            switch (al) {
                case LEFT: 
                case WIDTH: 
                case DEFAULT: {
                    def.x = def.margins.getLeft();
                    break;
                }
                case CENTER: {
                    def.x = (this._clientWidth - def.width) / 2.0;
                    break;
                }
                case RIGHT: {
                    def.x = this._clientWidth - def.width - def.margins.getRight() - def.margins.getLeft();
                }
            }
            this._shapesBuffer.append(String.format(def.definition, ODSGenerator.getInchStrFromMM(def.x), def.y));
        }
        this._rowBuffer.append("</table:table-cell>");
        String buffer = "";
        for (int i = 2; i <= this._clientSpan; ++i) {
            buffer = buffer.concat("<table:covered-table-cell/>");
        }
        if (!buffer.isEmpty()) {
            this._rowBuffer.append(buffer);
        }
        if (!cellStyleEntry._isExists) {
            this._contentAutomaticStylesContent.append(cellStyleEntry.getStyleDef());
        }
        this._rowParams.height = this._rowHeight;
        RowStyleEntry rowStyleEntry = this._rowStyleTable.add(this._rowParams, this._pageBreakStarted);
        if (!rowStyleEntry._isExists) {
            this._contentAutomaticStylesContent.append(rowStyleEntry.getStyleDef());
        }
        this._cellText = "";
        for (int i = 0; i < this._imageDefs.size(); ++i) {
            this._imageDefs.get(i).clear();
        }
        this._rowBuffer.append("</table:table-row>");
        this._contentBodyContent.append(String.format(startRowDef, rowStyleEntry.getStyleName()));
        this._contentBodyContent.append(this._rowBuffer.toString());
        this._rowBuffer = new StringBuilder();
        this._YPos += this._rowHeight;
    }

    private void writeText(DocText text) throws Exception {
        this._cellText = this._cellText.concat(this.changeSpecSymb(text.getText()));
        this._cellParams.font.assign(text.getFont());
        if (text.getColor() != 0x1FFFFFFF) {
            this._cellParams.color = text.getColor();
        }
    }

    private void insertPicture(DocImage im) throws Exception {
        byte[] data = im.getImageContent();
        if (data == null) {
            return;
        }
        ImageInfo ii = new ImageInfo();
        String mimeType = "";
        String fileExt = "";
        if (im.getImageType() != 4 && im.getImageType() != 3) {
            ByteArrayInputStream bs = new ByteArrayInputStream(data);
            ii.setInput(bs);
            if (!ii.check()) {
                throw new Exception("Unsupported image format");
            }
            fileExt = ii.getFormatName();
            mimeType = ii.getMimeType();
        } else if (im.getImageType() == 3) {
            fileExt = "WMF";
            mimeType = "image/x-wmf";
        } else {
            fileExt = "EMF";
            mimeType = "image/x-emf";
        }
        this.doc.addImage(im);
        double width = im.getWidth();
        double height = im.getHeight();
        if (im.getImageType() != 4 && im.getImageType() != 3) {
            int pixelWidth = ii.getWidth();
            int pixelHeight = ii.getHeight();
            if (height == 0.0 || width == 0.0) {
                width = ODSGenerator.strangePixelsToMM(pixelWidth);
                height = ODSGenerator.strangePixelsToMM(pixelHeight);
            }
        }
        StringBuilder style = new StringBuilder();
        String fileName = String.format("image%d.%s", this.doc.getLastImageId(), fileExt);
        this._mediaFileNames.add(fileName);
        style.append("<manifest:file-entry");
        style.append(String.format(" manifest:media-type=\"%s\"", mimeType));
        style.append(String.format(" manifest:full-path=\"pictures/%s\"", fileName));
        style.append("/>");
        this._manifestContent.append(style.toString());
        style = new StringBuilder();
        style.append("<draw:frame ");
        style.append(" svg:x=\"%sin\"");
        style.append(" svg:y=\"%sin\"");
        if (im.getUseMultiCell()) {
            double w = 0.0;
            for (int i = this._cellIndex - 1; i < this._widths.length; ++i) {
                w += this._widths[i];
            }
            width = w;
        }
        style.append(String.format(" svg:width=\"%sin\"", ODSGenerator.getInchStrFromMM(width)));
        style.append(String.format(" svg:height=\"%sin\">", ODSGenerator.getInchStrFromMM(height)));
        style.append("<draw:image xlink:actuate=\"onLoad\"");
        style.append(" xlink:show=\"embed\" xlink:type=\"simple\"");
        style.append(String.format(" xlink:href=\"pictures/%s\"/>", fileName));
        style.append("</draw:frame>");
        ImageDef def = this._imageDefs.get(this._cellIndex - 1);
        def.imageStarted = true;
        def.height = height;
        def.width = width;
        def.definition = style.toString();
        def.restOfHeight = height;
        def.useMultiCell = im.getUseMultiCell();
    }

    private void generateParagraph(DocParagraph p) throws Exception {
        this.beginParagraph(p);
        for (DocComponent cm : p.components()) {
            switch (cm.getType()) {
                case PARAGRAPH: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TABLE: {
                    throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444");
                }
                case TEXT: {
                    this.writeText((DocText)cm);
                    break;
                }
                case IMAGE: {
                    this.insertPicture((DocImage)cm);
                }
            }
        }
        this.endParagraph();
    }

    private void addMerge() throws Exception {
        for (int i = 0; i < this._cellParams.colSpan; ++i) {
            this._mergedRows[this._cellIndex + i - 1] = this._rowIndex + this._cellParams.rowSpan;
        }
        if (this._cellParams.colSpan > 1) {
            this.applyMerge();
        }
    }

    private void applyMerge() throws Exception {
        while (this._cellIndex < this._mergedRows.length && this._rowIndex < this._mergedRows[this._cellIndex]) {
            ++this._cellIndex;
        }
    }

    private void generateTable(DocTable table) throws Exception {
        this.beginTable(table);
        for (DocRow row : table.rows()) {
            this.beginRow(row);
            for (DocCell cell : row.getCells()) {
                if (cell.getColIdx() == -1) continue;
                this.beginCell(cell);
                for (DocComponent cm : cell.components()) {
                    switch (cm.getType()) {
                        case PARAGRAPH: {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u0433\u0440\u0430\u0444\u0430 \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                        }
                        case TABLE: {
                            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u044f\u0447\u0435\u0439\u043a\u0443");
                        }
                        case TEXT: {
                            this.writeText((DocText)cm);
                            break;
                        }
                        case IMAGE: {
                            this.insertPicture((DocImage)cm);
                        }
                    }
                }
                this.endCell();
            }
            this.endRow();
        }
        this.endTable();
    }

    private static boolean sameValue(double a, double b, double epsilon) {
        if (epsilon == 0.0) {
            epsilon = Math.max(Math.min(Math.abs(a), Math.abs(b)) * 1.0E-13, 1.0E-13);
        }
        if (a > b) {
            return a - b <= epsilon;
        }
        return b - a <= epsilon;
    }

    private int calcCellSpan(int cellIndex, double cellWidth) {
        double width = 0.0;
        double prevWidth = 0.0;
        int res = 0;
        for (int i = cellIndex - 1; i < this._widths.length; ++i) {
            ++res;
            prevWidth = width;
            if (ODSGenerator.sameValue(width += this._widths[i], cellWidth, 0.01)) {
                return res;
            }
            if (!(width > cellWidth)) continue;
            if (!(cellWidth - prevWidth < width - cellWidth)) break;
            --res;
            break;
        }
        if (res == 0) {
            res = 1;
        }
        return res;
    }

    private void beginTable(DocTable table) throws Exception {
        if (!this._sectionBodyStarted) {
            this.beginSectionBody();
        }
        this._currTable = table;
        ++this._tableIndex;
        if (this._frozenColCount < table.fixed_cols) {
            this._frozenColCount = table.fixed_cols;
        }
        this._tableHeaderStarted = false;
        this._rowParams.level = 0;
        this._hasAutoFilter = false;
        this._isAutoFilter = false;
    }

    private void endTable() throws Exception {
        if (this._tableHeaderStarted) {
            this._tableHeaderStarted = false;
            this._contentBodyContent.append("</table:table-header-rows>");
        }
        while (this._rowParams.level > 0) {
            this._contentBodyContent.append("</table:table-row-group>");
            --this._rowParams.level;
        }
        if (!this._hasAutoFilter && this._isAutoFilter && this._autoFilterBeginRowIndex < this._autoFilterEndRowIndex) {
            this._hasAutoFilter = true;
            this._autoFilterBeginCellIndex = 1;
            this._autoFilterEndCellIndex = this.calcCellSpan(1, this._currTable.getTableWidth());
            String startRange = "\"" + this._currentListName + "\"." + ODSGenerator.getCellRef(this._autoFilterBeginCellIndex, this._autoFilterBeginRowIndex);
            String finishRange = "\"" + this._currentListName + "\"." + ODSGenerator.getCellRef(this._autoFilterEndCellIndex, this._autoFilterEndRowIndex);
            this._rangeBuffer.append("<table:database-range");
            this._rangeBuffer.append(String.format(" table:name=\"db_range_%d\"", this._tableIndex));
            this._rangeBuffer.append(" table:display-filter-buttons=\"true\"");
            this._rangeBuffer.append(String.format(" table:target-range-address=\"%s:%s\"/>", startRange, finishRange));
        }
    }

    private void beginRow(DocRow row) throws Exception {
        if (!this._sectionBodyStarted) {
            this.beginSectionBody();
        }
        this._rowBuffer = new StringBuilder();
        this._prevCellIndex = 0;
        this._cellIndex = 0;
        ++this._rowIndex;
        this.applyMerge();
        while (this._rowParams.level > row.level) {
            this._contentBodyContent.append("</table:table-row-group>");
            --this._rowParams.level;
        }
        for (int i = row.level; i > 0 && i > this._rowParams.level; --i) {
            if (row.hide_kind == 2) {
                this._contentBodyContent.append("<table:table-row-group table:display=\"false\">");
                continue;
            }
            this._contentBodyContent.append("<table:table-row-group table:display=\"true\">");
        }
        this._rowParams = new RowParams(row);
        this._rowHeight = row.getHeight();
        if (this._hasAutoFilter) {
            this._isAutoFilter = true;
            this._autoFilterBeginRowIndex = this._rowIndex;
        }
        if (this._isAutoFilter) {
            this._autoFilterEndRowIndex = this._rowIndex;
        }
        if (row.rowType == 1 && !this._tableHeaderStarted) {
            this._tableHeaderStarted = true;
            this._contentBodyContent.append("<table:table-header-rows>");
        }
        if (row.rowType != 1 && this._tableHeaderStarted) {
            this._tableHeaderStarted = false;
            this._contentBodyContent.append("</table:table-header-rows>");
        }
        this._startRowDef = row.hide_kind == 2 ? "<table:table-row table:style-name=\"%s\" table:visibility=\"collapse\">" : "<table:table-row table:style-name=\"%s\">";
        this._pageBreakStarted = false;
        if (row.rowType == 1) {
            this._frozenRowCount = this._rowIndex;
        }
    }

    private void endRow() throws Exception {
        this._rowHeight = Math.max(this._rowHeight, this._rowParams.height);
        for (int i = 0; i < this._imageDefs.size(); ++i) {
            ImageDef def = this._imageDefs.get(i);
            if (def.imageStarted) {
                def.restOfHeight += this._cellParams.margins.getTop() + this._cellParams.margins.getBottom();
            }
            if (!def.imageStarted || this._rowIndex != this._mergedRows[i] - 1) continue;
            this._rowHeight = Math.max(this._rowHeight, def.restOfHeight);
        }
        this._rowParams.height = this._rowHeight;
        RowStyleEntry rowStyleEntry = this._rowStyleTable.add(this._rowParams, this._pageBreakStarted);
        if (!rowStyleEntry._isExists) {
            this._contentAutomaticStylesContent.append(rowStyleEntry.getStyleDef());
        }
        String buffer = "";
        for (int i = 1; i <= this._cellIndex - this._prevCellIndex; ++i) {
            buffer = buffer.concat("<table:covered-table-cell/>");
        }
        if (!buffer.isEmpty()) {
            this._rowBuffer.append(buffer);
        }
        this._rowBuffer.append("</table:table-row>");
        this._contentBodyContent.append(String.format(this._startRowDef, rowStyleEntry.getStyleName()));
        this._contentBodyContent.append(this._rowBuffer.toString());
        for (int i = 0; i < this._imageDefs.size(); ++i) {
            ImageDef def = this._imageDefs.get(i);
            if (!def.imageStarted || this._rowIndex != this._mergedRows[i] - 1 || def.useMultiCell) continue;
            double imageXCoord = def.x;
            double imageYCoord = def.y;
            def.cellHeight = this._YPos + this._rowHeight - def.y + def.margins.getTop() + def.margins.getBottom();
            HorizontalAlign ha = HorizontalAlign.create(def.horzAlign);
            switch (ha) {
                case LEFT: 
                case WIDTH: 
                case DEFAULT: {
                    imageXCoord += def.margins.getLeft();
                    break;
                }
                case CENTER: {
                    imageXCoord += (def.cellWidth - def.width) / 2.0;
                    break;
                }
                case RIGHT: {
                    imageXCoord += def.cellWidth - def.width - def.margins.getRight() - def.margins.getLeft();
                }
            }
            VerticalAlign va = VerticalAlign.create(def.vertAlign);
            switch (va) {
                case DEFAULT: 
                case BASELINE: 
                case MIDDLE: {
                    imageYCoord += (def.cellHeight - def.margins.getTop() - def.margins.getBottom() - def.height) / 2.0;
                    break;
                }
                case TOP: {
                    imageYCoord += def.margins.getTop();
                    break;
                }
                case BOTTOM: {
                    imageYCoord += def.cellHeight - def.height + def.margins.getBottom();
                }
            }
            this._shapesBuffer.append(String.format(def.definition, ODSGenerator.getInchStrFromMM(imageXCoord), ODSGenerator.getInchStrFromMM(imageYCoord)));
            def.imageStarted = false;
        }
        this._YPos += this._rowHeight;
    }

    private void beginCell(DocCell cell) throws Exception {
        this.applyMerge();
        String buffer = "";
        for (int i = 1; i <= this._cellIndex - this._prevCellIndex; ++i) {
            buffer = buffer.concat("<table:covered-table-cell/>");
        }
        if (!buffer.isEmpty()) {
            this._rowBuffer.append(buffer);
        }
        ++this._cellIndex;
        this._prevCellIndex = this._cellIndex;
        this._cellParams = new CellParams(cell);
        this._cellText = "";
    }

    private void endCell() throws Exception {
        this.addMerge();
        StringBuilder strings = new StringBuilder();
        CellStyleEntry cellStyleEntry = this._cellStyleTable.add(this._cellParams);
        strings.append(String.format("<table:table-cell table:style-name=\"%s\"", cellStyleEntry.getStyleName()));
        strings.append(String.format(" table:number-rows-spanned=\"%d\"", this._cellParams.rowSpan));
        strings.append(String.format(" table:number-columns-spanned=\"%d\"", this._cellParams.colSpan));
        String str = this._cellText;
        DataType type = DataType.getDataTypeById(this._cellParams.dataType);
        block2 : switch (type) {
            case FLOAT: 
            case INTEGER: {
                String str2 = str.replace(" ", "").replaceFirst(",", ".");
                if (str2.isEmpty()) {
                    strings.append(" office:value-type=\"string\"");
                    this._cellParams.dataType = DataType.STRING.getTypeId();
                    break;
                }
                try {
                    Double.parseDouble(str2);
                    strings.append(" office:value-type=\"float\"");
                    strings.append(String.format(" office:value=\"%s\"", str2));
                    str = str2;
                }
                catch (NumberFormatException e) {
                    strings.append(" office:value-type=\"string\"");
                    this._cellParams.dataType = DataType.STRING.getTypeId();
                }
                break;
            }
            case DATE_TIME: {
                String str2 = str.trim();
                if (str2.isEmpty() || this._cellParams.cellFormatId > 412) {
                    strings.append(" office:value-type=\"string\"");
                    this._cellParams.dataType = DataType.STRING.getTypeId();
                    break;
                }
                try {
                    switch (this._cellParams.cellFormatId) {
                        case 404: 
                        case 405: 
                        case 407: {
                            SimpleDateFormat dateFormat = null;
                            dateFormat = this._cellParams.cellFormatId == 404 ? new SimpleDateFormat("HH:mm") : (this._cellParams.cellFormatId == 405 ? new SimpleDateFormat("HH:mm:ss") : new SimpleDateFormat("HH"));
                            Date date = dateFormat.parse(str2);
                            SimpleDateFormat dst = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
                            str2 = dst.format(date);
                            strings.append(" office:value-type=\"time\"");
                            strings.append(String.format(" office:time-value=\"%s\"", str2));
                            break block2;
                        }
                        case 401: 
                        case 402: 
                        case 403: 
                        case 406: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 412: {
                            SimpleDateFormat dateFormat = null;
                            dateFormat = this._cellParams.cellFormatId == 401 ? new SimpleDateFormat("dd.MM.yyyy") : (this._cellParams.cellFormatId == 402 ? new SimpleDateFormat("MM.yyyy") : (this._cellParams.cellFormatId == 403 ? new SimpleDateFormat("yyyy") : (this._cellParams.cellFormatId == 406 ? new SimpleDateFormat("dd.MM.yyyy HH:mm") : (this._cellParams.cellFormatId == 408 ? new SimpleDateFormat("dd") : (this._cellParams.cellFormatId == 409 ? new SimpleDateFormat("dd.MM") : (this._cellParams.cellFormatId == 410 ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("yyyy.MM.dd")))))));
                            Date date = dateFormat.parse(str2);
                            SimpleDateFormat dst = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                            str2 = dst.format(date);
                            strings.append(" office:value-type=\"date\"");
                            strings.append(String.format(" office:date-value=\"%s\"", str2));
                            break block2;
                        }
                    }
                    strings.append(" office:value-type=\"string\"");
                    this._cellParams.dataType = DataType.STRING.getTypeId();
                }
                catch (ParseException e) {
                    strings.append(" office:value-type=\"string\"");
                    this._cellParams.dataType = DataType.STRING.getTypeId();
                }
                break;
            }
            default: {
                strings.append(" office:value-type=\"string\"");
            }
        }
        strings.append(">");
        int idx = this._cellIndex - this._cellParams.colSpan;
        ImageDef def = this._imageDefs.get(idx);
        if (!def.imageStarted) {
            strings.append(String.format("<text:p>%s</text:p>", str));
        } else {
            int i;
            double w = 0.0;
            for (i = 0; i < idx; ++i) {
                w += this._widths[i];
            }
            this._cellParams.width = 0.0;
            for (i = idx; i < this._cellIndex; ++i) {
                this._cellParams.width += this._widths[i];
            }
            if (this._rowIndex < this._mergedRows[idx] - 1) {
                def.restOfHeight -= this._rowHeight * 25.4;
            }
            if (def.useMultiCell) {
                def.x = 0.0;
                def.y = 0.0;
                strings.append(String.format(def.definition, ODSGenerator.getInchStrFromMM(def.x), ODSGenerator.getInchStrFromMM(def.y)));
                def.imageStarted = false;
            } else {
                def.x = w;
                def.y = this._YPos;
            }
            def.cellWidth = this._cellParams.width;
            def.margins.assign(this._cellParams.margins);
            def.horzAlign = this._cellParams.align;
            def.vertAlign = this._cellParams.vertAlign;
        }
        strings.append("</table:table-cell>");
        this._rowBuffer.append(strings.toString());
        if (!cellStyleEntry._isExists) {
            this._contentAutomaticStylesContent.append(cellStyleEntry.getStyleDef());
        }
        this._cellText = "";
    }

    private static int horzAlignToHeaderFooterAlign(int align) {
        HorizontalAlign ha = HorizontalAlign.create(align);
        switch (ha) {
            case LEFT: {
                return 0;
            }
            case CENTER: {
                return 1;
            }
            case RIGHT: {
                return 2;
            }
        }
        return 1;
    }

    private void fillHeaderFooterText(DocSection section, boolean isHeader) throws Exception {
        if (section == null) {
            return;
        }
        String docTextString = "";
        StringBuilder text = isHeader ? this._headerText : this._footerText;
        for (DocComponent docComponent : section.elements()) {
            if (docComponent.getType() != Type.PARAGRAPH) continue;
            DocParagraph p = (DocParagraph)docComponent;
            if (isHeader && this._headerAlign == -1) {
                this._headerAlign = ODSGenerator.horzAlignToHeaderFooterAlign(p.align().value());
            }
            if (!isHeader && this._footerAlign == -1) {
                this._footerAlign = ODSGenerator.horzAlignToHeaderFooterAlign(p.align().value());
            }
            if (isHeader && this._headerFont == null) {
                this._headerFont = p.getFont();
            }
            if (!isHeader && this._footerFont == null) {
                this._footerFont = p.getFont();
            }
            for (DocComponent pc : p.components()) {
                if (pc.getType() != Type.TEXT) continue;
                DocText dt = (DocText)pc;
                switch (dt.getDocumentWriterFiedKind()) {
                    case 0: {
                        docTextString = dt.getText();
                        break;
                    }
                    case 1: {
                        docTextString = "<text:page-number>1</text:page-number>";
                        break;
                    }
                    case 2: {
                        docTextString = "<text:page-count>99</text:page-count>";
                    }
                }
                text.append(docTextString);
            }
        }
    }

    private String getHeaderText(boolean isHeader) throws Exception {
        boolean isEmpty;
        int align;
        String text;
        String suffix;
        StringBuilder masterStyle = new StringBuilder();
        if (isHeader) {
            suffix = "header";
            text = this._headerText.toString();
            align = this._headerAlign;
        } else {
            suffix = "footer";
            text = this._footerText.toString();
            align = this._footerAlign;
        }
        PageNumbers pageNumber = this._firstSection.getPageNumbers();
        boolean usePageNumber = pageNumber.enabled;
        int pageNumberAlign = pageNumber.align;
        if (pageNumberAlign > 2) {
            pageNumberAlign = 0;
        }
        if (usePageNumber) {
            usePageNumber = isHeader ? pageNumber.location == 0 : pageNumber.location == 1;
        }
        boolean useHeaderText = !text.isEmpty();
        boolean bl = isEmpty = !usePageNumber && !useHeaderText;
        if (isEmpty) {
            return String.format("<style:%s/><style:%s-left style:display=\"false\"/>", suffix, suffix);
        }
        masterStyle.append(String.format("<style:%s>", suffix));
        if (pageNumberAlign == 0 || align == 0) {
            masterStyle.append("<style:region-left><text:p>");
            masterStyle.append(String.format("<text:span text:style-name=\"%sTextStyle\">", suffix));
            if (usePageNumber && pageNumberAlign == 0) {
                masterStyle.append("<text:page-number>1</text:page-number>");
            }
            if (useHeaderText && align == 0) {
                masterStyle.append(text);
            }
            masterStyle.append("</text:span>");
            masterStyle.append("</text:p></style:region-left>");
        }
        if (pageNumberAlign == 1 || align == 1) {
            masterStyle.append("<style:region-center><text:p>");
            masterStyle.append(String.format("<text:span text:style-name=\"%sTextStyle\">", suffix));
            if (usePageNumber && pageNumberAlign == 1) {
                masterStyle.append("<text:page-number>1</text:page-number>");
            }
            if (useHeaderText && align == 1) {
                masterStyle.append(text);
            }
            masterStyle.append("</text:span>");
            masterStyle.append("</text:p></style:region-center>");
        }
        if (pageNumberAlign == 2 || align == 2) {
            masterStyle.append("<style:region-right><text:p>");
            masterStyle.append(String.format("<text:span text:style-name=\"%sTextStyle\">", suffix));
            if (usePageNumber && pageNumberAlign == 2) {
                masterStyle.append("<text:page-number>1</text:page-number>");
            }
            if (useHeaderText && align == 2) {
                masterStyle.append(text);
            }
            masterStyle.append("</text:span>");
            masterStyle.append("</text:p></style:region-right>");
        }
        masterStyle.append(String.format("</style:%s>", suffix));
        if (pageNumberAlign != 0 && align != 0) {
            masterStyle.append(String.format("<style:%s-left style:display=\"false\"/>", suffix));
        }
        if (pageNumberAlign != 1 && align != 1) {
            masterStyle.append(String.format("<style:%s-center style:display=\"false\"/>", suffix));
        }
        if (pageNumberAlign != 2 && align != 2) {
            masterStyle.append(String.format("<style:%s-right style:display=\"false\"/>", suffix));
        }
        return masterStyle.toString();
    }

    private static String getInchStrFromMM(double value) throws Exception {
        String res = Double.toString(value / 25.4);
        int idx = res.indexOf(46);
        if (idx >= 0) {
            int len = Math.min(idx + 4, res.length());
            res = res.substring(0, len);
        }
        return res;
    }

    private static String getCmStrFromMM(double value) throws Exception {
        String res = Double.toString(value / 10.0);
        int idx = res.indexOf(46);
        if (idx >= 0) {
            int len = Math.min(idx + 4, res.length());
            res = res.substring(0, len);
        }
        return res;
    }

    private static String getColorString(int c) throws Exception {
        if (c == 0x1FFFFFFF || c < 0) {
            return "";
        }
        return String.format("#%02X%02X%02X", c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF);
    }

    private static double strangePixelsToMM(int pixels) {
        return (double)pixels / 3.593;
    }

    private static String getCellRef(int col, int row) {
        String res = "";
        int i = col;
        do {
            int m = --i % 26;
            res = String.valueOf((char)(65 + m)).concat(res);
        } while ((i /= 26) != 0);
        res = res.concat(String.valueOf(row));
        return res;
    }

    private String getBorderAttributes(int borders) throws Exception {
        StringBuilder content = new StringBuilder();
        String buffer = ODSGenerator.getColorString(DocBorders.leftColor(this.doc, borders));
        content.append(" fo:border-left=\"");
        switch (DocBorders.leftStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        buffer = ODSGenerator.getColorString(DocBorders.rightColor(this.doc, borders));
        content.append(" fo:border-right=\"");
        switch (DocBorders.rightStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        buffer = ODSGenerator.getColorString(DocBorders.topColor(this.doc, borders));
        content.append(" fo:border-top=\"");
        switch (DocBorders.topStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        buffer = ODSGenerator.getColorString(DocBorders.bottomColor(this.doc, borders));
        content.append(" fo:border-bottom=\"");
        switch (DocBorders.bottomStyle(borders)) {
            case 1: {
                content.append("0.25pt dotted ");
                content.append(buffer);
                break;
            }
            case 2: {
                content.append("0.25pt solid ");
                content.append(buffer);
                break;
            }
            case 3: {
                content.append("1.00pt solid ");
                content.append(buffer);
                break;
            }
            case 4: {
                content.append("1.75pt solid ");
                content.append(buffer);
                break;
            }
            case 5: {
                content.append("1.75pt double ");
                content.append(buffer);
                break;
            }
            default: {
                content.append("none");
            }
        }
        content.append('\"');
        return content.toString();
    }

    private static String getDateTimeStyleName(int formatID) {
        switch (formatID) {
            case 401: 
            case 412: {
                return "dataStyleDDpMMpYYYY";
            }
            case 402: {
                return "dataStyleMMpYYYY";
            }
            case 403: {
                return "dataStyleYYYY";
            }
            case 404: {
                return "dataStyleHH\u0441MM";
            }
            case 405: {
                return "dataStyleHH\u0441MM\u0441SS";
            }
            case 406: {
                return "dataStyleDDpMMpYYYYspHH\u0441MM";
            }
            case 407: {
                return "dataStyleHH";
            }
            case 408: {
                return "dataStyleDD";
            }
            case 409: {
                return "dataStyleDDpMM";
            }
            case 410: {
                return "dataStyleDDpMMpYYYYspHH\u0441MM\u0441SS";
            }
            case 411: {
                return "dataStyleQpYYYY";
            }
            case 451: {
                return "dataStyleDDspMMMMspYYYY";
            }
            case 452: {
                return "dataStyleMMMMspYYYY";
            }
            case 453: {
                return "dataStyleDDspMMMM";
            }
            case 454: {
                return "dataStyleMMMM";
            }
            case 458: {
                return "dataStyleQ";
            }
        }
        return "dataStyleDDpMMpYYYY";
    }

    private String getTableProtectString() throws NoSuchAlgorithmException {
        String res = "";
        SheetProtection firstProt = this._currSection.getFirstPageProtection();
        SheetProtection globProt = this._currSection.getAllPageProtection();
        String password = globProt.getPassword();
        int options = globProt.getOptions();
        if (!firstProt.getPassword().isEmpty()) {
            password = firstProt.getPassword();
            options = firstProt.getOptions();
        }
        if (password.isEmpty()) {
            return res;
        }
        String selUnlockedCells = "false";
        String selLockedCells = "false";
        if ((options & 0x4000) != 0) {
            selUnlockedCells = "true";
        }
        if ((options & 0x400) != 0) {
            selLockedCells = "true";
        }
        StringBuilder protStr = new StringBuilder();
        protStr.append(String.format(" table:protection-key=\"%s\"", ODSGenerator.getODSHash(password)));
        protStr.append(" table:protected=\"true\">");
        protStr.append(String.format("<loext:table-protection loext:select-unprotected-cells=\"%s\" loext:select-protected-cells=\"%s\"/>", selUnlockedCells, selLockedCells));
        res = protStr.toString();
        return res;
    }

    private String changeSpecSymb(String text) throws Exception {
        int i;
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int count = text.length();
        boolean isSpace = text.charAt(0) == ' ';
        int spaceCount = 0;
        if (isSpace) {
            for (i = 0; i < count && text.charAt(i) == ' '; ++i) {
                ++spaceCount;
            }
            result.append(String.format("<text:s text:c=\"%d\"/>", spaceCount));
        }
        for (i = 0; i < count; ++i) {
            char str = text.charAt(i);
            if (str == '<') {
                result.append("&lt;");
                continue;
            }
            if (str == '>') {
                result.append("&gt;");
                continue;
            }
            if (str == '&') {
                result.append("&amp;");
                continue;
            }
            if (str == '\n') {
                result.append("<text:line-break/>");
                continue;
            }
            result.append(str);
        }
        return result.toString();
    }

    private static int getCellStyleHash(CellParams cellParams) {
        TableMargins margins = cellParams.margins;
        int hash = Hashing.hash(margins.getLeft());
        hash = hash << 3 ^ Hashing.hash(margins.getRight());
        hash = hash << 3 ^ Hashing.hash(margins.getTop());
        hash = hash << 3 ^ Hashing.hash(margins.getBottom());
        hash = hash << 3 ^ cellParams.borders;
        hash = hash << 3 ^ cellParams.color;
        hash = hash << 3 ^ (cellParams.wordWrap ? 1 : 0);
        hash = hash << 3 ^ cellParams.vertAlign;
        hash = hash << 3 ^ cellParams.align;
        hash = hash << 3 ^ cellParams.textOrientation;
        hash = hash << 3 ^ cellParams.dataType;
        hash = hash << 3 ^ cellParams.cellFormatScale;
        hash = hash << 3 ^ (cellParams.isCellFormatSeparateThausand ? 1 : 0);
        hash = hash << 3 ^ cellParams.cellFormatId;
        hash = hash << 3 ^ Font.styleHashCodeByFontIndex(cellParams.font);
        return hash;
    }

    private static int getRowStyleHash(RowParams params, boolean pageBreakStarted) {
        int hash = params.color;
        hash = hash << 3 ^ Hashing.hash(params.height);
        hash = hash << 3 ^ (pageBreakStarted ? 1 : 0);
        return hash;
    }

    private static class RowStyleTable
    extends AbstractHash<RowStyleEntry> {
        private RowStyleTable() {
        }

        public RowStyleEntry get(RowParams params, boolean pageBreakStarted) {
            int m = ((RowStyleEntry[])this.data).length - 1;
            int i = (ODSGenerator.getRowStyleHash(params, pageBreakStarted) & this.mask) << 1;
            RowStyleEntry e = null;
            while ((e = ((RowStyleEntry[])this.data)[i]) != null) {
                if (e.isEquals(params, pageBreakStarted)) {
                    e._isExists = true;
                    break;
                }
                i = i + 1 & m;
            }
            return e;
        }

        public RowStyleEntry add(RowParams params, boolean pageBreakStarted) {
            RowStyleEntry s = this.get(params, pageBreakStarted);
            if (s != null) {
                return s;
            }
            s = new RowStyleEntry(params, pageBreakStarted);
            s._index = this.size();
            super.add(s);
            return s;
        }

        @Override
        protected int hash(RowStyleEntry s) {
            assert (s != null);
            return s._hashCode;
        }

        @Override
        protected boolean equals(RowStyleEntry a, RowStyleEntry b) {
            assert (a != null && b != null);
            return a.isEquals(b);
        }

        protected RowStyleEntry[] allocate(int count) {
            return new RowStyleEntry[count];
        }
    }

    private static class RowStyleEntry {
        private final int _color;
        private final double _height;
        private final int _hashCode;
        private int _index;
        private final boolean _pageBreakStarted;
        private boolean _isExists;

        public RowStyleEntry(RowParams params, boolean pageBreakStarted) {
            this._color = params.color;
            this._height = params.height;
            this._index = 0;
            this._isExists = false;
            this._pageBreakStarted = pageBreakStarted;
            this._hashCode = ODSGenerator.getRowStyleHash(params, pageBreakStarted);
        }

        public String getStyleDef() throws Exception {
            String buffer;
            StringBuilder content = new StringBuilder();
            content.append(String.format("<style:style style:name=\"ro%d\"", this._index));
            content.append(" style:family=\"table-row\">");
            content.append("<style:table-row-properties");
            if (this._pageBreakStarted) {
                content.append(" fo:break-before=\"page\"");
            }
            if (!(buffer = ODSGenerator.getColorString(this._color)).isEmpty()) {
                content.append(String.format(" fo:background-color=\"%s\"", buffer));
            }
            buffer = ODSGenerator.getInchStrFromMM(this._height);
            content.append(String.format(" style:row-height=\"%sin\"", buffer));
            content.append(" style:use-optimal-row-height=\"true\"");
            content.append("/></style:style>");
            return content.toString();
        }

        public String getStyleName() {
            return String.format("ro%d", this._index);
        }

        public boolean isEquals(RowStyleEntry rowStyleEntry) {
            return this._color == rowStyleEntry._color && this._pageBreakStarted == rowStyleEntry._pageBreakStarted && this._height == rowStyleEntry._height;
        }

        public boolean isEquals(RowParams params, boolean pageBreakStarted) {
            return this._color == params.color && this._pageBreakStarted == pageBreakStarted && this._height == params.height;
        }
    }

    private class CellStyleTable
    extends AbstractHash<CellStyleEntry> {
        private CellStyleTable() {
        }

        public CellStyleEntry get(CellParams cellParams) {
            int m = ((CellStyleEntry[])this.data).length - 1;
            int i = (ODSGenerator.getCellStyleHash(cellParams) & this.mask) << 1;
            CellStyleEntry e = null;
            while ((e = ((CellStyleEntry[])this.data)[i]) != null) {
                if (e.isEquals(cellParams)) {
                    e._isExists = true;
                    break;
                }
                i = i + 1 & m;
            }
            return e;
        }

        @Override
        public CellStyleEntry add(CellParams cellParams) {
            CellStyleEntry s = this.get(cellParams);
            if (s != null) {
                return s;
            }
            s = new CellStyleEntry(cellParams);
            s._index = this.size();
            super.add(s);
            return s;
        }

        @Override
        protected int hash(CellStyleEntry s) {
            assert (s != null);
            return s._hashCode;
        }

        @Override
        protected boolean equals(CellStyleEntry a, CellStyleEntry b) {
            assert (a != null && b != null);
            return a.isEquals(b);
        }

        protected CellStyleEntry[] allocate(int count) {
            return new CellStyleEntry[count];
        }
    }

    private class CellStyleEntry {
        private final int _color;
        private final int _borders;
        private final boolean _wordWrap;
        private final double _leftMargin;
        private final double _rightMargin;
        private final double _topMargin;
        private final double _bottomMargin;
        private final int _vertAlign;
        private final int _align;
        private final int _orientation;
        private final int _hashCode;
        private int _index;
        private boolean _isExists;
        private final int _dataType;
        private final boolean _isFormatSeparateThausand;
        private final int _formatScale;
        private final int _formatId;
        private final Font _font;

        public CellStyleEntry(CellParams cellParams) {
            TableMargins margins = cellParams.margins;
            this._leftMargin = margins.getLeft();
            this._rightMargin = margins.getRight();
            this._topMargin = margins.getTop();
            this._bottomMargin = margins.getBottom();
            this._color = cellParams.color;
            this._borders = cellParams.borders;
            this._wordWrap = cellParams.wordWrap;
            this._vertAlign = cellParams.vertAlign;
            this._align = cellParams.align;
            this._orientation = cellParams.textOrientation;
            this._index = 0;
            this._isExists = false;
            this._hashCode = ODSGenerator.getCellStyleHash(cellParams);
            this._dataType = cellParams.dataType;
            this._isFormatSeparateThausand = cellParams.isCellFormatSeparateThausand;
            this._formatScale = cellParams.cellFormatScale;
            this._formatId = cellParams.cellFormatId;
            this._font = new Font();
            this._font.assign(cellParams.font);
        }

        public boolean isEquals(CellStyleEntry cellStyleEntry) {
            return this._borders == cellStyleEntry._borders && this._leftMargin == cellStyleEntry._leftMargin && this._rightMargin == cellStyleEntry._rightMargin && this._topMargin == cellStyleEntry._topMargin && this._bottomMargin == cellStyleEntry._bottomMargin && this._color == cellStyleEntry._color && this._wordWrap == cellStyleEntry._wordWrap && this._vertAlign == cellStyleEntry._vertAlign && this._align == cellStyleEntry._align && this._orientation == cellStyleEntry._orientation && this._dataType == cellStyleEntry._dataType && this._isFormatSeparateThausand == cellStyleEntry._isFormatSeparateThausand && this._formatScale == cellStyleEntry._formatScale && this._formatId == cellStyleEntry._formatId && Font.styleEqualsByFontIndex(this._font, cellStyleEntry._font);
        }

        public boolean isEquals(CellParams cellParams) {
            TableMargins margins = cellParams.margins;
            return this._borders == cellParams.borders && this._leftMargin == margins.getLeft() && this._rightMargin == margins.getRight() && this._topMargin == margins.getTop() && this._bottomMargin == margins.getBottom() && this._color == cellParams.color && this._wordWrap == cellParams.wordWrap && this._vertAlign == cellParams.vertAlign && this._align == cellParams.align && this._orientation == cellParams.textOrientation && this._dataType == cellParams.dataType && this._isFormatSeparateThausand == cellParams.isCellFormatSeparateThausand && this._formatScale == cellParams.cellFormatScale && this._formatId == cellParams.cellFormatId && Font.styleEqualsByFontIndex(this._font, cellParams.font);
        }

        public String getStyleDef() throws Exception {
            StringBuilder content = new StringBuilder();
            if (DataType.getDataTypeById(this._dataType) == DataType.INTEGER || DataType.getDataTypeById(this._dataType) == DataType.FLOAT) {
                content.append("<number:number-style");
                content.append(String.format(" style:name=\"dataStyleNumber%d\">", this._index));
                content.append("<number:number");
                content.append(" number:min-integer-digits=\"1\"");
                if (this._isFormatSeparateThausand) {
                    content.append(" number:grouping=\"true\"");
                }
                if (DataType.getDataTypeById(this._dataType) == DataType.FLOAT && this._formatScale > -1 && this._formatScale != 11) {
                    content.append(String.format(" number:decimal-places=\"%d\"", this._formatScale));
                }
                content.append("/>");
                content.append("</number:number-style>");
            }
            content.append(String.format("<style:style style:name=\"ce%d\"", this._index));
            if (DataType.getDataTypeById(this._dataType) == DataType.INTEGER || DataType.getDataTypeById(this._dataType) == DataType.FLOAT) {
                content.append(String.format(" style:data-style-name=\"dataStyleNumber%d\"", this._index));
            }
            if (DataType.getDataTypeById(this._dataType) == DataType.DATE_TIME) {
                content.append(String.format(" style:data-style-name=\"%s\"", ODSGenerator.getDateTimeStyleName(this._formatId)));
            }
            content.append(" style:family=\"table-cell\" style:parent-style-name=\"Default\">");
            content.append("<style:table-cell-properties");
            String buffer = ODSGenerator.getColorString(this._color);
            if (!buffer.isEmpty()) {
                content.append(String.format(" fo:background-color=\"%s\"", buffer));
            }
            content.append(ODSGenerator.this.getBorderAttributes(this._borders));
            buffer = this._wordWrap ? "wrap" : "no-wrap";
            content.append(String.format(" fo:wrap-option=\"%s\"", buffer));
            if (this._orientation == TextOrientation.BOTTOM_TOP.value()) {
                content.append(" style:rotation-angle=\"90\"");
            }
            if (this._orientation == TextOrientation.TOP_BOTTOM.value()) {
                content.append(" style:rotation-angle=\"270\"");
            }
            switch (VerticalAlign.create(this._vertAlign)) {
                case TOP: {
                    buffer = "top";
                    break;
                }
                case BOTTOM: {
                    buffer = "bottom";
                    break;
                }
                case MIDDLE: {
                    buffer = "middle";
                    break;
                }
                default: {
                    buffer = "automatic";
                }
            }
            content.append(String.format(" style:vertical-align=\"%s\"", buffer));
            content.append("/>");
            switch (HorizontalAlign.create(this._align)) {
                case CENTER: {
                    buffer = "center";
                    break;
                }
                case RIGHT: {
                    buffer = "end";
                    break;
                }
                case WIDTH: {
                    buffer = "justify";
                    break;
                }
                default: {
                    buffer = "start";
                }
            }
            content.append(String.format("<style:paragraph-properties fo:text-align=\"%s\"", buffer));
            buffer = ODSGenerator.getInchStrFromMM(this._bottomMargin);
            content.append(String.format(" fo:margin-bottom=\"%sin\"", buffer));
            buffer = ODSGenerator.getInchStrFromMM(this._leftMargin);
            content.append(String.format(" fo:margin-left=\"%sin\"", buffer));
            buffer = ODSGenerator.getInchStrFromMM(this._rightMargin);
            content.append(String.format(" fo:margin-right=\"%sin\"", buffer));
            buffer = ODSGenerator.getInchStrFromMM(this._topMargin);
            content.append(String.format(" fo:margin-top=\"%sin\"", buffer));
            content.append("/>");
            content.append("<style:text-properties");
            buffer = ODSGenerator.getColorString(this._font.getColor());
            if (!buffer.isEmpty()) {
                content.append(String.format(" fo:color=\"%s\"", buffer));
            }
            content.append(String.format(" fo:font-family=\"%s\"", this._font.getName()));
            content.append(String.format(" fo:font-size=\"%dpt\"", this._font.getSize()));
            buffer = "normal";
            if ((this._font.getStyle() & 2) != 0) {
                buffer = "italic";
            }
            content.append(String.format(" fo:font-style=\"%s\"", buffer));
            buffer = "normal";
            if ((this._font.getStyle() & 1) != 0) {
                buffer = "bold";
            }
            content.append(String.format(" fo:font-weight=\"%s\"", buffer));
            content.append(String.format(" style:font-name=\"%s\"", this._font.getName()));
            if ((this._font.getStyle() & 8) != 0) {
                content.append(" style:text-line-through-type=\"single\" style:text-line-through-style=\"solid\"");
            }
            buffer = "none";
            if ((this._font.getStyle() & 4) != 0) {
                buffer = "solid";
            }
            content.append(String.format(" style:text-underline-style=\"%s\"", buffer));
            if (buffer.equals("solid")) {
                content.append(" style:text-underline-color=\"font-color\"");
                content.append(" style:text-underline-mode=\"continuous\"");
            }
            content.append("/></style:style>");
            return content.toString();
        }

        public String getStyleName() {
            return String.format("ce%d", this._index);
        }
    }

    private static class RowParams {
        Font font;
        double height;
        int color;
        int level;

        public RowParams(DocRow row) {
            this.clear();
            if (row.getFont() != null) {
                this.font.assign(row.getFont());
            }
            this.height = row.getHeight();
            this.color = row.getColor();
            this.level = row.level;
        }

        public RowParams() {
            this.clear();
        }

        public void clear() {
            this.font = new Font();
            this.height = 0.0;
            this.color = 0x1FFFFFFF;
            this.level = 0;
        }
    }

    private class CellParams {
        TableMargins margins = new TableMargins();
        int borders;
        int color;
        boolean wordWrap;
        int vertAlign;
        int align;
        int textOrientation;
        int dataType;
        int cellFormatScale;
        boolean isCellFormatSeparateThausand;
        int cellFormatId;
        Font font;
        int colSpan;
        int rowSpan;
        double width;

        public CellParams(DocCell cell) {
            this.margins.assign(cell.getCellMargins());
            this.borders = cell.borders();
            this.color = cell.getColor();
            this.wordWrap = cell.isCellWordWrap();
            this.vertAlign = cell.getVertAlign();
            this.align = cell.getAlign();
            this.textOrientation = cell.getTextOrientation();
            this.dataType = cell.getDataType().getTypeId();
            this.isCellFormatSeparateThausand = cell.isCellFormatSeparateThausand();
            this.cellFormatScale = cell.getCellFormatScale();
            this.cellFormatId = cell.getCellFormatId();
            this.font = new Font();
            if (cell.getFont() != null) {
                this.font.assign(cell.getFont());
            }
            this.colSpan = cell.colSpan();
            this.rowSpan = cell.rowSpan();
            this.width = cell.getWidth();
        }

        public CellParams() {
            this.clear();
        }

        public void clear() {
            this.margins.setLeft(1.9);
            this.margins.setRight(1.9);
            this.margins.setTop(0.0);
            this.margins.setBottom(0.0);
            this.borders = 0;
            this.color = 0x1FFFFFFF;
            this.wordWrap = false;
            this.vertAlign = 0;
            this.align = 0;
            this.textOrientation = 0;
            this.dataType = 0;
            this.cellFormatScale = 0;
            this.isCellFormatSeparateThausand = false;
            this.cellFormatId = 0;
            this.font = new Font();
            this.colSpan = 1;
            this.rowSpan = 1;
            this.width = 0.0;
        }
    }

    private static class ImageDef {
        double width;
        double height;
        String definition;
        int horzAlign;
        int vertAlign;
        double cellHeight;
        double cellWidth;
        TableMargins margins = new TableMargins();
        boolean imageStarted;
        double x;
        double y;
        double restOfHeight;
        boolean useMultiCell;

        public ImageDef() {
            this.clear();
        }

        public void clear() {
            this.margins.setLeft(1.9);
            this.margins.setRight(1.9);
            this.margins.setTop(0.0);
            this.margins.setBottom(0.0);
            this.width = 0.0;
            this.height = 0.0;
            this.definition = "";
            this.horzAlign = 0;
            this.vertAlign = 0;
            this.cellHeight = 0.0;
            this.cellWidth = 0.0;
            this.imageStarted = false;
            this.x = 0.0;
            this.y = 0.0;
            this.restOfHeight = 0.0;
            this.useMultiCell = false;
        }
    }
}

