/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.style;

import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.style.CellStyle;
import inform.agent.web.reports.style.DocTextStyle;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.TableMargins;

public class DocCellStyle
extends DocTextStyle {
    private final TableMargins margins;

    public DocCellStyle(Document document, int id, Font font, int color, TableMargins margins) {
        super(document, id, font, color);
        this.margins = document.getDocMargins(margins);
    }

    public DocCellStyle(Document document, int id, CellStyle style) {
        this(document, id, style.getFont(), style.getColor(), style.getMargins());
    }

    public TableMargins getMargins() {
        return this.margins;
    }

    public static int styleHashCode(DocCellStyle s) {
        int code = s.margins.hashCode();
        code = code << 3 ^ Font.styleHashCodeByFontIndex(s.font);
        code = code << 3 ^ s.color;
        return code;
    }

    public static int styleHashCode(Font font, int color, TableMargins margins) {
        int code = margins.hashCode();
        code = code << 3 ^ Font.styleHashCodeByFontIndex(font);
        code = code << 3 ^ color;
        return code;
    }

    public static boolean styleEquals(DocCellStyle a, DocCellStyle b) {
        return a.color == b.color && Font.styleEqualsByFontIndex(a.font, b.font) && a.margins.equals(b.margins);
    }

    public static boolean styleEquals(DocCellStyle a, Font font, int color, TableMargins margins) {
        return a.color == color && Font.styleEqualsByFontIndex(a.font, font) && a.margins.equals(margins);
    }
}

