/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.adt.IO;
import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.DataFormat;
import inform.agent.Ini;
import inform.agent.db.BlobDataReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.BlobValueId;
import inform.agent.db.types.DataType;
import inform.agent.scripts.libs.ExtFilesLibrary;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class BlobData
extends AsmoServlet.WithSession {
    private final File BFS_ROOT;

    public BlobData() {
        super(AsmoServlet.Type.RAW);
        String tempDirProp = Core.getTempDir();
        if (tempDirProp == null) {
            throw new InformException("Can not determine temp directory path");
        }
        this.BFS_ROOT = new File(tempDirProp + "/ASMO_UPLOAD/" + Ini.blobfsId());
    }

    private void setFileHeaders(HttpServletRequest request, HttpServletResponse response, String fname) {
        String mime = request.getServletContext().getMimeType(fname);
        response.setHeader("Content-Type", mime != null ? mime : "application/octet-stream");
        response.setHeader("Content-Disposition", "attachment");
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        String method = request.getMethod();
        if ("GET".equals(method)) {
            this.doGet(request, response, session);
        } else if ("POST".equals(method)) {
            this.doPost(request, response);
        } else {
            response.sendError(405);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response, Session session) throws ServletException, IOException {
        block42: {
            BlobDataReader blobData;
            String preview = request.getParameter("preview");
            response.setHeader("Cache-Control", "no-cache");
            String[] path = request.getPathInfo().split("/");
            if (path.length < 3) {
                String fname = (String)((Object[])JSON.parse(path[1]))[0];
                if (!fname.endsWith(".blob") || !fname.startsWith(this.BFS_ROOT.getAbsolutePath())) {
                    throw new InformException("Bad temp-id: " + fname);
                }
                try (FileInputStream in = new FileInputStream(fname);){
                    if (preview != null) {
                        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                        IO.transfer(in, tmp);
                        this.preview(tmp.internalBuffer(), tmp.size(), response, preview);
                        return;
                    }
                    if (path.length > 2) {
                        this.setFileHeaders(request, response, path[2]);
                    }
                    IO.transfer(in, (OutputStream)response.getOutputStream());
                }
                return;
            }
            String requestTable = path[1];
            String requestField = path[2];
            String requestRecord = path[3];
            if (path.length > 4) {
                this.setFileHeaders(request, response, path[4]);
            }
            double nodeId = 0.0;
            double tableId = Double.parseDouble(requestTable);
            int fieldId = Integer.parseInt(requestField);
            double rowId = Double.parseDouble(requestRecord);
            BlobValueId blobId = new BlobValueId(tableId, fieldId, rowId);
            Session.User user = session.user();
            WebServerSideHost host = new WebServerSideHost(nodeId, user, (AbstractConnection)((Request)request).getConnection());
            try {
                blobData = new BlobDataReader(-1, host);
            }
            catch (InterruptedException e) {
                throw InformException.wrap(e);
            }
            RuntimeException exception = null;
            try {
                ServletOutputStream out = response.getOutputStream();
                TableDescriptor tableDescriptor = TableDescriptor.get(tableId);
                InputStream in = blobData.readData(null, tableDescriptor.getDbId(), blobId);
                if (in == null) break block42;
                try {
                    byte[] content;
                    ExtFilesLibrary.Entry e;
                    byte[] buffer = new byte[1024];
                    int l = this.readFullyIfPossible(in, buffer, buffer.length);
                    FieldDescriptor field = tableDescriptor.getExistingFieldDescriptor(blobId.getFieldId());
                    if (field.getType() == DataType.FILE || !TaggedReader.containsTag(2, buffer) && !TaggedReader.containsTag(3, buffer)) {
                        if (preview != null) {
                            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                            tmp.write(buffer, 0, l);
                            IO.transfer(in, tmp);
                            this.preview(tmp.internalBuffer(), tmp.size(), response, preview);
                        } else {
                            out.write(buffer, 0, l);
                            IO.transfer(in, (OutputStream)out);
                        }
                        return;
                    }
                    in = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, l), in);
                    TaggedReader reader = new TaggedReader(in);
                    ExtFilesLibrary.Container c = null;
                    if (reader.next()) {
                        switch (reader.getCurrentTag()) {
                            case 150: {
                                c = new ExtFilesLibrary.Container(reader);
                                break;
                            }
                            case 2: {
                                c = new ExtFilesLibrary.Container(reader.getStreamReader());
                                break;
                            }
                            case 3: {
                                c = new ExtFilesLibrary.Container(new TaggedReader(new InflaterInputStream(reader.getStream(), new Inflater(true))));
                            }
                        }
                    }
                    if (c != null && (e = c.getExecutable()) != null && (content = e.internalGetContent()) != null) {
                        if (preview != null) {
                            this.preview(content, content.length, response, preview);
                        } else {
                            out.write(content);
                        }
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (SQLException e) {
                exception = InformException.wrap(e);
            }
            finally {
                block43: {
                    try {
                        blobData.release();
                    }
                    catch (SQLException e) {
                        if (exception == null) break block43;
                        InformException.detail(exception, e.toString());
                    }
                }
                if (exception == null) break block42;
                throw exception;
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter writer = response.getWriter();
        writer.append('[');
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            Iterator iterator = request.getParts().iterator();
            if (iterator.hasNext()) {
                Part p = (Part)iterator.next();
                writer.append(JSON.toString(this.post(p.getInputStream())));
            }
        } else {
            writer.append(JSON.toString(this.post((InputStream)request.getInputStream())));
        }
        writer.append(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(InputStream in) throws IOException {
        String string;
        this.BFS_ROOT.mkdirs();
        File filePath = File.createTempFile("blob", ".blob", this.BFS_ROOT);
        RandomAccessFile file = new RandomAccessFile(filePath, "rw");
        try {
            int count;
            byte[] chunk = new byte[0x100000];
            do {
                if ((count = in.read(chunk)) <= 0) continue;
                file.write(chunk, 0, count);
            } while (count > -1);
            string = filePath.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                file.close();
                throw throwable;
            }
            catch (Throwable e) {
                filePath.delete();
                throw InformException.wrap(e);
            }
        }
        file.close();
        return string;
    }

    private int readFullyIfPossible(InputStream in, byte[] buffer, int length) throws IOException {
        int off;
        int l;
        for (off = 0; off < length && (l = in.read(buffer, off, length - off)) >= 0; off += l) {
        }
        return off;
    }

    private void preview(byte[] buffer, int length, HttpServletResponse resp, String arg) throws IOException {
        DataFormat fmt = DataFormat.determine(buffer, 0, length);
        if (fmt instanceof DataFormat.WebPreview) {
            String[] sp = arg.split(":");
            ((DataFormat.WebPreview)((Object)fmt)).preview(buffer, 0, length, (OutputStream)resp.getOutputStream(), Integer.parseInt(sp[0]), Integer.parseInt(sp[1]));
        } else {
            resp.sendRedirect(this.root() + "/images/icons/24/1075");
        }
    }
}

