/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import java.io.IOException;

public class CellIndent {
    private int datasourceId = 0;
    private int[] fieldIdPath = null;
    private Dataset datasource = null;
    private DatasetField field = null;
    private double shift = 0.0;
    private static final int TAG_WEB_CELL_INDENT_DATASOURCE_ID = 1;
    private static final int TAG_WEB_CELL_INDENT_FIELD_ID = 2;
    private static final int TAG_WEB_CELL_INDENT_SHIFT = 3;

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.datasourceId = in.getInt();
                    break;
                }
                case 2: {
                    this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                    break;
                }
                case 3: {
                    this.shift = in.getDouble();
                }
            }
        }
    }

    public void afterLoad(Task task) throws InformException {
        this.datasource = null;
        this.field = null;
        if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = task.getComponents().findDatasource(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
    }

    public double value() throws Exception {
        if (this.field != null && this.datasource.isCurrentRowAvailable()) {
            return this.field.getAsNumber() * this.shift;
        }
        return 0.0;
    }

    public String getClassName() {
        return "CellIndent";
    }

    public void setupDatamodel(Datamodel datamodel) {
        if (this.field != null) {
            datamodel.add(this.datasource);
        }
    }
}

