/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedWriter;

public class ClientFont {
    private static final String[] STABLE_FONT_NAMES = new String[]{"MS Sans Serif", "Times New Roman", "Arial", "Courier New", "System", "Tahoma", "Symbol", "Verdana", "Lucida Sans Unicode", "Georgia", "Lucida Console", "Consolas", "Arial Black", "Comic Sans MS", "Impact", "Palatino Linotype", "Calibri", "Cambria", "Corbel", "Constantia", "Segoe UI"};
    private static final int LF_FACESIZE = 32;
    private static final int FACE_NAME_OFFSET = 7;
    private String name = "Times New Roman";
    private int size = 10;
    private int color = 0;
    private int style = 0;

    public void load(byte[] bytes) {
        this.color = LittleEndian.getInt(bytes, 0);
        this.style = bytes[4] & 0xFF;
        this.size = bytes[5] & 0xFF;
        if (bytes.length == 8) {
            int idx = bytes[7] & 0xFF;
            if (idx < STABLE_FONT_NAMES.length) {
                this.name = STABLE_FONT_NAMES[idx];
            }
        } else {
            int len = this.fontNameLength(bytes);
            this.name = new String(bytes, 7, len, TaggedWriter.ANSI);
        }
    }

    private int fontNameLength(byte[] bytes) {
        int i;
        for (i = 7; i < bytes.length && bytes[i] != 0; ++i) {
        }
        return i - 7;
    }

    public static void store(TaggedWriter out, int tag, String name, int size, int style, int color) throws Exception {
        byte[] colorByte;
        int index = -1;
        for (int i = 0; i < STABLE_FONT_NAMES.length; ++i) {
            String s = STABLE_FONT_NAMES[i];
            if (s.compareTo(name) != 0) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            byte[] tagFont = new byte[8];
            colorByte = LittleEndian.intToBinary(color);
            tagFont[0] = colorByte[0];
            tagFont[1] = colorByte[1];
            tagFont[2] = colorByte[2];
            tagFont[3] = colorByte[3];
            tagFont[4] = (byte)(style & 0xFF);
            tagFont[5] = (byte)(size & 0xFF);
            tagFont[6] = 0;
            tagFont[7] = (byte)(index & 0xFF);
            out.putRaw(tag, tagFont, 8);
        } else {
            byte[] tagFont = new byte[39];
            colorByte = LittleEndian.intToBinary(color);
            tagFont[0] = colorByte[0];
            tagFont[1] = colorByte[1];
            tagFont[2] = colorByte[2];
            tagFont[3] = colorByte[3];
            tagFont[4] = (byte)(style & 0xFF);
            tagFont[5] = (byte)(size & 0xFF);
            tagFont[6] = 0;
            byte[] nameBytes = name.getBytes(TaggedWriter.ANSI);
            for (int i = 0; i < 32; ++i) {
                tagFont[7 + i] = i < nameBytes.length ? nameBytes[i] : (byte)0;
            }
            out.putRaw(tag, tagFont, 39);
        }
    }

    public int getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }
}

