/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class Font {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKEOUT = 8;
    public static final int SUPERSCRIPT = 16;
    public static final String DEFAULT_FONT_NAME = "Times New Roman";
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final int DEFAULT_FONT_STYLE = 0;
    private int fontIndex = -1;
    private Font parent = null;
    private String name = "Times New Roman";
    private int size = 10;
    private int color = 0x1FFFFFFF;
    private int option = 0;
    private static final int USAGE_NAME = 0x1000000;
    private static final int USAGE_SIZE = 0x2000000;
    private static final int USAGE_STYLE = 0x4000000;
    private static final int USAGE_PERSISTENT = 0x8000000;
    private static final int STYLE_MASK = 31;
    private static final int TAG_WEB_FONT_NAME = 1;
    private static final int TAG_WEB_FONT_STYLE = 2;
    private static final int TAG_WEB_FONT_COLOR = 3;
    private static final int TAG_WEB_FONT_SIZE = 4;

    public String getClassName() {
        return "Font";
    }

    public Font() {
    }

    public Font(Scriptable scope) {
    }

    public int getFontId() {
        return 0;
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.setName(in.getAnsi());
                    break;
                }
                case 2: {
                    this.setStyle(in.getInt());
                    break;
                }
                case 3: {
                    this.setColor(in.getInt());
                    break;
                }
                case 4: {
                    this.setSize(in.getInt());
                }
            }
        }
    }

    public void store(TaggedWriter out) throws IOException {
        out.putAnsi(1, this.getName());
        out.putInt32(2, this.getStyle());
        out.putInt32(3, this.getColor());
        out.putInt32(4, this.getSize());
    }

    public void storeAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        this.store(writer);
        writer.flush();
        out.putRaw(tag, stream);
    }

    public void setParent(Font parent) {
        this.parent = parent;
        if (parent != null && (this.option & 0x1000000) == 0) {
            this.name = null;
        }
    }

    public int getColor() {
        if (this.color == 0x1FFFFFFF) {
            if (this.parent == null) {
                if ((this.option & 0x8000000) != 0) {
                    return this.color;
                }
                return 0;
            }
            return this.parent.getColor();
        }
        return this.color;
    }

    public void setColor(int color) {
        if ((this.option & 0x8000000) != 0) {
            return;
        }
        this.color = color != 0x1FFFFFFF && this.parent != null && this.parent.getColor() == color ? 0x1FFFFFFF : color;
    }

    public String getName() {
        if ((this.option & 0x1000000) == 0) {
            if (this.parent == null) {
                if ((this.option & 0x8000000) != 0) {
                    return this.name;
                }
                return DEFAULT_FONT_NAME;
            }
            return this.parent.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        if ((this.option & 0x8000000) != 0) {
            return;
        }
        this.name = name;
        this.option = this.parent != null && this.parent.getName().equalsIgnoreCase(name) ? (this.option &= 0xFEFFFFFF) : (this.option |= 0x1000000);
    }

    public int getSize() {
        if ((this.option & 0x2000000) == 0) {
            if (this.parent == null) {
                if ((this.option & 0x8000000) != 0) {
                    return this.size;
                }
                return 10;
            }
            return this.parent.getSize();
        }
        return this.size;
    }

    public void setSize(int size) {
        if ((this.option & 0x8000000) != 0) {
            return;
        }
        this.size = size;
        this.option = this.parent != null && this.parent.getSize() == size ? (this.option &= 0xFDFFFFFF) : (this.option |= 0x2000000);
    }

    public int getStyle() {
        if ((this.option & 0x4000000) == 0) {
            if (this.parent == null) {
                if ((this.option & 0x8000000) != 0) {
                    return this.option & 0x1F;
                }
                return 0;
            }
            return this.parent.getStyle();
        }
        return this.option & 0x1F;
    }

    public void setStyle(int style) {
        if ((this.option & 0x8000000) != 0) {
            return;
        }
        this.option &= 0xFFFFFFE0;
        this.option |= (style &= 0x1F);
        this.option |= 0x4000000;
        this.option = this.parent != null && this.parent.getStyle() == style ? (this.option &= 0xFBFFFFFF) : (this.option |= 0x4000000);
    }

    public void assign(Font font) {
        if ((this.option & 0x8000000) != 0 || font == null) {
            return;
        }
        this.parent = font.parent;
        this.name = font.name;
        this.size = font.size;
        this.color = font.color;
        this.option = font.option;
    }

    public void assignValues(Font font) {
        if ((this.option & 0x8000000) != 0 || font == null) {
            return;
        }
        if (this.parent == null || (this.option & 0x1000000) != 0) {
            this.name = font.getName();
        }
        this.size = font.size;
        this.color = font.color;
        this.option = font.option;
    }

    public void actualize(Font font) {
        if ((this.option & 0x8000000) != 0 || font == null) {
            return;
        }
        this.parent = null;
        this.name = font.getName();
        this.size = font.getSize();
        this.color = font.getColor();
        if (this.color == 0x1FFFFFFF) {
            this.color = 0;
        }
        this.option = font.getStyle() | 0x1000000 | 0x2000000 | 0x4000000 | 0x8000000;
    }

    public static int styleHashCode(Font font) {
        if (font == null) {
            return 0;
        }
        int code = font.getName().hashCode();
        code = code << 3 ^ font.getStyle();
        code = code << 3 ^ font.getSize();
        code = code << 3 ^ font.getColor();
        return code;
    }

    public static int styleHashCodeByFontIndex(Font font) {
        if (font == null) {
            return 0;
        }
        int code = font.getFontIndex() + 2015;
        code = code << 3 ^ font.getStyle();
        code = code << 3 ^ font.getSize();
        code = code << 3 ^ font.getColor();
        return code;
    }

    public static boolean styleEqualsByFontIndex(Font a, Font b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getFontIndex() != b.getFontIndex()) {
            return false;
        }
        return a.getStyle() == b.getStyle() && a.getSize() == b.getSize() && a.getColor() == b.getColor();
    }

    public static boolean styleEquals(Font a, Font b) {
        if (a == null || b == null) {
            return false;
        }
        if (!a.getName().equalsIgnoreCase(b.getName())) {
            return false;
        }
        return a.getStyle() == b.getStyle() && a.getSize() == b.getSize() && a.getColor() == b.getColor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Font font = (Font)o;
        return Font.styleEquals(this, font);
    }

    public int hashCode() {
        return Font.styleHashCode(this);
    }

    public boolean isParent() {
        return this.option == 0 && this.color == 0x1FFFFFFF;
    }

    public boolean isParentFont() {
        return (this.option & 0x3000000) != 0 || this.color == 0x1FFFFFFF;
    }

    public boolean isParentName() {
        return (this.option & 0x1000000) == 0;
    }

    public boolean isParentSize() {
        return (this.option & 0x2000000) == 0;
    }

    public boolean isParentStyle() {
        return (this.option & 0x4000000) == 0;
    }

    public boolean isParentColor() {
        return this.color == 0x1FFFFFFF;
    }

    public int getFontIndex() {
        String parentName = "";
        if (this.parent != null && this.parent.name != null) {
            parentName = this.parent.name;
        }
        if (this.fontIndex != -1) {
            return this.fontIndex;
        }
        if (this.parent != null && !parentName.isEmpty()) {
            this.fontIndex = Font.getFontIndexByName(this.parent.name);
        }
        return this.fontIndex;
    }

    private static int getFontIndexByName(String fontName) {
        if (fontName.equalsIgnoreCase("Arial")) {
            return 0;
        }
        if (fontName.equalsIgnoreCase(DEFAULT_FONT_NAME)) {
            return 1;
        }
        if (fontName.equalsIgnoreCase("Tahoma")) {
            return 2;
        }
        if (fontName.equalsIgnoreCase("MS Sans Serif")) {
            return 3;
        }
        if (fontName.equalsIgnoreCase("Courier New")) {
            return 4;
        }
        if (fontName.equalsIgnoreCase("System")) {
            return 5;
        }
        return 1;
    }
}

