/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class TableMargins {
    private static final int TAG_WEB_MARGINS_LEFT = 1;
    private static final int TAG_WEB_MARGINS_RIGHT = 2;
    private static final int TAG_WEB_MARGINS_TOP = 3;
    private static final int TAG_WEB_MARGINS_BOTTOM = 4;
    public static final double DEFAULT_CELL_MARGIN_LEFT = 1.9;
    public static final double DEFAULT_CELL_MARGIN_RIGHT = 1.9;
    public static final double DEFAULT_CELL_MARGIN_TOP = 0.0;
    public static final double DEFAULT_CELL_MARGIN_BOTTOM = 0.0;
    private double left = -1.0;
    private double right = -1.0;
    private double top = -1.0;
    private double bottom = -1.0;

    public TableMargins() {
    }

    public TableMargins(Scriptable scope) {
    }

    public String getClassName() {
        return "TableMargins";
    }

    public void assign(TableMargins m) {
        this.left = m.left;
        this.right = m.right;
        this.top = m.top;
        this.bottom = m.bottom;
    }

    public void storeAs(int tagCellMargins, TaggedWriter out) throws IOException {
        this.update();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        writer.putDouble(1, this.left);
        writer.putDouble(2, this.right);
        writer.putDouble(3, this.top);
        writer.putDouble(4, this.bottom);
        writer.flush();
        out.putRaw(tagCellMargins, stream);
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.left = in.getDouble();
                    break;
                }
                case 2: {
                    this.right = in.getDouble();
                    break;
                }
                case 3: {
                    this.top = in.getDouble();
                    break;
                }
                case 4: {
                    this.bottom = in.getDouble();
                }
            }
        }
    }

    public void update() {
        if (this.left < 0.0) {
            this.left = 1.9;
        }
        if (this.right < 0.0) {
            this.right = 1.9;
        }
        if (this.top < 0.0) {
            this.top = 0.0;
        }
        if (this.bottom < 0.0) {
            this.bottom = 0.0;
        }
    }

    public void updateLeft(double v) {
        if (this.left < 0.0) {
            this.left = v;
        }
    }

    public void updateRight(double v) {
        if (this.right < 0.0) {
            this.right = v;
        }
    }

    public void updateTop(double v) {
        if (this.top < 0.0) {
            this.top = v;
        }
    }

    public void updateBottom(double v) {
        if (this.bottom < 0.0) {
            this.bottom = v;
        }
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double bottom) {
        this.bottom = bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double right) {
        this.right = right;
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableMargins) {
            TableMargins that = (TableMargins)obj;
            return that.left == this.left && that.top == this.top && that.right == this.right && that.bottom == this.bottom;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.left) ^ Double.doubleToLongBits(this.left) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.right) ^ Double.doubleToLongBits(this.right) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.top) ^ Double.doubleToLongBits(this.top) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.bottom) ^ Double.doubleToLongBits(this.bottom) >>> 32);
        return hash;
    }
}

