/*
 * Decompiled with CFR 0.152.
 */
package inform.common;

import inform.adt.DateTime;
import inform.adt.collections.ArrayMap;
import java.util.GregorianCalendar;

public enum DateFunction {
    sfNone(0, "\u041d\u0435\u0442"),
    sfDate(1, "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430"),
    sfPrevDate(14, "\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDay(false);
        }
    }
    ,
    sfNextDate(15, "\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0434\u0430\u0442\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDay(true);
        }
    }
    ,
    sfMonth(3, "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446"),
    sfPrevMonth(9, "\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446"){

        @Override
        public double getDate() {
            return DateFunction.getMonth(false);
        }
    }
    ,
    sfNextMonth(6, "\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446"){

        @Override
        public double getDate() {
            return DateFunction.getMonth(true);
        }
    }
    ,
    sfFirstDayInMonth(20, "\u041d\u0430\u0447\u0430\u043b\u043e \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfMonth(false);
        }
    }
    ,
    sfLastDayInMonth(21, "\u041a\u043e\u043d\u0435\u0446 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfMonth(true);
        }
    }
    ,
    sfFirstDayInPrevMonth(16, "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"){

        @Override
        public double getDate() {
            return DateFunction.firstDayOfMonth(false, false);
        }
    }
    ,
    sfFirstDayInNextMonth(17, "\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"){

        @Override
        public double getDate() {
            return DateFunction.firstDayOfMonth(true, false);
        }
    }
    ,
    sfLastDayInPrevMonth(18, "\u041a\u043e\u043d\u0435\u0446 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"){

        @Override
        public double getDate() {
            return DateFunction.firstDayOfMonth(false, true);
        }
    }
    ,
    sfLastDayInNextMonth(19, "\u041a\u043e\u043d\u0435\u0446 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430"){

        @Override
        public double getDate() {
            return DateFunction.firstDayOfMonth(true, true);
        }
    }
    ,
    sfQuarter(22, "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0432\u0430\u0440\u0442\u0430\u043b"){

        @Override
        public double getDate() {
            return DateFunction.getQuarter();
        }
    }
    ,
    sfPrevQuarter(23, "\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u043a\u0432\u0430\u0440\u0442\u0430\u043b"){

        @Override
        public double getDate() {
            return DateFunction.firstMonthQuarter(false);
        }
    }
    ,
    sfNextQuarter(24, "\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043a\u0432\u0430\u0440\u0442\u0430\u043b"){

        @Override
        public double getDate() {
            return DateFunction.firstMonthQuarter(true);
        }
    }
    ,
    sfYear(2, "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0433\u043e\u0434"),
    sfPrevYear(12, "\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0433\u043e\u0434"){

        @Override
        public double getDate() {
            return DateFunction.getYear(false);
        }
    }
    ,
    sfNextYear(13, "\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0433\u043e\u0434"){

        @Override
        public double getDate() {
            return DateFunction.getYear(true);
        }
    }
    ,
    sfFirstDayInYear(4, "\u041d\u0430\u0447\u0430\u043b\u043e \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfThisYear(false);
        }
    }
    ,
    sfFirstDayInPrevYear(10, "\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfYear(false, false);
        }
    }
    ,
    sfFirstDayInNextYear(5, "\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfYear(true, false);
        }
    }
    ,
    sfLastDayInYear(7, "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfThisYear(true);
        }
    }
    ,
    sfLastDayInPrevYear(11, "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfYear(false, true);
        }
    }
    ,
    sfLastDayInNextYear(8, "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0433\u043e\u0434\u0430"){

        @Override
        public double getDate() {
            return DateFunction.getDayOfYear(true, true);
        }
    };

    private final String name;
    private final int id;
    private static final ArrayMap<DateFunction> typeMap;

    private DateFunction(Integer id, String name) {
        this.name = name;
        this.id = id;
    }

    public static DateFunction fromID(int id) {
        DateFunction result = typeMap.get(id);
        if (result == null) {
            throw new IllegalArgumentException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c id (" + id + ")");
        }
        return result;
    }

    public static DateFunction fromIntDef(int id) {
        DateFunction result = typeMap.get(id);
        return result != null ? result : sfNone;
    }

    public int toInt() {
        return this.id;
    }

    public static DateFunction forName(String name) {
        return DateFunction.valueOf(name);
    }

    public double getDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        DateFunction.timeToZero(calendar);
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getDay(boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(6, forward ? 1 : -1);
        DateFunction.timeToZero(calendar);
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getMonth(boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(2, forward ? 1 : -1);
        DateFunction.timeToZero(calendar);
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getDayOfMonth(boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        int day = forward ? calendar.getActualMaximum(5) : calendar.getActualMinimum(5);
        calendar.set(5, day);
        if (forward) {
            DateFunction.timeToEndOfDay(calendar);
        } else {
            DateFunction.timeToZero(calendar);
        }
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double firstDayOfMonth(boolean rollMonth, boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(2, rollMonth ? 1 : -1);
        int day = forward ? calendar.getActualMaximum(5) : calendar.getActualMinimum(5);
        calendar.set(5, day);
        if (forward) {
            DateFunction.timeToEndOfDay(calendar);
        } else {
            DateFunction.timeToZero(calendar);
        }
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double firstMonthQuarter(boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(2, forward ? 3 : -3);
        int month = calendar.get(2);
        month = month < 3 ? 0 : (month < 6 ? 3 : (month < 9 ? 6 : 9));
        calendar.set(5, 1);
        calendar.set(2, month);
        DateFunction.timeToZero(calendar);
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getQuarter() {
        GregorianCalendar calendar = new GregorianCalendar();
        int month = calendar.get(2);
        month = month < 3 ? 0 : (month < 6 ? 3 : (month < 9 ? 6 : 9));
        calendar.set(2, month);
        calendar.set(5, 1);
        DateFunction.timeToZero(calendar);
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getYear(boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(1, forward ? 1 : -1);
        DateFunction.timeToZero(calendar);
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getDayOfThisYear(boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (forward) {
            calendar.set(6, calendar.getActualMaximum(6));
            DateFunction.timeToEndOfDay(calendar);
        } else {
            calendar.set(6, calendar.getActualMinimum(6));
            DateFunction.timeToZero(calendar);
        }
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static double getDayOfYear(boolean rollYear, boolean forward) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(1, rollYear ? 1 : -1);
        if (forward) {
            calendar.set(6, calendar.getActualMaximum(6));
            DateFunction.timeToEndOfDay(calendar);
        } else {
            calendar.set(6, calendar.getActualMinimum(6));
            DateFunction.timeToZero(calendar);
        }
        return DateTime.fromUnixTime(calendar.getTimeInMillis());
    }

    private static void timeToZero(GregorianCalendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void timeToEndOfDay(GregorianCalendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
    }

    public String getNameFunction() {
        return this.name;
    }

    static {
        DateFunction[] values = DateFunction.values();
        DateFunction[] map = new DateFunction[values.length];
        DateFunction[] dateFunctionArray = values;
        int n = dateFunctionArray.length;
        for (int i = 0; i < n; ++i) {
            DateFunction value;
            map[value.id] = value = dateFunctionArray[i];
        }
        typeMap = new ArrayMap<DateFunction>(map);
    }
}

