define([
    'static.wcl.Core'
], function(Core) {
    function Align(parent, container, arg) {
        this.invalidate = function() {
            parent.invalidate();
        };
        var item = Core._mk(this, container, arg.item);
        var ah = arg.horz || Align.HORZ.JUSTIFY;
        var av = arg.vert || Align.VERT.JUSTIFY;
        this.flowType = arg.flowType|0;
        if(arg.wdiID)
        {
            this.dbg = "Align";
            this.wdiID = arg.wdiID;
        }
        if(arg.wdiNAME)
            this.wdiName = arg.wdiNAME;
        this.calculate = function() {
            var c = item.calculate();
            return {
                _ic: c,
                min: c.min,
                max: {
                    x: ah.calcmax(c.min.x, c.max.x),
                    y: av.calcmax(c.min.y, c.max.y)
                }
            };
        };
        this.validate = function(arg) {
            var r = arg.rect, c = arg.calc;
            item.validate({
                rect: {
                    p: {
                        x: ah.vp(r.p.x, r.s.x, c.min.x),
                        y: av.vp(r.p.y, r.s.y, c.min.y)
                    },
                    s: {
                        x: ah.vs(r.s.x, c.min.x),
                        y: av.vs(r.s.y, c.min.y)
                    }
                },
                calc: arg.calc._ic
            });
        };
    }
    function cm_min(min, max){return min;}
    function cm_max(min, max){return max;}
    function vs_cmin(s, cmin){return cmin;}
    function vs_orig(s, cmin){return s;}
    Align.HORZ = {
        LEFT:   {calcmax:cm_min, vs:vs_cmin, vp:function(p, s, cmin){return p;}},
        CENTER: {calcmax:cm_min, vs:vs_cmin, vp:function(p, s, cmin){return p+(s-cmin)/2;}},
        RIGHT:  {calcmax:cm_min, vs:vs_cmin, vp:function(p, s, cmin){return p+s-cmin;}},
        JUSTIFY:{calcmax:cm_max, vs:vs_orig, vp:function(p, s, cmin){return p;}}
    };
    Align.VERT = {
        TOP:    Align.HORZ.LEFT,
        MIDDLE: Align.HORZ.CENTER,
        BOTTOM: Align.HORZ.RIGHT,
        JUSTIFY:Align.HORZ.JUSTIFY
    };
    return Align;
});

