define([
    'static.wcl.Core',
    'static.wcl.Theme'
], function(Core, Theme) {
    function Spacer(parent, container, arg) {
        this.calculate = function() {
            return {
                min: {x: 0, y: 0},
                max: {x: Core.Control.UNBOUND_MAX.x, y: 0}
            };
        };
        this.validate = function() {
        };
    }
    return {
        Shrink: function(cls) {
            return function(parent, container, arg) {
                arg._ = cls;
                var item = Core._mk(parent, container, arg);
                this.calculate = function() {
                    var ca = item.calculate();
                    return {
                        min: ca.min,
                        max: ca.min,
                        _ca: ca
                    };
                };
                this.validate = function(arg) {
                    item.validate({rect: arg.rect, calc: arg.calc._ca});
                };
            };
        },
        Spacer: Spacer,
        Margin: function(cls, gap) {
            var M = gap || Theme.GAP;
            return function(parent, container, arg) {
                arg._ = cls;
                this.flowType = arg.flowType||0;
                var item = Core._mk(parent, container, arg);
                var oldcalc = item.calculate, oldvald = item.validate;
                item.calculate = function() {
                    var ca = oldcalc.call(item);
                    return {
                        min: {x: ca.min.x + M * 2, y: ca.min.y + M * 2},
                        max: {x: ca.max.x + M * 2, y: ca.max.y + M * 2},
                        _ca: ca
                    };
                };
                item.validate = function(arg) {
                    var r = arg.rect;
                    oldvald.call(item, {
                        rect: {
                            p: {x: r.p.x + M, y: r.p.y + M},
                            s: {x: r.s.x - M * 2, y: r.s.y - M * 2}
                        },
                        calc: arg.calc._ca
                    });
                };
                return item;
            };
        },
        Indent: function(parent, container, arg)
        {
            var item = Core._mk(parent, container, arg.item);
            var lm = arg.lm !== undefined ? Core.unit2px(arg.lm) : 0;
            var rm = arg.rm !== undefined ? Core.unit2px(arg.rm) : 0;
            var tm = arg.tm !== undefined ? Core.unit2px(arg.tm) : 0;
            var bm = arg.bm !== undefined ? Core.unit2px(arg.bm) : 0;
            if(arg.wdiID)
            {
                this.dbg = "Indent";
                this.wdiID = arg.wdiID;
            }
            if(arg.wdiNAME)
                this.wdiName = arg.wdiNAME;
            this.flowType = arg.flowType||0;
            this.calculate = function()
            {
                var ca = item.calculate();
                return {
                    min: {x: ca.min.x + lm+rm, y: ca.min.y + tm+bm},
                    max: {x: ca.max.x + lm+rm, y: ca.max.y + tm+bm},
                    _ca: ca
                };
            };
            this.validate = function(arg) {
                var r = arg.rect;
                item.validate({
                    rect: {
                        p: {x: r.p.x + lm, y: r.p.y + tm},
                        s: {x: r.s.x - lm-rm, y: r.s.y - tm-bm}
                    },
                    calc: arg.calc._ca
                });
            };
        }
    };
});
