define([
    'static.wcl.Core'
  , 'inform.agent.web.Styles'
], function(Core, Styles) {
    Styles.sheet().rules({
        '.wcl-check': {
            'margin': 0
        }
    });
    function Check(parent, container, arg) {
        var element = document.createElement('input');
        element.className = 'wcl-check';
        element.type = 'checkbox';
        Core._modelUpdater(arg.checked, function(checked) {
            element.checked = checked;
        });
        if (arg.checked && arg.checked.set)
            element.onclick = function() {
                arg.checked.set(element.checked);
            };
        else
            element.disabled = true;
        container.appendChild(element);
        this.calculate = function() {
            var sz = Core._measure(element);
            return {
                min: sz,
                max: sz
            };
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
        };
    }
    return Check;
});
