define([
    'static.wcl.Core',
    'inform.agent.web.Styles'
], function(Core, Styles) {
    Styles.sheet().rules({
        '.wcl-scrollpane': {
            'overflow': 'auto'
        }
    });
    return function(parent, container, arg) {
        var element = document.createElement('div');
        element.className = 'wcl-scrollpane';
        container.appendChild(element);
        var item = this.item = arg.item && Core._mk(this, element, arg.item);
        this.element = element;
        this.flowType = 59;
        this.calculate = function() {
            var ca = item ? item.calculate() : {max: Core.Control.UNBOUND_MAX};
            return {
                min: {x: 8, y: 8},
                max: ca.max,
                _cs: {x: element.clientWidth, y: element.clientHeight},
                _ch: ca
            };
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
            if (!item)
                return;
            var r = arg.rect, c = arg.calc, s = {
                x: Math.max(Math.min(r.s.x, c._cs.x), c._ch.min.x),
                y: Math.max(Math.min(r.s.y, c._cs.y), c._ch.min.y)
            };
            item.validate({rect: {p: {x: 0, y: 0}, s: s}, calc: c._ch});
        };
        this.invalidate = function() {
            parent.invalidate();
        };
        function getcsz() {
            return {x: element.clientWidth, y: element.clientHeight};
        }
        var lsz = getcsz();
        (function watch() {
            var sz = getcsz();
            if ((lsz.x !== sz.x) || (lsz.y !== sz.y)) {
                parent.invalidate();
                lsz = sz;
            }
            setTimeout(watch, 250);
        })();
    };
});
