define([
    'static.wcl.Core',
    'static.wcl.layouts.Flow',
    'inform.agent.web.Styles'
], function(Core, Flow, Styles) {
    Styles.sheet().rules({
        '.wcl-toolbar>.wcl-button': {
            'border-radius': 0,
            'border-left-style': 'none',
            ':first-child': {
                'border-top-left-radius': '3px',
                'border-bottom-left-radius': '3px',
                'border-left-style': 'solid'
            },
            ':last-child': {
                'border-top-right-radius': '3px',
                'border-bottom-right-radius': '3px'
            }
        }
    });
    return function(parent, container, arg) {
        var element = document.createElement('div');
        element.className = 'wcl-toolbar';
        container.appendChild(element);
        var item = Core._mk(parent, element, {
            _: Flow, type: Flow.HORZ, gap: 0,
            items: arg.items
        });
        this.appendItem = function(arg) {
            return item.appendItem(arg);
        };
        this.calculate = function() {
            return item.calculate();
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
            item.validate({rect: {p: {x: 0, y: 0}, s: arg.rect.s}, calc: arg.calc});
        };
    };
});