define([
    'inform.agent.web.forms.Actioner'
    , 'inform.agent.web.forms.Datamodel'
    , 'inform.agent.web.utils.Strings'
], function (Actioner, DM, Strings) {
    var WAIT = DM.fetchFPathValue.WAIT, NVAL = DM.fetchFPathValue.NVAL;
    var Expression = CLASS( {
        constructor: function() {
            Expression.inherited.constructor.call( this );
            this.dependencies = {};
        }
    }, Actioner );
    function isval( v ) {
        return (v !== WAIT) && (v !== NVAL);
    }
    function cast_s( v ) {
        return v === null ? "" : v;
    }
    function cast_n( v ) {
        return v === null ? 0 : v;
    }
    function mkun( op ) {
        var f = (typeof op === "function") ? op : new Function( "a", "return " + op + "a;" );
        return function( a ) {
            return function( ctx ) {
                var v = a( ctx );
                if ( !isval( v ) )
                    return v;
                return f( v );
            };
        };
    }
    function mkbin( op ) {
        var f = new Function( "a", "b", "return a" + op + "b;" );
        return function( a, b ) {
            return function( ctx ) {
                var va = a( ctx );
                if ( !isval( va ) )
                    return va;
                var vb = b( ctx );
                if ( !isval( vb ) )
                    return vb;
                var cast = (va === null) || (typeof va === "string") ? cast_s : cast_n;
                return f( cast(va), cast(vb) );
            };
        };
    }
    function mkfold( op ) {
        var f = new Function( "p", "c", "return " + op + ";" );
        return function() {
            var args = arguments, l = args.length;
            return function() {
                var r = NVAL;
                for ( var i = 0; i < l; i++ ) {
                    var v = args[i]();
                    if ( !isval( v ) )
                        return v;
                    r = i ? f( r, v ) : v;
                }
                return r;
            };
        };
    }
    function dsfunc( f ) {
        return function( dsid ) {
            var ds = this.datasources[dsid];
            this.expression.dependencies[ds._id] = ds;
            this.expression._dependOn( [ds] );
            return function() {
                var r;
                if ( !ds._scan( function( cs ) {
                    r = f( cs );
                } ) )
                    return WAIT;
                return r;
            };
        };
    }
    function make( s, datasources, colMap, expKind, visitList ) {
        var f = new Function( "functions", "with(functions){return " + s + '}' );
        var result = new Expression();
        funcs.datasources = datasources;
        funcs.expression = result;
        funcs.colMap = colMap;
        funcs.expKind = expKind;
        if ( visitList !== undefined )
            funcs.visitList = visitList;
        checkFuncs.isHtml = false;
        f( checkFuncs );
        result.isHtml = checkFuncs.isHtml;
        funcs.isHtml = checkFuncs.isHtml;
        result.evaluate = f( funcs );
        return result;
    }
    function isRecursion(fid, dsid, visitList) {
        for (var i = 0; i < visitList.length; i++) {
            if ( visitList[i][0] === fid && visitList[i][1] === dsid )
                return true;
        }
        return false;
    }
    function htmlEnquote(s) {
        if (isval(s) && (typeof s === "string")) {    
            var tmp = "";
            var lc = 0;
            for ( var i = 0; i < s.length; i++ ) {
                var c = s.charAt( i );
                switch ( c ) {
                case '\n':
                    if ( lc != '\r' )
                        tmp += "<br/>";
                    break;
                case '\r':
                    tmp += "<br/>";
                    break;
                case '\t':                
                    tmp += " ";
                    break;
                case '"':
                    tmp += "&quot;";
                    break;
                case '&':
                    tmp += "&amp;";
                    break;
                case '<':
                    tmp += "&lt;";
                    break;
                case '>':
                    tmp += "&gt;";
                    break;
                default:
                    tmp += c;
                    break;
                }
                lc = c;
            }
            return tmp;
        }
        return s;
    }
    var funcs = {
        datasources: null,
        expression: null,        
        colMap: null,
        expKind: "data",
        visitList: [],
        isHtml: false,
        val: function( v ) {
            if (this.isHtml)
                v = htmlEnquote(v);
            return function() {
                return v;
            };
        },
        fld: function( dsid, fid ) {
            var key = fid + ":" + dsid;
            if ( this.colMap === undefined || this.datasources[dsid]) {
                var fpath = DM.mkFieldPath( fid, dsid, this.datasources );
                var deps = DM.gatherFPathDeps( fpath, this.expression.dependencies );
                this.expression._dependOn( deps );
                return function( ctx ) {
                    var v = fpath.length ? DM.fetchFPathValue( fpath, ctx.rower( fpath[0]._datasource ) ) : "";
                    if (this.isHtml)
                        v = htmlEnquote(v);
                    return v;
                };            
            }
            if ( isRecursion(fid, dsid, this.visitList) )
                throw "   !";
            var expr = this.colMap[key].colExpr;
            if (this.expKind === "color" && this.colMap[key].colExprColor !== undefined) {
                expr = this.colMap[key].colExprColor;                
            }
            if (this.expKind === "textColor" && this.colMap[key].colExprTextColor !== undefined) {
                expr = this.colMap[key].colExprTextColor;
            }
            if (this.expKind === "textStyle" && this.colMap[key].colExprTextStyle !== undefined) {
                expr = this.colMap[key].colExprTextStyle;                
            }
            this.visitList.push([fid, dsid]);
            return make(expr, this.datasources, this.colMap, this.expKind, this.visitList).evaluate;            
        },
        fStyle: function( a, s, c ) {
            return function( ctx ) {
                var va = a(ctx);
                if ( !isval( va )  )
                    return va;
                if (s & 0x00000001)
                    va = '<b>' + va + '</b>';
                if (s & 0x00000002)
                    va = '<i>' + va + '</i>';
                if (s & 0x00000004)
                    va = '<u>' + va + '</u>';
                if (s & 0x00000008)
                    va = '<strike>' + va + '</strike>';
                if (c != "null")
                    va = "<span style='color:" + c + ";'>" + va + "</span>";
                return va;
            }
        },
        dse: dsfunc( function(cs){return cs._isEmpty();} ),
        dsi: dsfunc( function(cs){return cs._ridx;} ),
        dsc: dsfunc( function(cs){return cs._rowsCount();} ),
        add: mkbin( "+" ),
        sub: mkbin( "-" ),
        mul: mkbin( "*" ),
        div: mkbin( "/" ),
        mod: mkbin( "%" ),
        ls: mkbin( "<" ),
        le: mkbin( "<=" ),
        gt: mkbin( ">" ),
        ge: mkbin( ">=" ),
        eq: mkbin( "==" ),
        ne: mkbin( "!=" ),
        and: mkbin( "&&" ),
        or: mkbin( "||" ),
        not: mkun( "!" ),
        round: function( a, b ) {
            return function( ctx ) {
                var va = a( ctx );                
                if ( !isval( va ) )
                    return va; 
                if ( b === undefined )
                {
                    return Math.round( va );
                }
                var vb = b( ctx );
                if ( !isval( vb ) || ( vb <= -32768 )) //     roundTo
                {
                    return Math.round( va );
                }
                var shift = Math.pow( 10, -vb );
                var r = va * shift;
                var ri = Math.round( r );
                r = ri / shift;
                return r;
             };
        },
        max: mkfold( "c>p ? c : p" ),
        min: mkfold( "c<p ? c : p" ),
        trim: function( a ) {
            return function( ctx ) {
                var v = a( ctx );
                if ( !isval( v ) )
                    return v;
                return Strings.trimAll(v.toString());
            };
        },
        abs: mkun( Math.abs ),
        nvl: function( a, b ) {
            return function( ctx ) {
                var va = a( ctx );
                if ( va === WAIT )
                    return WAIT;
                return (va !== NVAL) && va || b( ctx );
            };
        },
        caze: function() {
            var args = arguments, l = args.length;
            return function( ctx ) {
                for ( var i = 0; i < l; i++ ) {
                    var a = args[i], v = a( ctx );
                    if ( v === WAIT )
                        return WAIT;
                    if ( v !== NVAL )
                        return v;
                }
                return NVAL;
            };
        },
        when: function( c, v ) {
            return function( ctx ) {
                var cv = c( ctx );
                if ( cv === WAIT )
                    return WAIT;
                if ( cv === NVAL )
                    return NVAL;
                if (typeof (v) === "function")
                    return cv ? v( ctx ) : NVAL;
                else
                    return cv ? v : NVAL;
            };
        }
    };
    var checkFuncs = {
        isHtml: false,
    };
    for ( var i in funcs ) {
        if (funcs[i] instanceof Function )
            checkFuncs[i] = function() {};
    }
    checkFuncs.fStyle = function() {this.isHtml = true;};
    return {
        WAIT: WAIT,
        NVAL: NVAL,
        wrapAsModel: function(expr) {
            var r = function() {
                return expr.evaluate(DM.DefaultContext);
            };
            var listeners = [];
            r._listen = function(l) {
                listeners.push(l);
            };
            expr._listen(function() {
                var v = r();
                for (var i in listeners)
                    listeners[i](v);
            });
            return r;
        },
        make: make
    };
} );