define( [
    "static.jquery.jquery",
    'static.wcl.Theme',
    'inform.agent.web.Styles'
], function($, Theme, Styles) {
    var VPAD = 4;
    Styles.sheet().rules({
        '.dropdown': {
            background: 'white',
            'text-align': 'left',
            overflow: 'auto',
            '> div': {
                padding: VPAD + 'px 12px',
                'border-bottom': '1px solid #C0C0C0',
                cursor: 'default',
                'vertical-align': 'middle',
                'white-space': 'pre',
                'line-height': (Theme.LINECONTROL_HEIGHT - VPAD * 2) + 'px',
                ':last-child': {
                    'border-bottom': 0
                },
                ':hover': {
                    'background-color': '#F0FCFF'
                },
                '.active': {
                    'background-color': '#CCEEFF'
                }
            }
        },
        '.popover': {
            position: 'fixed',
            'border': '1px solid #C0C0C0',
            'border-radius': '3px',
            'box-shadow': '1px 1px 8px 0 #404040',
            'z-index': 1000
        }
    });
    function t_index( obj, val ) {
        if ( arguments.length === 1 )
            return obj[t_index];
        obj[t_index] = val;
    }
    function t_value( obj, val ) {
        if ( arguments.length === 1 )
            return obj[t_value];
        obj[t_value] = val;
    }
    var showed = null;
    function hide() {
        if ( !showed )
            return;
        showed.parentNode && showed.parentNode.removeChild( showed );
        showed = null;
    }
    document.onkeydown = function( e ) {
        e = e || window.event;
        if ( e.keyCode === 27 )
            hide();
    };
    document.onmousedown = function( e ) {
        e = e || window.event;
        var t = e.target || e.srcElement;
        if ( !t )
            return;
        var x = e.clientX, y = e.clientY, o = t;
        while ( o ) {
            x -= o.offsetLeft;
            y -= o.offsetTop;
            o = o.offsetParent;
        }
        if ( x > t.clientWidth )
            return;
        if ( y > t.clientHeight )
            return;
        while ( t ) {
            if ( t === showed )
                return;
            t = t.parentNode;
        }
        hide();
    };
    function placeAroundTarget(showed, target) {
        function fullOffset(c) {
            var o = {x: 0, y: 0};
            while (c) {
                o.x += c.offsetLeft;
                o.y += c.offsetTop;
                c = c.offsetParent;
            }
            return o;
        }
        var o = fullOffset(target), so = fullOffset(showed.offsetParent);
        o.x -= so.x;
        o.y -= so.y;
        var c = target, fixed = false;
        while (c && (c !== document.body) && !(fixed = (c.className === "menubar main"))) {
            o.x -= c.scrollLeft;
            o.y -= c.scrollTop;
            c = c.parentNode;
        }
        if (c && !fixed) {
            o.x -= window.pageXOffset || c.parentNode.scrollLeft;
            o.y -= window.pageYOffset || c.parentNode.scrollTop;
        }
        var view_width = Math.min(window.innerWidth || Number.MAX_VALUE, document.body.clientWidth), view_height = Math.min(window.innerHeight || Number.MAX_VALUE, document.body.clientHeight);
        var space_top = o.y - 32/*TOP_BAR_HEIGHT*/, space_btm = view_height - (o.y + target.offsetHeight);
        var max_width = view_width, max_height;
        if (space_top > space_btm) {
            o.y -= showed.offsetHeight + 1;
            max_height = space_top;
        } else {
            o.y += target.offsetHeight;
            max_height = space_btm;
        }
        if (o.x < 0)
            o.x = 0;
        else if (o.x + showed.offsetWidth > view_width)
            o.x = view_width - showed.offsetWidth;
        function stylePx(pname, val) {
            var _pname = '_' + pname;
            if (showed[_pname] !== val) {
                showed[_pname] = val;
                showed.style[pname] = val + "px";
            }
        }
        stylePx("left", o.x + 1);
        stylePx("top", o.y);
        var opts = showed._options;
        if (opts && opts.setmax) {
            stylePx("maxWidth", max_width);
            stylePx("maxHeight", max_height - 2 - Theme.GAP);
        }
        if (opts && opts.setmin)
            stylePx("minWidth", target.offsetWidth - 2);
    }
    function place() {
        if (showed === null)
            return;
        placeAroundTarget(showed, showed._target);
    }
    if (window.addEventListener)
        window.addEventListener("scroll", place);
    (function timer() {
        place();
        setTimeout(timer);
    })();
    function hasValue( obj, v ) {
        for ( var i in obj )
            if ( obj[i] === v )
                return true;
        return false;
    }
    var module = {
        popover: function( element, target, options ) {
            hide();
            var pos = {left:0, top:0};
            var target$ = $( target );
            var eo = target$.offset(), eop$ = target$.offsetParent();
            if ( eop$ ) {
                var _ = eop$.offset();
                eo.top -= _.top;
                eo.left -= _.left;
            }
            pos = eo;
            pos.top += target$.outerHeight();
            var classes = element.className.split( /\s+/ );
            if ( !hasValue( classes, "default-font" ) )
                classes.unshift( "default-font" );
            if ( !hasValue( classes, "popover" ) )
                classes.push( "popover" );
            element.className =  classes.join( ' ' );
            target.parentNode.appendChild( element );
            element._target = target;
            element._options = options;
            showed = element;
            showed._pref_top = false;
            place();
        },
        show: function( arg ) {
            var element$ = $( arg.element );
            var dd = element$[0][this.show];
            if ( !dd ) {
                var dd$ = $( "<div class='default-font dropdown'></div>" ), tmoUpdate = null, cob = true;
                function cancel() {
                    hide();
                    dd.arg.cancel && dd.arg.cancel();
                    dd.arg.cancel = null;
                }
                element$.keydown( function( e ) {
                    if ( dd$[0].parentNode !== element$[0].parentNode )//hidden
                        return;
                    var idx = t_index( this ) | 0, childs = dd$.children(), clen = childs.length;
                    if ( clen === 0 )
                        return;
                    var oidx = idx;
                    switch ( e.keyCode ) {
                        case 13://enter
                            idx = t_index( this );
                            (idx !== undefined) && dd.arg.value( t_value( childs[idx] ) );
                        case 27://escape
                            dd$.remove();
                            e.preventDefault();
                            return;
                        case 38://up
                            idx--;
                            break;
                        case 40://down
                            idx++;
                            break;
                        default:
                            return;
                    }
                    childs[oidx].className = "";
                    idx = (idx + clen) % clen;
                    childs[idx].className = "active";
                    t_index( this, idx );
                    e.preventDefault();
                } ).blur( function() {
                    cob && cancel();
                } );
                function fill( out ) {
                    clearTimeout( tmoUpdate );
                    tmoUpdate = null;
                    dd$.empty().removeClass( "waiting" );
                    if ( out.length ) {
                    var cv = dd.arg.value();
                    var fd = function( r ){ return r; }, fv = fd;
                    if ( ("label" in out[0]) || ("value" in out[0]) ) {
                        fd = function( r ) { return r.label; };
                        fv = function( r ) { return r.value; };
                    }
                    for ( var i = 0, l = out.length; i < l; i++ ) {
                        var r = out[i], d = fd( r ) || "", v = fv( r );
                        var e$ = $( "<div></div>" ).html( d ).click( function( e ) {
                            dd.arg.value( t_value( this ) );
                            dd$.remove();
                            e.preventDefault();
                        } ).mousedown( function( e ) {
                            var idx = t_index( element$[0] ) | 0;
                            dd$.children()[idx].className = "";
                            this.className = "active";
                            e.preventDefault();
                        } ).appendTo( dd$ ), e = e$[0];
                        if ( v == cv ) {
                            e.className = "active";
                            t_index( element$[0], i );
                        }
                        t_value( e, v );
                        t_index( e, i );
                    }
                        module.popover(dd$[0], arg.element, {setmax: true, setmin:true});
                    }
                    else
                        dd$.remove();
                }
                dd = element$[0][this.show] = function( arg ) {
                    dd.arg = arg;
                    var reshow = dd$[0].parentNode === element$[0].parentNode;
                    if ( !reshow ) {
                        cob = true;
                        var tmoHide = null;
                        dd$.mouseover( function() {
                            cob = false;
                            clearTimeout( tmoHide );
                            tmoHide = null;
                        } ).mouseout( function() {
                            cob = true;
                            if ( document.activeElement !== element$[0] ) {
                                if ( !element$[0].disabled )
                                    cancel();
                                else if ( !tmoHide )
                                    tmoHide = setTimeout( function() {
                                        if ( !tmoHide )
                                            return;
                                        tmoHide = null;
                                        if ( document.activeElement !== element$[0] )
                                            cancel();
                                    } );
                            }
                        } );
                    }
                    element$.focus();
                    if ( (typeof arg.source) === "function" ) {
                        if ( !tmoUpdate )
                            tmoUpdate = setTimeout( function() {
                                if ( !tmoUpdate )
                                    return dd$;
                                tmoUpdate = null;
                                dd$.html( "&nbsp;" ).addClass( "waiting" );
                                dd$.appendTo( element$.parent() );
                                module.popover(dd$[0], arg.element, {setmax: true, setmin:true});
                            }, 250 );
                        arg.source( fill );
                    } else
                        fill( arg.source );
                    return dd$;
                };
            }
            return dd( arg );
        }
    };
    return module;
} );