﻿define(["require", "exports", './Formats', '../utils/Strings'], function (require, exports, F, S) {
    "use strict";
    describe('Formats', function () {
        it('can obtain formats by ID', function () {
            var esists = F.findById(601);
            expect(esists).not.toBe(null);
            var notesists = F.findById(1);
            expect(notesists).toBe(undefined);
        });
        function test_id_option(id, option, expected) {
            var fmt = F.byIdAndOption(id, S.base64_to_bytestr(option));
            expect(fmt.format(12345.6789)).toBe(expected);
        }
        it('provide FloatFormat', function () {
            var fmt = F.findById(601);
            expect(fmt.format(0)).toBe('0');
            expect(fmt.format(0.1)).toBe('0.1');
            expect(fmt.format(12345.6789)).toBe('12345.6789');
            function test_option(option, expected) { test_id_option(601, option, expected); }
            test_option('ZAQAAAAAPgA/AA==', '12346');
            test_option('ZAQCAAAAPgA/AA==', '12345.68');
            test_option('ZAQFAAAAPgA/AA==', '12345.6789');
            test_option('ZAQFAAAAPgA/AGEA', '12345.67890');
            test_option('ZAT/////PgA/AGAA', '12 345.6789');
            test_option('MgBkBP////8+AD8A', '12345');
            test_option('NQBkBP////8+AD8A', '6789');
            test_option('ZAT/////PgA/AFsEAQAAAA==', '12345,6789');
        });
        it('provide MoneyFormat', function () {
            var fmt = F.findById(602);
            expect(fmt.format(0)).toBe('0.00');
            expect(fmt.format(0.1)).toBe('0.10');
            expect(fmt.format(12345.6789)).toBe('12 345.6789');
            function test_option(option, expected) { test_id_option(602, option, expected); }
            test_option('ZAT/////PgA/AGAA', '12 345.6789');
            test_option('ZAQAAAAAPgA/AGAA', '12 346');
            test_option('ZAQBAAAAPgA/AGAA', '12 345.7');
            test_option('ZAT/////PgA/AGAAWwQBAAAA', '12 345,6789');
        });
        it('provide BooleanFormat', function () {
            var fmt = F.findById(701);
            expect(fmt.format(true)).toBe('��');
            expect(fmt.format(false)).toBe('���');
        });
        it('provide SpellMoneyFormat', function () {
            var fmt = F.findById(650);
            expect(fmt.format(0)).toBe('���� ������ 00 ������');
            expect(fmt.format(1.01)).toBe('���� ����� 01 �������');
            expect(fmt.format(12345.6789)).toBe('���������� ����� ������ ����� ���� ������ 68 ������');
            expect(fmt.format(413602121.33)).toBe('��������� ���������� ��������� �������� ��� ������ ��� �������� ���� ����� 33 �������');
            function test_option(option, expected) { test_id_option(650, option, expected); }
            test_option('PQA=', '���������� ����� ������ ����� ���� ������ 68 ������');
            test_option('OwA9ADwEAQAAAA==', '12345 (���������� ����� ������ ����� ����) ������ 68 ������');
            test_option('PQA8BAIAAAA=', '12345 (���������� ����� ������ ����� ����) ���. 68 ���.');
            test_option('PQA8BAMAAAA=', '12345 ������ 68 ������');
            test_option('PQA8BAQAAAA=', '12345 ���. 68 ���.');
            test_option('MgA2AD0A', '���������� ����� ������ ����� ����');
            test_option('MgA3AD0A', '������');
        });
    });
});
