define( function() {
    function createXMLHttpRequest() {
        try {
            return new XMLHttpRequest();
        } catch ( e ) {
            try {
                return new ActiveXObject( "Msxml2.XMLHTTP" );
            } catch ( e ) {
                return new ActiveXObject( "Microsoft.XMLHTTP" );
            }
        }
    }
    var workers = {free: [], count: 0}, tasks = [];
    function shedule( task ) {
        var w = workers.free.shift();
        if ( w )
            return w( task );
        if ( workers.count >= module.workers )
            return tasks.push( task );
        var rq = createXMLHttpRequest();
        workers.count++;
        (function exec( task ) {
            try {
                var arg = task.arg;
                if ( arg instanceof Function )
                    arg = arg();
                var url = arg.url;
                if (url[0] === '/')
                    url = asmo.root + url;
                rq.open(arg.type || "GET", url, true);
                task.abort = function() {
                    rq.abort();
                };
                for ( var i in arg.headers )
                    rq.setRequestHeader( i, arg.headers[i] );
                rq.onreadystatechange = function() {
                    if ( rq.readyState !== 4 )
                        return;
                    try {
                        task.abort = null;
                        if ( rq.status !== 200 ) {
                            var e = rq.responseText;
                            if ( !e ) {
                                if ( rq.status === 0 )
                                    e = task.aborted ? " " : " ";
                                else
                                    e = rq.status + ' ' + rq.statusText;
                            }
                            task.asy.reject( e );
                        } else
                            task.asy.resolve( rq.responseText );
                    } finally {
                        var n = tasks.shift();
                        if ( n )
                            exec( n );
                        else if ( workers.free.length < module.workers )
                            workers.free.push( exec );
                        else
                            workers.count--;
                    }
                };
                var data = arg.data;
                if ( (typeof data) !== 'string' )
                    data = JSON.stringify( data );
                rq.send( data );
            } catch ( e ) {
                task.asy.reject( e );
            }
        })( task );
    }
    var module = {
        workers: 2,
        execute: function( arg ) {
            var result = Asyncs.create( arg.caption );
            var task = {
                arg: arg,
                asy: result
            };
            shedule( task );
            var r = result.promise();
            r.abort = function() {
                task.aborted = true;
                task.abort && task.abort();
            };
            return r;
        }
    };
    return module;
} );