define( [
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.forms.Requests",
    "static.leaflet.leaflet-src",
    "static.jquery.jquery"
], function( WebForm, DM, Requests, L, $ ) {
    require( ["css!/leaflet/leaflet.css"] );
    function make( components ) {
        var sch = this, sch$ = $(sch);
        sch._wcl_calculate = function() {
            return {
                min: {x: 50, y: 50},
                max: {x: 9999, y: 9999}
            };
        };
        var dsid = sch$.attr( "data-datasource" );
        var fid = sch$.attr( "data-datafield" );
        var keepNode = sch$.attr( "data-keepNode" );
        if ( dsid && fid && keepNode ) {
            var params = new DM.Parameters( {
                1: {type:2},//x
                2: {type:2},//y
                3: {type:2},//z
                4: {type:2},//layers Config
                5: {type:2},//id-f
                6: {type:2},//id-o
                7: {type:3}//n
            }, {} );
            var HEX = "0123456789ABCDEF".split( "" );
            var LayerDesc = CLASS( {
                    constructor: function() {
                        name: "";
                        visible: false;
                        layerGroup: null;
                    }
                } );
            var propX =sch$.attr( "data-propX" );
            var propY =sch$.attr( "data-propY" );
            var propZ =sch$.attr( "data-propZ" );
            var propLayersConfig =sch$.attr( "data-propLayersConfig" );
            var propShapeID =sch$.attr( "data-propShapeID" );
            var propObjectID =sch$.attr( "data-propObjectID" );
            var propObjectName =sch$.attr( "data-propObjectName" );
            propX && (components[propX] = params._fbyid[1]);
            propY && (components[propY] = params._fbyid[2]);
            propZ && (components[propZ] = params._fbyid[3]);
            propLayersConfig && (components[propLayersConfig] = params._fbyid[4]);
            propShapeID && (components[propShapeID] = params._fbyid[5]);
            propObjectID && (components[propObjectID] = params._fbyid[6]);
            propObjectName && (components[propObjectName] = params._fbyid[7]);
            var fpath = DM.mkFieldPath( fid.split( ',' ), dsid, components.datamodel._datasources );
            var datasource = fpath[0]._datasource;
            var generateWaiterTimeout = null;
            sch.onload = sch.onerror = function() {
                clearTimeout( generateWaiterTimeout );
                generateWaiterTimeout = null;
                sch$.removeClass( "waiting" );
            };
            var key = undefined;
            var layersConf = "";
            var map = undefined;
            var layer = undefined;
            var layersControl = undefined;
            var rq = null;
            var rqKey = undefined;
            var layerDescs = [];
            var layerDesc = undefined;
            var ignoreLayersConfigChanged = false;
            function update()
            {
                function tryup()
                {
                    function initMap()
                    {
                        map = L.map(sch$[0], {crs: L.CRS.Simple, attributionControl: false});
                        var actionMouseClick = sch$.attr( "data-actionMouseClick" );
                        actionMouseClick = actionMouseClick && new (WebForm.ActionList)( actionMouseClick, components );
                        if ( actionMouseClick )
                            map.on( 'click', function( e ) {
                                var prow = params._row();
                                prow[0] = map.getPixelOrigin().x + e.layerPoint.x;
                                prow[1] = map.getPixelOrigin().y + e.layerPoint.y;
                                prow[2] = map.getZoom();
                                prow[3] = layersConf;
                                var act = actionMouseClick._action();
                                if ( !act )
                                    return;
                                act( {event: window.event} ).then( function() {
                                    //   
                                    var shapeID = prow[4];
                                    var objectID = prow[5];
                                    var objectName = prow[6];

                                    //   
                                    if (shapeID != 0)
                                    {
                                        var ll = L.latLng([e.latlng.lat, e.latlng.lng]);
                                        var popup = L.popup();
                                        popup.setLatLng(ll);
                                        var str = objectName;
                                        if ( str )
                                            str = str + "<br>";
                                        if ( objectID )
                                            str = str + "id : " + objectID;
                                        if ( str )
                                            str = str + "<br>";
                                        str = str + "id : " + shapeID;
                                        popup.setContent(str);
                                        popup.openOn(map);
                                    }
                                } );
                            } );
                         map.on( 'overlayadd', function( e ) {
                             layersConfigChanged();
                         } );
                         map.on( 'overlayremove', function( e ) {
                             layersConfigChanged();
                         } );
                    }
                    function updateLayerUrl()
                    {
                        var s = "";
                        if (layersConf.length > 0)
                            s = "/";
                        var url = asmo.root + "/scheme/" + keepNode + "/" + key + s + layersConf + "/{z}s{x}s{y}s.png";
                        if (!layer)
                        {
                            layer = L.tileLayer(url, {noWrap: true, detectRetina: true});
                            layer.addTo(map);
                        } else
                            layer.setUrl(url);
                    }
                    function layersConfigChanged()
                    {   //      ,  
                        if (!ignoreLayersConfigChanged)
                        {
                            layersConf = "";
                            var v = 0;
                            var m = 0;
                            for ( var i = 0; i < layerDescs.length; i++ )
                            {
                                m = i % 4;
                                if (map.hasLayer(layerDescs[i].layerGroup))
                                {
                                    switch (m)
                                    {
                                        case 0: v = v + 1; break;
                                        case 1: v = v + 2; break;
                                        case 2: v = v + 4; break;
                                        case 3: v = v + 8; break;
                                    }
                                }
                                if ((m == 3) || (i == layerDescs.length - 1))
                                {
                                    layersConf = layersConf + HEX[v];
                                    v = 0;
                                }
                            }
                            updateLayerUrl();
                        }
                    }
                    function delLayersControl()
                    {
                        layersConf = "";
                        ignoreLayersConfigChanged = true; //   layersConfigChanged
                        try
                        {   //     
                            for ( var i = 0; i < layerDescs.length; i++ )
                                if (map.hasLayer(layerDescs[i].layerGroup))
                                    map.removeLayer(layerDescs[i].layerGroup);
                        }
                        finally
                        {
                            ignoreLayersConfigChanged = false;
                        }
                        layerDescs = [];
                        //   
                        if (layersControl)
                        {
                            map.removeControl(layersControl);
                            layersControl = undefined;
                        }
                    }
                    function initLayersControl()
                    {
                        delLayersControl(); //      
                        //    
                        rqKey = key;
                        //   
                        rq = Requests.execute( {
                            caption: "   ",
                            type: "POST",
                            url: "/scheme/layersConfig/" + keepNode + "/" + rqKey
                        } ).then( function( r ) {
                            if (rqKey == key)
                            {
                                delLayersControl();
                                if (r)
                                {    
                                    var result = JSON.parse( r );
                                    if (result) //  layerDescs
                                        for ( var i = 0; i < result.length; i++ ) {
                                            if (result[i])
                                            {
                                                layerDesc = new LayerDesc();
                                                layerDesc.name = result[i].n;
                                                layerDesc.visible = result[i].v;
                                                layerDescs.push(layerDesc);
                                            }
                                        }
                                }    
                                //  
                                layersControl = L.control.layers();
                                layersControl.addTo(map);
                                //
                                ignoreLayersConfigChanged = true; //   layersConfigChanged
                                try
                                {   //      
                                    for ( var j = 0; j < layerDescs.length; j++ )
                                    {
                                        layerDesc = layerDescs[j];
                                        layerDesc.layerGroup = L.layerGroup();
                                        layersControl.addOverlay(layerDesc.layerGroup, layerDesc.name);
                                        if (layerDesc.visible)
                                            map.addLayer(layerDesc.layerGroup);
                                    }
                                }
                                finally
                                {
                                    ignoreLayersConfigChanged = false;
                                }
                                rq = null;
                            }
                        }, function( e ) {
                            if (rqKey == key)
                                rq = null;
                            log.error( e );
                        } );
                    }
                    var row = datasource._row();
                    if (row === null)
                        return false;
                    key = undefined;
                    if (row !== undefined)
                    {
                        if (fpath.length)
                        {
                            key = DM.fetchFPathValue(fpath);
                            if (key === DM.fetchFPathValue.WAIT)
                                return false;
                        }
                    }
                    sch.onload();
                    if (key)
                    {
                        if (!map)
                            initMap();
                        else
                            map.closePopup();
                        map.setView([-128, 128], 1);
                        layersConf = "";
                        updateLayerUrl();
                        initLayersControl();
                    }
                    return true;
                }
                if ( !tryup() && !generateWaiterTimeout )
                    generateWaiterTimeout = setTimeout( function() {
                        if ( generateWaiterTimeout )//IE8 bug
                            sch$.addClass( "waiting" );
                    }, 250 );
            }
            for ( var i in fpath )
                fpath[i]._datasource._listen( update );
            update();
        }
    }
    return {
        initialization: function( root$, components ) {
            root$.find( "div.scheme" ).each( function() {
                make.call( this, components );
            } );
        }
    };
} );


