define( [
    "inform.agent.web.forms.Actioner",
    "inform.agent.web.Modal",
    "inform.agent.web.forms.AsyncUI"
    , "static.jquery.jquery"
], function( Actioner, Modal, AsyncUI, $ ) {
    var BlobManager;
    return BlobManager = CLASS( {
        _IDGEN: 0,
        constructor: function( descriptor ) {
            BlobManager.inherited.constructor.call( this );
            this._descriptor = descriptor;
            var fields = [descriptor.content, descriptor.caption, descriptor.extension];
            this._datasource = null;
            for ( var i in fields ) {
                var f = fields[i];
                if ( !f )
                    continue;
                if ( this._datasource === null )
                    this._datasource = f._datasource;
                else if ( this._datasource !== f._datasource )
                    throw "different datasources";
            }
            this._dependOn( fields );
        },
        _action: function( id ) {
            switch ( id ) {
                case 1://append
                    var ds = this._datasource, self = this;
                    var row = ds._row();
                    return row ? function() {
                        function submitFile( file$ ) {
                            function setDataAndCaption( data, caption ) {
                                row = ds._modify( row );
                                row[self._descriptor.content.index] = data;
                                if ( self._descriptor.caption ) {
                                    if ( self._descriptor.extension ) {
                                        var idx = caption.lastIndexOf( '.' );
                                        if ( idx >= 0 ) {
                                            row[self._descriptor.extension.index] = caption.substr( idx+1 );
                                            row[self._descriptor.caption.index] = caption.substr( 0, idx );
                                        } else
                                            row[self._descriptor.caption.index] = caption;
                                    } else
                                        row[self._descriptor.caption.index] = caption;
                                } else if ( self._descriptor.extension ) {
                                    var idx = caption.lastIndexOf( '.' );
                                    if ( idx >= 0 )
                                        row[self._descriptor.extension.index] = caption.substr( idx+1 );
                                }
                                ds._touch();
                            }
                            var files = file$[0].files;
                            if ( files ) {
                                var file = files[0];
                                var rq = new XMLHttpRequest();
                                var bar$ = $( "<div class='bar'>&nbsp;</div>" );
                                var aborted = false;
                                var m = Modal.show( {
                                    caption: "   ",
                                    content: $( "<div style='padding:1mm'></div>" ).append( $( "<span></span>" ).text( file.name ) ).append( $( "<div style='width:24em;height:2px'></div>" ) ).append( $( "<div class='progress'></div>" ).append( bar$ ) )
                                } );
                                m.onclose = function() {
                                    return AsyncUI.confirm( "  ?" ).then( function() {
                                        aborted = true;
                                        rq.abort();
                                    } );
                                };
                                rq.upload.onprogress = function( e ) {
                                    var p = (e.loaded / e.total * 100).toFixed( 2 ) + '%';
                                    bar$.css( "width", p ).text( p );
                                };
                                rq.open("POST", asmo.root + "/rq/blobData", true);
                                rq.send( file );
                                rq.onreadystatechange = function() {
                                    if ( rq.readyState !== 4 )
                                        return;
                                    m.close();
                                    if ( rq.status === 0 ) {
                                        if ( !aborted )//aborted
                                            log.error( "connection lost" );
                                        return;
                                    }
                                    if ( rq.status !== 200 )
                                        return log.error( rq );
                                    var data = JSON.parse( rq.responseText );
                                    setDataAndCaption( data, file.name );
                                };
                            } else {
                                var tgt = "blobman_" + (BlobManager._IDGEN++);
                                var ifrm$ = $( "<iframe name='" + tgt + "' src='javascript:false;'></iframe>" );
                                var form$ = $("<form method='POST' action='" + asmo.root + "/rq/blobData' target='" + tgt + "' class='hidden'></form>").append(file$);
                                form$[0].encoding = "multipart/form-data";
                                ifrm$.bind( "load", function() {
                                    ifrm$.unbind( "load" );
                                    var fname = file$.val().replace( /.*\\/, '' );
                                    var m = Modal.show( $( "<div style='padding:1mm'></div>" ).append( $( "<span></span>" ).text( fname ) ).append( $( "<div style='width:24em;height:2px'></div>" ) ).append( $( "<div class='progress'><div class='bar'>...</div></div>" ) ), "   " );
                                    ifrm$.bind( "load", function() {
                                        m.close();
                                        var response = ifrm$.contents().text(), data;
                                        try {
                                            data = JSON.parse( response );
                                        } catch ( e ) {
                                            throw "error: " + e + '\n' + response;
                                        }
                                        setDataAndCaption( data, fname );
                                        form$.remove();
                                    } );
                                    form$.submit();
                                } );
                                form$.append( ifrm$ ).appendTo( document.body );
                            }
                        }
                        if ( navigator.appName !== "Microsoft Internet Explorer" ) {
                            var file$ = $( "<input name='file' type='file' class='hidden'>" ).appendTo( document.body );
                            file$.change( function() {
                                submitFile( file$.remove() );
                            } );
                            setTimeout( function() {
                                file$.click();
                            } );
                        } else {
                            var file$ = $( "<input name='file' type='file' style='width:100%'>" );
                            var m = Modal.show( {
                                caption: " ",
                                content: file$
                            } );
                            m.content.css( "padding", "1mm" );
                            var ok = m.addButton( "", function() {
                                m.close();
                                submitFile( file$ );
                            } );
                            file$.change( function() {
                                ok[0].disabled = !file$.val();
                            } );
                            file$.change();
                        }
                    } : null;
                case 2://fetch
                    var ds = this._datasource, self = this;
                    var r = ds._row();
                    if ( (r === null) || (r === undefined) )
                        return null;
                    var rid = 0;
                    for ( var i in ds._keyfields ) {
                        var f = ds._keyfields[i];
                        rid = r[f.index];
                        break;
                    }
                    var fname = r[this._descriptor.caption.index];
                    fname = fname || (rid + ".lob");
                    var fext = this._descriptor.extension ? r[this._descriptor.extension.index] : null;
                    if ( fext ) {
                        var eidx = fname.lastIndexOf( '.' );
                        if ( (eidx < 0) || (fname.substr(eidx+1).toLowerCase() !== fext) )
                            fname += '.' + fext;
                    }
                    var url = "/rq/blobData/" + ds._descriptor.table + '/' + self._descriptor.content.id + '/' + rid + '/' + fname;
                    return function() {
                        var form$ = $( "#blobman_download" );
                        if ( !form$.length ) {
                            form$ = $( "<form id='blobman_download' method='GET' style='display:none'></form>" );
                            form$.appendTo( document.body );
                        }
                        form$.attr( "action", asmo.root + url );
                        form$.submit();
                    };
            }
            return null;
        }
    }, Actioner );
}
);
