/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.security;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.PrivateKeyBuilder;
import io.jsonwebtoken.security.SecretKeyBuilder;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.WeakKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class Keys {
    private static final String BRIDGE_CLASSNAME = "io.jsonwebtoken.impl.security.KeysBridge";
    private static final Class<?> BRIDGE_CLASS = Classes.forName("io.jsonwebtoken.impl.security.KeysBridge");
    private static final Class<?>[] FOR_PASSWORD_ARG_TYPES = new Class[]{char[].class};
    private static final Class<?>[] SECRET_BUILDER_ARG_TYPES = new Class[]{SecretKey.class};
    private static final Class<?>[] PRIVATE_BUILDER_ARG_TYPES = new Class[]{PrivateKey.class};

    private static <T> T invokeStatic(String method, Class<?>[] argTypes, Object ... args) {
        return Classes.invokeStatic(BRIDGE_CLASS, method, argTypes, args);
    }

    private Keys() {
    }

    public static SecretKey hmacShaKeyFor(byte[] bytes) throws WeakKeyException {
        if (bytes == null) {
            throw new InvalidKeyException("SecretKey byte array cannot be null.");
        }
        int bitLength = bytes.length * 8;
        if (bitLength >= 512) {
            return new SecretKeySpec(bytes, "HmacSHA512");
        }
        if (bitLength >= 384) {
            return new SecretKeySpec(bytes, "HmacSHA384");
        }
        if (bitLength >= 256) {
            return new SecretKeySpec(bytes, "HmacSHA256");
        }
        String msg = "The specified key byte array is " + bitLength + " bits which is not secure enough for any JWT HMAC-SHA algorithm.  The JWT JWA Specification (RFC 7518, Section 3.2) states that keys used with HMAC-SHA algorithms MUST have a size >= 256 bits (the key size must be greater than or equal to the hash output size).  Consider using the Jwts.SIG.HS256.key() builder (or HS384.key() or HS512.key()) to create a key guaranteed to be secure enough for your preferred HMAC-SHA algorithm.  See https://tools.ietf.org/html/rfc7518#section-3.2 for more information.";
        throw new WeakKeyException(msg);
    }

    @Deprecated
    public static SecretKey secretKeyFor(SignatureAlgorithm alg) throws IllegalArgumentException {
        Assert.notNull(alg, "SignatureAlgorithm cannot be null.");
        SecureDigestAlgorithm salg = (SecureDigestAlgorithm)Jwts.SIG.get().get(alg.name());
        if (!(salg instanceof MacAlgorithm)) {
            String msg = "The " + alg.name() + " algorithm does not support shared secret keys.";
            throw new IllegalArgumentException(msg);
        }
        return (SecretKey)((SecretKeyBuilder)((MacAlgorithm)salg).key()).build();
    }

    @Deprecated
    public static KeyPair keyPairFor(SignatureAlgorithm alg) throws IllegalArgumentException {
        Assert.notNull(alg, "SignatureAlgorithm cannot be null.");
        SecureDigestAlgorithm salg = (SecureDigestAlgorithm)Jwts.SIG.get().get(alg.name());
        if (!(salg instanceof io.jsonwebtoken.security.SignatureAlgorithm)) {
            String msg = "The " + alg.name() + " algorithm does not support Key Pairs.";
            throw new IllegalArgumentException(msg);
        }
        io.jsonwebtoken.security.SignatureAlgorithm asalg = (io.jsonwebtoken.security.SignatureAlgorithm)salg;
        return (KeyPair)asalg.keyPair().build();
    }

    public static Password password(char[] password) {
        return (Password)Keys.invokeStatic("password", FOR_PASSWORD_ARG_TYPES, new Object[]{password});
    }

    public static SecretKeyBuilder builder(SecretKey key) {
        Assert.notNull(key, "SecretKey cannot be null.");
        return (SecretKeyBuilder)Keys.invokeStatic("builder", SECRET_BUILDER_ARG_TYPES, key);
    }

    public static PrivateKeyBuilder builder(PrivateKey key) {
        Assert.notNull(key, "PrivateKey cannot be null.");
        return (PrivateKeyBuilder)Keys.invokeStatic("builder", PRIVATE_BUILDER_ARG_TYPES, key);
    }
}

