/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.spatial.util.ShapefileReaderJGeom;

class ShapefileHdr {
    public int fileCode;
    public int u1;
    public int u2;
    public int u3;
    public int u4;
    public int u5;
    public int fileLength;
    public int version;
    public int shapeType;
    public double Xmin;
    public double Ymin;
    public double Xmax;
    public double Ymax;
    public double Zmin;
    public double Zmax;
    public double Mmin;
    public double Mmax;
    public static final int size = 100;

    ShapefileHdr() {
    }

    public void fromBuffer(byte[] byArray) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ShapefileReaderJGeom.swapBytes(byArray, 28, 4);
        ShapefileReaderJGeom.swapBytes(byArray, 32, 4);
        for (n = 36; n <= 92; n += 8) {
            ShapefileReaderJGeom.swapBytes(byArray, n, 8);
        }
        this.fileCode = dataInputStream.readInt();
        for (n = 0; n < 5; ++n) {
            dataInputStream.readInt();
        }
        this.fileLength = dataInputStream.readInt();
        this.version = dataInputStream.readInt();
        this.shapeType = dataInputStream.readInt();
        this.Xmin = dataInputStream.readDouble();
        this.Ymin = dataInputStream.readDouble();
        this.Xmax = dataInputStream.readDouble();
        this.Ymax = dataInputStream.readDouble();
        this.Zmin = dataInputStream.readDouble();
        this.Zmax = dataInputStream.readDouble();
        this.Mmin = dataInputStream.readDouble();
        this.Mmax = dataInputStream.readDouble();
    }
}

