/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = Short.MAX_VALUE;
    static final int TTCC_MXIN_OLD = 64;
    private int effectiveTTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short proSvrVer;
    static final byte[] NO_BYTES = new byte[0];
    boolean useCLRBigChunks = false;
    static final byte[] IGNORED = new byte[Short.MAX_VALUE];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final byte[] tmpBuffer10 = new byte[10];
    final int[] retLen = new int[1];
    AtomicReference<OracleConnection> connForException = new AtomicReference();
    static final byte[] NULL_PTR = new byte[]{0, 0, 0, 0};
    static final byte[] NOTNULL_PTR = new byte[]{127, 127, 127, 127};
    ArrayList refVector = null;

    T4CMAREngine() {
    }

    static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(l2 >> 32, 4) + T4CMAREngine.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    static String toHex(short s2) {
        return T4CMAREngine.toHex(s2, 2);
    }

    static String toHex(int n2) {
        return T4CMAREngine.toHex(n2, 4);
    }

    static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n3 = Math.min(64, n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            string = string + T4CMAREngine.toHex(byArray[i2]) + " ";
        }
        if (n3 < n2) {
            string = string + "...";
        }
        return string + "]";
    }

    static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return T4CMAREngine.toHex(byArray, byArray.length);
    }

    abstract void marshalSB1(byte var1) throws IOException;

    abstract void marshalUB1(short var1) throws IOException;

    abstract void marshalSB2(short var1) throws IOException;

    abstract void marshalUB2(int var1) throws IOException;

    abstract void marshalNativeUB2(short var1, boolean var2) throws IOException;

    abstract void marshalSB4(int var1) throws IOException;

    abstract void marshalUB4(long var1) throws IOException;

    abstract void marshalSB8(long var1) throws IOException;

    final void marshalSWORD(int n2) throws IOException {
        this.marshalSB4(n2);
    }

    final void marshalUWORD(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    abstract void marshalB1Array(byte[] var1) throws IOException;

    abstract void marshalB1Array(byte[] var1, int var2, int var3) throws IOException;

    final void marshalUB4Array(long[] lArray) throws IOException {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.marshalSB4((int)(lArray[i2] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    final void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    final void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    final void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    final void marshalCHR(byte[] byArray) throws IOException {
        this.marshalCHR(byArray, 0, byArray.length);
    }

    final void marshalCHR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, n2, n3);
            } else {
                this.marshalB1Array(byArray, n2, n3);
            }
        }
    }

    final void marshalCLR(byte[] byArray, int n2) throws IOException {
        this.marshalCLR(byArray, 0, n2);
    }

    final void marshalCLR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 252) {
            int n4;
            int n5 = 0;
            this.marshalUB1((short)-2);
            do {
                int n6;
                int n7 = n4 = (n6 = n3 - n5) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : n6;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(n4);
                } else {
                    this.marshalUB1((byte)(n4 & 0xFF));
                }
                this.marshalB1Array(byArray, n2 + n5, n4);
            } while ((n5 += n4) < n3);
            this.marshalUB1((short)0);
        } else {
            this.marshalUB1((byte)(n3 & 0xFF));
            if (byArray.length != 0) {
                this.marshalB1Array(byArray, n2, n3);
            }
        }
    }

    final void marshalCLR(DynamicByteArray dynamicByteArray, long l2, int n2) throws IOException {
        if (n2 > 252) {
            int n3;
            int n4 = 0;
            this.marshalUB1((short)-2);
            do {
                int n5;
                int n6 = n3 = (n5 = n2 - n4) > this.effectiveTTCC_MXIN ? this.effectiveTTCC_MXIN : n5;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(n3);
                } else {
                    this.marshalUB1((byte)(n3 & 0xFF));
                }
                dynamicByteArray.marshalB1Array(this, l2 + (long)n4, n3);
            } while ((n4 += n3) < n2);
            this.marshalUB1((short)0);
        } else {
            this.marshalUB1((byte)(n2 & 0xFF));
            if (dynamicByteArray.length != 0L) {
                dynamicByteArray.marshalB1Array(this, l2, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void marshalCLR(InputStream inputStream, int n2) throws IOException {
        int n3 = this.effectiveTTCC_MXIN;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        boolean bl = false;
        this.marshalUB1((short)254);
        try {
            while (!bl) {
                n4 = inputStream.read(byArray, 0, n3);
                if (n4 == -1) {
                    bl = true;
                }
                if (n4 <= 0) continue;
                if (this.useCLRBigChunks) {
                    this.marshalSB4(n4);
                } else {
                    this.marshalUB1((byte)(n4 & 0xFF));
                }
                this.marshalB1Array(byArray, 0, n4);
            }
        }
        finally {
            this.marshalUB1((short)0);
        }
    }

    final void marshalKEYVAL(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, byte[] byArray3, int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != null && nArray[i2] > 0) {
                this.marshalUB4(nArray[i2]);
                this.marshalCLR(byArray[i2], 0, nArray[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i2] != null && nArray2[i2] > 0) {
                this.marshalUB4(nArray2[i2]);
                this.marshalCLR(byArray2[i2], 0, nArray2[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray3[i2] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    final void marshalKEYVAL(byte[][] byArray, byte[][] byArray2, byte[] byArray3, int n2) throws IOException {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != null) {
                nArray[i2] = byArray[i2].length;
            }
            if (byArray2[i2] == null) continue;
            nArray2[i2] = byArray2[i2].length;
        }
        this.marshalKEYVAL(byArray, nArray, byArray2, nArray2, byArray3, n2);
    }

    final void marshalDALC(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 1) {
            this.marshalUB4(0L);
        } else {
            this.marshalUB4(byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    final void marshalKPDKV(byte[][] byArray, byte[][] byArray2, int[] nArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != null) {
                this.marshalUB4(byArray[i2].length);
                this.marshalCLR(byArray[i2], 0, byArray[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i2] != null) {
                this.marshalUB4(byArray2[i2].length);
                this.marshalCLR(byArray2[i2], 0, byArray2[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            this.marshalUB2(nArray[i2]);
        }
    }

    final void unmarshalKPDKV(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2) throws IOException, SQLException {
        int n2 = 0;
        int[] nArray3 = new int[1];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 = (int)this.unmarshalUB4();
            if (n2 > 0) {
                byArray[i2] = new byte[n2];
                this.unmarshalCLR(byArray[i2], 0, nArray3, n2);
                nArray[i2] = nArray3[0];
            }
            if ((n2 = (int)this.unmarshalUB4()) > 0) {
                byArray2[i2] = new byte[n2];
                this.unmarshalCLR(byArray2[i2], 0, nArray3, n2);
            }
            nArray2[i2] = this.unmarshalUB2();
        }
    }

    final void addPtr(byte by) throws IOException {
        if (this.types.rep[4] == 1) {
            this.marshalUB1(by);
        } else if (by == 0) {
            this.marshalB1Array(NULL_PTR);
        } else {
            this.marshalB1Array(NOTNULL_PTR);
        }
    }

    abstract byte unmarshalSB1() throws SQLException, IOException;

    abstract short unmarshalUB1() throws SQLException, IOException;

    abstract short unmarshalSB2() throws SQLException, IOException;

    int unmarshalNativeUB2(boolean bl) throws SQLException, IOException {
        int n2 = 0;
        this.unmarshalNBytes(this.tmpBuffer2, 0, 2);
        n2 = bl ? this.tmpBuffer2[1] << 8 & 0xFF00 | this.tmpBuffer2[0] & 0xFF : this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
        return n2;
    }

    abstract int unmarshalUB2() throws SQLException, IOException;

    final int unmarshalUCS2(byte[] byArray, long l2) throws SQLException, IOException {
        int n2 = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((n2 & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(n2 & 0xFF);
        if (l2 + 1L < (long)byArray.length) {
            byArray[(int)l2] = this.tmpBuffer2[0];
            byArray[(int)l2 + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    abstract int unmarshalSB4() throws SQLException, IOException;

    abstract long unmarshalUB4() throws SQLException, IOException;

    final int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l2;
    }

    final long unmarshalSB8() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)3);
        return l2;
    }

    final int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n2 = this.unmarshalSB4(byArray);
        return n2;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        return l2;
    }

    abstract byte[] unmarshalNBytes(int var1) throws SQLException, IOException;

    abstract int unmarshalNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract int getNBytes(byte[] var1, int var2, int var3) throws SQLException, IOException;

    abstract byte[] getNBytes(int var1) throws SQLException, IOException;

    abstract byte[] unmarshalTEXT(int var1) throws SQLException, IOException;

    byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n2);
        }
        return byArray;
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, n3, 0);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3, int n4) throws SQLException, IOException {
        int n5;
        int n6;
        block24: {
            int n7;
            int n8;
            int n9;
            boolean bl;
            int n10;
            int n11;
            block23: {
                n11 = 0;
                n10 = 0;
                n6 = n2;
                bl = false;
                n5 = 0;
                n9 = 0;
                n8 = 0;
                n7 = -1;
                n11 = this.unmarshalUB1();
                if (n11 < 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                }
                if (n11 == 0) {
                    nArray[0] = 0;
                    return;
                }
                if (this.escapeSequenceNull(n11)) {
                    nArray[0] = 0;
                    return;
                }
                if (n11 == 254) break block23;
                if (n4 - n8 >= n11) {
                    this.unmarshalBuffer(IGNORED, 0, n11);
                    n8 += n11;
                    n11 = 0;
                } else if (n4 - n8 > 0) {
                    this.unmarshalBuffer(IGNORED, 0, n4 - n8);
                    n11 -= n4 - n8;
                    n8 += n4 - n8;
                }
                if (n11 <= 0) break block24;
                n9 = Math.min(n3 - n5, n11);
                n6 = this.unmarshalBuffer(byArray, n6, n9);
                n5 += n9;
                int n12 = n11 - n9;
                if (n12 <= 0) break block24;
                this.unmarshalBuffer(IGNORED, 0, n12);
                break block24;
            }
            n7 = -1;
            block5: while (n7 == -1 || (n11 = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                if (n11 == 254) {
                    switch (n7) {
                        case -1: {
                            n7 = 1;
                            continue block5;
                        }
                        case 1: {
                            n7 = 0;
                            break;
                        }
                        case 0: {
                            if (n11 > 252) {
                                bl = true;
                            }
                            if (bl) {
                                n7 = 0;
                                break;
                            }
                            n7 = 0;
                            continue block5;
                        }
                    }
                }
                if (n6 == -1) {
                    this.unmarshalBuffer(IGNORED, 0, n11);
                } else {
                    n10 = n11;
                    if (n4 - n8 >= n10) {
                        this.unmarshalBuffer(IGNORED, 0, n10);
                        n8 += n10;
                        n10 = 0;
                    } else if (n4 - n8 > 0) {
                        this.unmarshalBuffer(IGNORED, 0, n4 - n8);
                        n10 -= n4 - n8;
                        n8 += n4 - n8;
                    }
                    if (n10 > 0) {
                        n9 = Math.min(n3 - n5, n10);
                        n6 = this.unmarshalBuffer(byArray, n6, n9);
                        n5 += n9;
                        int n13 = n10 - n9;
                        if (n13 > 0) {
                            this.unmarshalBuffer(IGNORED, 0, n13);
                        }
                    }
                }
                n7 = 0;
                if (n11 <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n6 != -1 ? n5 : byArray.length - n2;
        }
    }

    final byte[] unmarshalCLR(int n2, int[] nArray) throws SQLException, IOException {
        byte[] byArray = new byte[n2 * this.conv.c2sNlsRatio];
        this.unmarshalCLR(byArray, 0, nArray, n2);
        return byArray;
    }

    final int[] unmarshalKEYVAL(byte[][] byArray, byte[][] byArray2, int n2) throws SQLException, IOException {
        byte[] byArray3 = new byte[1000];
        int[] nArray = new int[1];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.unmarshalSB4();
            if (n3 > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray[i2] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray[i2], 0, nArray[0]);
            }
            if ((n3 = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray2[i2] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray2[i2], 0, nArray[0]);
            }
            nArray2[i2] = this.unmarshalSB4();
        }
        byArray3 = null;
        return nArray2;
    }

    final int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n3 <= 0) {
            return n2;
        }
        if (byArray.length < n2 + n3) {
            this.unmarshalNBytes(byArray, n2, byArray.length - n2);
            this.unmarshalNBytes(IGNORED, 0, n2 + n3 - byArray.length);
            n2 = -1;
        } else {
            this.unmarshalNBytes(byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    final byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        int n2 = 0;
        short s2 = 0;
        byte[] byArray = null;
        short s3 = this.unmarshalUB1();
        if (s3 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (s3 == 0) {
            return null;
        }
        boolean bl = this.escapeSequenceNull(s3);
        if (!bl) {
            if (this.refVector == null) {
                this.refVector = new ArrayList(10);
            } else {
                this.refVector.clear();
            }
        }
        if (!bl) {
            byte[] byArray2;
            if (s3 == 254) {
                while ((n2 = this.useCLRBigChunks ? this.unmarshalSB4() : (int)this.unmarshalUB1()) > 0) {
                    if (n2 == 254 && !this.useCLRBigChunks && this.types.isServerConversion()) continue;
                    s2 = (short)(s2 + n2);
                    byArray2 = new byte[n2];
                    this.unmarshalBuffer(byArray2, 0, n2);
                    this.refVector.add(byArray2);
                }
            } else {
                s2 = s3;
                byArray2 = new byte[s3];
                this.unmarshalBuffer(byArray2, 0, s3);
                this.refVector.add(byArray2);
            }
            byArray = new byte[s2];
            int n3 = 0;
            while (this.refVector.size() > 0) {
                int n4 = ((byte[])this.refVector.get(0)).length;
                System.arraycopy(this.refVector.get(0), 0, byArray, n3, n4);
                n3 += n4;
                this.refVector.remove(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    final boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
            case 255: {
                bl = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return bl;
    }

    final int processIndicator(boolean bl, int n2) throws SQLException, IOException {
        short s2 = this.unmarshalSB2();
        int n3 = 0;
        if (!bl) {
            n3 = s2 == 0 ? n2 : (s2 == -2 || s2 > 0 ? (int)s2 : 65536 + s2);
        }
        return n3;
    }

    final int unmarshalDALC(byte[] byArray, int n2) throws SQLException, IOException {
        int n3 = (int)this.unmarshalUB4();
        if (n3 > 0) {
            this.unmarshalCLR(byArray, n2, this.retLen);
        }
        return n3;
    }

    final byte[] unmarshalDALC() throws SQLException, IOException {
        byte[] byArray;
        int n2 = (int)this.unmarshalUB4();
        if (n2 > 0) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
        } else {
            byArray = NO_BYTES;
        }
        return byArray;
    }

    final byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        byte[] byArray;
        int n2 = (int)this.unmarshalUB4();
        if (n2 > 0) {
            byArray = this.unmarshalCLR(n2, nArray);
            if (byArray == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
        } else {
            byArray = NO_BYTES;
        }
        return byArray;
    }

    abstract long buffer2Value(byte var1) throws SQLException, IOException;

    final long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        boolean bl;
        long l2;
        int n2;
        block13: {
            block11: {
                block12: {
                    n2 = 0;
                    l2 = 0L;
                    bl = false;
                    if ((this.types.rep[by] & 1) <= 0) break block11;
                    n2 = byteArrayInputStream.read();
                    if ((n2 & 0x80) > 0) {
                        n2 &= 0x7F;
                        bl = true;
                    }
                    if (n2 < 0) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                    }
                    if (n2 == 0) {
                        return 0L;
                    }
                    if (by == 1 && n2 > 2) break block12;
                    if (by != 2 || n2 <= 4) break block13;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 412).fillInStackTrace();
            }
            if (by == 1) {
                n2 = 2;
            } else if (by == 2) {
                n2 = 4;
            }
        }
        if (byteArrayInputStream.read(byArray = new byte[n2]) < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - i2] & 0xFF) : (short)(byArray[i2] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - i2));
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connForException.get();
    }

    protected void setConnectionDuringExceptionHandling(OracleConnection oracleConnection) {
        this.connForException.set(oracleConnection);
    }

    protected abstract void flush() throws IOException;

    abstract void setByteOrder(byte var1) throws IOException;

    abstract void writeZeroCopyIO(byte[] var1, int var2, int var3) throws IOException, NetException;

    boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException {
        boolean bl = this.net.readZeroCopyIO(byArray, n2, nArray);
        return bl;
    }

    void setUseCLRBigChunks(boolean bl) {
        this.useCLRBigChunks = bl;
        if (bl) {
            this.effectiveTTCC_MXIN = Short.MAX_VALUE;
        } else {
            assert (false);
            this.effectiveTTCC_MXIN = 64;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

