/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessOutputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.io.RandomAccessWrite;

public final class COSOutputStream
extends FilterOutputStream {
    private final List<Filter> filters;
    private final COSDictionary parameters;
    private final RandomAccessStreamCache streamCache;
    private RandomAccess buffer;

    COSOutputStream(List<Filter> filters, COSDictionary parameters, OutputStream output, RandomAccessStreamCache streamCache) throws IOException {
        super(output);
        this.filters = filters;
        this.parameters = parameters;
        this.streamCache = streamCache;
        this.buffer = filters.isEmpty() ? null : streamCache.createBuffer();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b, off, len);
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b);
        } else {
            super.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer == null) {
            super.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.buffer == null) return;
            try {
                int i = this.filters.size() - 1;
                while (i >= 0) {
                    block21: {
                        try (RandomAccessInputStream unfilteredIn = new RandomAccessInputStream((RandomAccessRead)this.buffer);){
                            if (i == 0) {
                                this.filters.get(i).encode((InputStream)unfilteredIn, this.out, this.parameters, i);
                                break block21;
                            }
                            RandomAccess filteredBuffer = this.streamCache.createBuffer();
                            try (RandomAccessOutputStream filteredOut = new RandomAccessOutputStream((RandomAccessWrite)filteredBuffer);){
                                this.filters.get(i).encode((InputStream)unfilteredIn, (OutputStream)filteredOut, this.parameters, i);
                            }
                            finally {
                                this.buffer.close();
                                this.buffer = filteredBuffer;
                            }
                        }
                    }
                    --i;
                }
                return;
            }
            finally {
                this.buffer.close();
                this.buffer = null;
            }
        }
        finally {
            super.close();
        }
    }
}

