/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.dev;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.HWPFOldDocument;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.model.CHPX;
import org.apache.poi.hwpf.model.FieldsDocumentPart;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PAPFormattedDiskPage;
import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.hwpf.usermodel.Bookmark;
import org.apache.poi.hwpf.usermodel.Bookmarks;
import org.apache.poi.hwpf.usermodel.Field;
import org.apache.poi.hwpf.usermodel.OfficeDrawing;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public final class HWPFLister {
    private final HWPFDocumentCore _doc;
    private LinkedHashMap<Integer, String> paragraphs;

    private static HWPFDocumentCore loadDoc(File docFile) throws IOException {
        try (InputStream istream = Files.newInputStream(docFile.toPath(), new OpenOption[0]);){
            HWPFDocumentCore hWPFDocumentCore = HWPFLister.loadDoc(istream);
            return hWPFDocumentCore;
        }
    }

    private static HWPFDocumentCore loadDoc(InputStream inputStream) throws IOException {
        POIFSFileSystem poifsFileSystem = HWPFDocumentCore.verifyAndBuildPOIFS(inputStream);
        try {
            return new HWPFDocument(poifsFileSystem);
        }
        catch (OldWordFileFormatException exc) {
            return new HWPFOldDocument(poifsFileSystem);
        }
    }

    public static void main(String[] args) throws Exception {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static HWPFDocumentCore writeOutAndReadBack(HWPFDocumentCore original) {
        try (UnsynchronizedByteArrayOutputStream baos = UnsynchronizedByteArrayOutputStream.builder().get();){
            HWPFDocumentCore hWPFDocumentCore;
            block14: {
                original.write((OutputStream)baos);
                InputStream is = baos.toInputStream();
                try {
                    hWPFDocumentCore = HWPFLister.loadDoc(is);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return hWPFDocumentCore;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public HWPFLister(HWPFDocumentCore doc) {
        this._doc = doc;
        this.buildParagraphs();
    }

    private void buildParagraphs() {
        this.paragraphs = new LinkedHashMap();
        StringBuilder part = new StringBuilder();
        String text = this._doc.getDocumentText();
        for (int charIndex = 0; charIndex < text.length(); ++charIndex) {
            char c = text.charAt(charIndex);
            part.append(c);
            if (c != '\r' && c != '\u0007' && c != '\f') continue;
            this.paragraphs.put(charIndex, part.toString());
            part.setLength(0);
        }
    }

    private void dumpBookmarks() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument document = (HWPFDocument)this._doc;
        Bookmarks bookmarks = document.getBookmarks();
        for (int b = 0; b < bookmarks.getBookmarksCount(); ++b) {
            Bookmark bookmark = bookmarks.getBookmark(b);
            System.out.println("[" + bookmark.getStart() + "; " + bookmark.getEnd() + "): " + bookmark.getName());
        }
    }

    public void dumpChpx(boolean withProperties, boolean withSprms) {
        for (CHPX chpx : this._doc.getCharacterTable().getTextRuns()) {
            System.out.println(chpx);
            if (withProperties) {
                System.out.println(chpx.getCharacterProperties(this._doc.getStyleSheet(), (short)4095));
            }
            if (withSprms) {
                SprmIterator sprmIt = new SprmIterator(chpx.getGrpprl(), 0);
                while (sprmIt.hasNext()) {
                    SprmOperation sprm = sprmIt.next();
                    System.out.println("\t" + sprm);
                }
            }
            String text = new Range(chpx.getStart(), chpx.getEnd(), this._doc.getOverallRange()){

                @Override
                public String toString() {
                    return "CHPX range (" + super.toString() + ")";
                }
            }.text();
            StringBuilder stringBuilder = new StringBuilder();
            for (char c : text.toCharArray()) {
                if (c < '\u001e') {
                    stringBuilder.append("\\0x").append(Integer.toHexString(c));
                    continue;
                }
                stringBuilder.append(c);
            }
            System.out.println(stringBuilder);
        }
    }

    private void dumpDop() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        System.out.println(((HWPFDocument)this._doc).getDocProperties());
    }

    private void dumpEscher() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        System.out.println(((HWPFDocument)this._doc).getOfficeArtContent());
    }

    public void dumpFIB() {
        FileInformationBlock fib = this._doc.getFileInformationBlock();
        System.out.println(fib);
    }

    private void dumpFields() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument document = (HWPFDocument)this._doc;
        for (FieldsDocumentPart part : FieldsDocumentPart.values()) {
            System.out.println("=== Document part: " + part + " ===");
            for (Field field : document.getFields().getFields(part)) {
                System.out.println(field);
            }
        }
    }

    public void dumpFileSystem() {
        System.out.println(this.dumpFileSystem((DirectoryEntry)this._doc.getDirectory()));
    }

    private String dumpFileSystem(DirectoryEntry directory) {
        StringBuilder result = new StringBuilder();
        result.append("+ ");
        result.append(directory.getName());
        Iterator iterator = directory.getEntries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            Object entryToString = "\n" + this.dumpFileSystem(entry);
            entryToString = ((String)entryToString).replace("\n", "\n+---");
            result.append((String)entryToString);
        }
        result.append("\n");
        return result.toString();
    }

    private String dumpFileSystem(Entry entry) {
        if (entry instanceof DirectoryEntry) {
            return this.dumpFileSystem((DirectoryEntry)entry);
        }
        return entry.getName();
    }

    private void dumpOfficeDrawings() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument document = (HWPFDocument)this._doc;
        if (document.getOfficeDrawingsHeaders() != null) {
            System.out.println("=== Document part: HEADER ===");
            for (OfficeDrawing officeDrawing : document.getOfficeDrawingsHeaders().getOfficeDrawings()) {
                System.out.println(officeDrawing);
            }
        }
        if (document.getOfficeDrawingsHeaders() != null) {
            System.out.println("=== Document part: MAIN ===");
            for (OfficeDrawing officeDrawing : document.getOfficeDrawingsMain().getOfficeDrawings()) {
                System.out.println(officeDrawing);
            }
        }
    }

    public void dumpPapx(boolean withProperties, boolean withSprms) {
        if (this._doc instanceof HWPFDocument) {
            System.out.println("binary PAP pages ");
            HWPFDocument doc = (HWPFDocument)this._doc;
            byte[] mainStream = this._doc.getMainStream();
            PlexOfCps binTable = new PlexOfCps(doc.getTableStream(), doc.getFileInformationBlock().getFcPlcfbtePapx(), doc.getFileInformationBlock().getLcbPlcfbtePapx(), 4);
            ArrayList<PAPX> papxs = new ArrayList<PAPX>();
            int length = binTable.length();
            for (int x = 0; x < length; ++x) {
                GenericPropertyNode node = binTable.getProperty(x);
                int pageNum = LittleEndian.getInt((byte[])node.getBytes());
                int pageOffset = 512 * pageNum;
                PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(mainStream, doc.getDataStream(), pageOffset, doc.getTextTable());
                System.out.println("* PFKP: " + pfkp);
                for (PAPX papx : pfkp.getPAPXs()) {
                    System.out.println("** " + papx);
                    papxs.add(papx);
                    if (papx == null || !withSprms) continue;
                    SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
                    this.dumpSprms(sprmIt, "*** ");
                }
            }
            Collections.sort(papxs);
            System.out.println("* Sorted by END");
            for (PAPX papx : papxs) {
                System.out.println("** " + papx);
                if (papx == null || !withSprms) continue;
                SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
                this.dumpSprms(sprmIt, "*** ");
            }
        }
        for (PAPX papx : this._doc.getParagraphTable().getParagraphs()) {
            System.out.println(papx);
            if (withProperties) {
                Paragraph paragraph = Paragraph.newParagraph(this._doc.getOverallRange(), papx);
                System.out.println(paragraph.getProps());
            }
            SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
            this.dumpSprms(sprmIt, "\t");
        }
    }

    public void dumpParagraphs(boolean dumpAssotiatedPapx) {
        for (Map.Entry<Integer, String> entry : this.paragraphs.entrySet()) {
            Integer endOfParagraphCharOffset = entry.getKey();
            System.out.println("[...; " + (endOfParagraphCharOffset + 1) + "): " + entry.getValue());
            if (!dumpAssotiatedPapx) continue;
            boolean hasAssotiatedPapx = false;
            for (PAPX papx : this._doc.getParagraphTable().getParagraphs()) {
                if (papx.getStart() > endOfParagraphCharOffset || endOfParagraphCharOffset >= papx.getEnd()) continue;
                hasAssotiatedPapx = true;
                System.out.println("* " + papx);
                SprmIterator sprmIt = new SprmIterator(papx.getGrpprl(), 2);
                this.dumpSprms(sprmIt, "** ");
            }
            if (hasAssotiatedPapx) continue;
            System.out.println("* NO PAPX ASSOTIATED WITH PARAGRAPH!");
        }
    }

    private void dumpSprms(SprmIterator sprmIt, String linePrefix) {
        while (sprmIt.hasNext()) {
            SprmOperation sprm = sprmIt.next();
            System.out.println(linePrefix + sprm);
        }
    }

    public void dumpParagraphsDom(boolean withText) {
        Range range = this._doc.getOverallRange();
        for (int p = 0; p < range.numParagraphs(); ++p) {
            Paragraph paragraph = range.getParagraph(p);
            System.out.println(p + ":\t" + paragraph);
            if (!withText) continue;
            System.out.println(paragraph.text());
        }
    }

    private void dumpPictures() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        List<Picture> allPictures = ((HWPFDocument)this._doc).getPicturesTable().getAllPictures();
        for (Picture picture : allPictures) {
            System.out.println(picture);
        }
    }

    private void dumpStyles() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument hwpfDocument = (HWPFDocument)this._doc;
        for (int s = 0; s < hwpfDocument.getStyleSheet().numStyles(); ++s) {
            StyleDescription styleDescription = hwpfDocument.getStyleSheet().getStyleDescription(s);
            if (styleDescription == null) continue;
            System.out.println("=== Style #" + s + " '" + styleDescription.getName() + "' ===");
            System.out.println(styleDescription);
            if (styleDescription.getPAPX() != null) {
                this.dumpSprms(new SprmIterator(styleDescription.getPAPX(), 2), "Style's PAP SPRM: ");
            }
            if (styleDescription.getCHPX() == null) continue;
            this.dumpSprms(new SprmIterator(styleDescription.getCHPX(), 0), "Style's CHP SPRM: ");
        }
    }

    public void dumpTextPieces(boolean withText) {
        for (TextPiece textPiece : this._doc.getTextTable().getTextPieces()) {
            System.out.println(textPiece);
            if (!withText) continue;
            System.out.println("\t" + textPiece.getStringBuilder());
        }
    }
}

