/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import java.util.Arrays;

public class Strings {
    public static final byte BOM_COMPACT_PREFIX1 = 7;
    public static final byte BOM_COMPACT_PREFIX2 = 11;
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public static String suffix(WordCase wc, String s1, String s2) {
        switch (wc) {
            case Nominative: {
                return s1;
            }
            case Genivive: {
                return s2;
            }
        }
        return "_";
    }

    public static boolean equals(String string, String string1) {
        if (string == null) {
            return string1 == null;
        }
        return string.equals(string1);
    }

    public static boolean equalsIgnoreCaseNotNul(String string, String string1) {
        if (Strings.isVoid(string)) {
            return Strings.isVoid(string1);
        }
        return string.equalsIgnoreCase(string1);
    }

    public static boolean containsLowerCaseLetters(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsUpperCaseLetters(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String s, char c) {
        return !s.isEmpty() && s.charAt(0) == c;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        int count;
        if (Strings.isVoid(string) || Strings.isVoid(prefix)) {
            return false;
        }
        int stringLength = string.length();
        if (stringLength < (count = prefix.length())) {
            return false;
        }
        if (stringLength == count) {
            return string.compareToIgnoreCase(prefix) == 0;
        }
        for (int i = 0; i < count; ++i) {
            char p;
            char s = string.charAt(i);
            if (s == (p = prefix.charAt(i)) || (s = Character.toUpperCase(s)) == (p = Character.toUpperCase(p))) continue;
            return false;
        }
        return true;
    }

    public static String unquote(String s) {
        char q0 = s.charAt(0);
        if (q0 != '\"' && q0 != '\'') {
            return s;
        }
        int il = s.length() - 1;
        char q1 = s.charAt(il);
        if (q0 != q1) {
            throw new IllegalArgumentException("string not properly quoted");
        }
        return s.substring(1, il);
    }

    public static boolean isVoid(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isVoid(StringBuilder s) {
        return s == null || s.length() == 0;
    }

    public static String dup(char c, int count) {
        char[] tmp = new char[count];
        Arrays.fill(tmp, c);
        return new String(tmp);
    }

    public static String bytes2hex(byte[] bytes) {
        return Strings.bytes2hex(bytes, 0, bytes.length);
    }

    public static String bytes2hex(byte[] bytes, int offset, int length) {
        char[] result = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            result[i * 2 + 1] = HEX[bytes[i + offset] & 0xF];
            result[i * 2 + 0] = HEX[bytes[i + offset] >> 4 & 0xF];
        }
        return new String(result);
    }

    public static int indexOf(char[] haystack, int haystackLength, char[] needle, int needleLength) {
        char first = needle[0];
        int max = haystackLength - needleLength;
        for (int i = 0; i <= max; ++i) {
            if (haystack[i] != first) {
                while (++i <= max && haystack[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + needleLength - 1;
            int k = 1;
            while (j < end && haystack[j] == needle[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static StringBuilder toJSON(String value, StringBuilder json) {
        json.append('\"');
        block7: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ') {
                if (c == '\"' || c == '\\') {
                    json.append('\\');
                }
                json.append(c);
                continue;
            }
            switch (c) {
                case '\b': {
                    json.append("\\b");
                    continue block7;
                }
                case '\t': {
                    json.append("\\t");
                    continue block7;
                }
                case '\n': {
                    json.append("\\n");
                    continue block7;
                }
                case '\f': {
                    json.append("\\f");
                    continue block7;
                }
                case '\r': {
                    json.append("\\r");
                    continue block7;
                }
                default: {
                    json.append("\\u00");
                    if (c < '\u0010') {
                        json.append('0');
                    }
                    json.append(Integer.toString(c, 16));
                }
            }
        }
        return json.append('\"');
    }

    public static enum WordCase {
        Nominative,
        Genivive;

    }
}

