/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractHashedCollection;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractHash<T>
extends AbstractHashedCollection
implements Iterable<T> {
    protected static final int OPEN_HASH_SHIFT = 1;
    protected T[] data;

    public AbstractHash() {
        this.data = this.allocate(this.capacity << 1);
    }

    @Override
    public void clear() {
        super.clear();
        int len = this.data.length;
        for (int i = 0; i < len; ++i) {
            this.data[i] = null;
        }
    }

    public T add(T o) {
        this.rehashIfNeed();
        T r = this.place(o);
        if (r == null) {
            ++this.size;
        }
        return r;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T next;
            boolean has;
            int idx;

            @Override
            public boolean hasNext() {
                int len = AbstractHash.this.data.length;
                while (!this.has && this.idx < len) {
                    this.has = (this.next = AbstractHash.this.data[this.idx++]) != null;
                }
                return this.has;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.has = false;
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = this.allocate(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        for (T v : this.data) {
            if (v == null) continue;
            a[i++] = v;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    protected abstract int hash(T var1);

    protected abstract boolean equals(T var1, T var2);

    protected T place(T v) {
        T e;
        int m = this.data.length - 1;
        int i = (this.hash(v) & this.mask) << 1;
        while ((e = this.data[i]) != null && !this.equals(e, v)) {
            i = i + 1 & m;
        }
        this.data[i] = v;
        return e;
    }

    @Override
    protected void rehash() {
        T[] old = this.data;
        this.data = this.allocate(this.capacity << 1);
        for (T o : old) {
            if (o == null) continue;
            this.place(o);
        }
    }

    protected abstract T[] allocate(int var1);

    private T[] allocate(Class<?> cls, int count) {
        return (Object[])Array.newInstance(cls, count);
    }

    protected final void deleteAt(int index) {
        T e;
        assert (this.data[index] != null);
        this.data[index] = null;
        --this.size;
        int m = this.data.length - 1;
        int i = index + 1 & m;
        while ((e = this.data[i]) != null) {
            this.data[i] = null;
            this.place(e);
            i = i + 1 & m;
        }
    }

    @Override
    protected boolean toString_appendZero(StringBuilder out) {
        return false;
    }

    @Override
    protected final boolean toString_appendItem(int index, StringBuilder out) {
        T item = this.data[index];
        if (item == null) {
            return false;
        }
        this.itemToString(item, out);
        return true;
    }

    protected void itemToString(T item, StringBuilder out) {
        out.append(':').append(item);
    }

    public int fillFactor() {
        int f = 0;
        int m = 0;
        for (T v : this.data) {
            if (v != null) {
                ++f;
                continue;
            }
            if (m < f) {
                m = f;
            }
            f = 0;
        }
        if (m < f) {
            m = f;
        }
        return m;
    }
}

