/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractHash;
import inform.adt.collections.Hashing;
import java.lang.reflect.Array;

public class ObjectHash<T extends Entry>
extends AbstractHash<T> {
    public T get(Object k) {
        Entry e;
        int m = ((Entry[])this.data).length - 1;
        int i = (Hashing.hash(k) & this.mask) << 1;
        while ((e = ((Entry[])this.data)[i]) != null && !Hashing.equals(e.key(), k)) {
            i = i + 1 & m;
        }
        return (T)e;
    }

    public T remove(Object k) {
        Entry e;
        int m = ((Entry[])this.data).length - 1;
        int i = (Hashing.hash(k) & this.mask) << 1;
        while ((e = ((Entry[])this.data)[i]) != null) {
            if (Hashing.equals(e.key(), k)) {
                this.deleteAt(i);
                break;
            }
            i = i + 1 & m;
        }
        return (T)e;
    }

    @Override
    protected int hashTableLength() {
        return ((Entry[])this.data).length;
    }

    @Override
    protected T[] allocate(int count) {
        return (Entry[])Array.newInstance(Entry.class, count);
    }

    @Override
    protected int hash(T o) {
        return Hashing.hash(o.key());
    }

    @Override
    protected boolean equals(T a, T b) {
        return Hashing.equals(a.key(), b.key());
    }

    @Override
    protected void itemToString(T item, StringBuilder out) {
        out.append(item.key());
        super.itemToString(item, out);
    }

    public static interface Entry {
        public Object key();
    }
}

