/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.LittleEndian;

public class TagVersionInfo {
    public static final long SHA256_PHX_CLIENT_VERSION = TagVersionInfo.toNumber(5L, 2L, 1124L);
    public static final long SHA256_RE_CLIENT_VERSION = TagVersionInfo.toNumber(6L, 0L, 746L);
    static final int TWO_NUMBER_VERSION_MAJOR = 6;
    protected long version;

    public TagVersionInfo() {
        this.version = 0L;
    }

    protected TagVersionInfo(long versionNumber) {
        this.version = versionNumber;
    }

    public TagVersionInfo(TagVersionInfo v) {
        this.version = v.version;
    }

    public TagVersionInfo(long major, long minor, long release) {
        this.version = TagVersionInfo.toNumber(major, minor, release);
    }

    public static byte[] getBinary(int major, int minor, int release) {
        int[] v = new int[]{major, minor, release, 0};
        return LittleEndian.intArrayToBinary(v, v.length);
    }

    public static long toNumber(long major, long minor, long release) {
        return (major << 24 | minor << 16 | release) & 0xFFFFFFFFFFFFFFFFL;
    }

    public static String toString(long version) {
        return TagVersionInfo.toString((int)(version >> 24 & 0xFFL), (int)(version >> 16 & 0xFFL), (int)(version & 0xFFFFL));
    }

    public static String toString(int major, int minor, int release) {
        if (major >= 6 && minor == 0) {
            return major + "." + release;
        }
        return major + "." + minor + "." + release;
    }

    public static long fromString(String version) {
        String[] s = version.split("\\.");
        if (s == null || s.length == 0) {
            return 0L;
        }
        if (s.length == 2) {
            return TagVersionInfo.toNumber(Integer.parseInt(s[0]), 0L, Integer.parseInt(s[1]));
        }
        return TagVersionInfo.toNumber(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
    }

    public void clear() {
        this.version = 0L;
    }

    public void assign(TagVersionInfo v) {
        this.version = v.version;
    }

    public void set(long major, long minor, long release) {
        this.version = TagVersionInfo.toNumber(major, minor, release);
    }

    public void setBinary(byte[] binary) {
        int[] v = LittleEndian.toIntArray(binary);
        this.version = TagVersionInfo.toNumber(v[0], v[1], v[2]);
    }

    public byte[] getBinary() {
        int[] v = new int[]{this.getMajor(), this.getMinor(), this.getRelease(), 0};
        return LittleEndian.intArrayToBinary(v, v.length);
    }

    public long toNumber() {
        return this.version;
    }

    public void setNumber(long number) {
        this.version = number;
    }

    public int getMajor() {
        return (int)(this.version >> 24 & 0xFFL);
    }

    public int getMinor() {
        return (int)(this.version >> 16 & 0xFFL);
    }

    public int getRelease() {
        return (int)(this.version & 0xFFFFL);
    }

    public boolean equals(TagVersionInfo v) {
        return this.version == v.version;
    }

    public boolean equals(Object obj) {
        return obj instanceof TagVersionInfo && this.equals((TagVersionInfo)obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (int)(this.version ^ this.version >>> 32);
        return hash;
    }

    public boolean lessThen(TagVersionInfo v) {
        return this.version < v.version;
    }

    public String toString() {
        return TagVersionInfo.toString(this.getMajor(), this.getMinor(), this.getRelease());
    }

    public static int compare(TagVersionInfo v1, TagVersionInfo v2) {
        return Long.compare(v1.version, v2.version);
    }
}

