/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.DateTime;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;

public class TaggedWriter {
    protected static final byte MAJOR_VERSION = 1;
    protected static final byte MINOR_VERSION = 0;
    public static final int MAX_SHORT_TAG_SIZE = 240;
    public static final int MIN_TAG_SIZE = 2;
    public static final int MIN_LONG_TAG_SIZE = 246;
    public static final int SHORT_HEADER_SIZE = 2;
    public static final int LONG_HEADER_SIZE = 6;
    public static final Charset ANSI = Charset.forName("Cp1251");
    public static final Charset UTF8 = Charset.forName("UTF8");
    public static final Charset UTF16LE = Charset.forName("UTF-16LE");
    protected LittleEndianDataOutputStream stream;

    public TaggedWriter(OutputStream dataStream) {
        this.stream = new LittleEndianDataOutputStream(dataStream);
    }

    protected void writeTagHeader(int tag, int dataSize) throws IOException {
        if (dataSize <= 240) {
            this.stream.writeByte(tag);
            this.stream.writeByte((byte)dataSize);
        } else {
            this.stream.writeByte(255);
            this.stream.writeByte(tag);
            this.stream.writeInt(dataSize);
        }
    }

    public void putRaw(int tag, byte[] data, int offset, int size) throws IOException {
        this.writeTagHeader(tag, size);
        if (data != null && size != 0) {
            this.stream.write(data, offset, size);
        }
    }

    public void putRaw(int tag, byte[] data, int size) throws IOException {
        this.writeTagHeader(tag, size);
        if (data != null && size != 0) {
            this.stream.write(data, 0, size);
        }
    }

    public void putRaw(int tag, byte[] data) throws IOException {
        if (data == null) {
            this.putEmpty(tag);
        } else {
            this.putRaw(tag, data, data.length);
        }
    }

    public void putRaw(int tag, ByteArrayOutputStream data) throws IOException {
        this.putRaw(tag, data.internalBuffer(), data.size());
    }

    public void putIntArray(int tag, int[] data) throws IOException {
        this.writeTagHeader(tag, data.length * 4);
        for (int i = 0; i < data.length; ++i) {
            this.stream.writeInt(data[i]);
        }
    }

    public void putEmpty(int tag) throws IOException {
        this.writeTagHeader(tag, 0);
    }

    public void putInt08(int tag, byte val) throws IOException {
        this.writeTagHeader(tag, 1);
        this.stream.writeByte(val);
    }

    public void putInt16(int tag, short val) throws IOException {
        this.writeTagHeader(tag, 2);
        this.stream.writeShort(val);
    }

    public void putInt32(int tag, int val) throws IOException {
        this.writeTagHeader(tag, 4);
        this.stream.writeInt(val);
    }

    public void putInt64(int tag, long val) throws IOException {
        this.writeTagHeader(tag, 8);
        this.stream.writeLong(val);
    }

    public void putLong(int tag, long val) throws IOException {
        this.writeTagHeader(tag, 8);
        this.stream.writeLong(val);
    }

    public void putDouble(int tag, double val) throws IOException {
        this.writeTagHeader(tag, 8);
        this.stream.writeDouble(val);
    }

    public void putDate(int tag, Date v) throws IOException {
        this.putDouble(tag, DateTime.fromUnixTime(v.getTime()));
    }

    public void putString(int tag, String val) throws IOException {
        byte[] data = val.getBytes(ANSI);
        String revertVal = new String(data, ANSI);
        if (revertVal.equals(val)) {
            this.putRaw(tag, data);
        } else {
            byte[] utf8val = val.getBytes(UTF8);
            int dataSize = utf8val.length + 2;
            this.writeTagHeader(tag, dataSize);
            this.stream.writeByte(7);
            this.stream.writeByte(11);
            this.stream.write(utf8val);
        }
    }

    public void putBool(int tag, boolean val) throws IOException {
        this.putInt08(tag, (byte)(val ? 1 : 0));
    }

    public void putAnsiNull(int tag, String val) throws IOException {
        if (val == null) {
            this.putEmpty(tag);
        } else {
            this.putAnsi(tag, val);
        }
    }

    public void putAnsi(int tag, String val) throws IOException {
        byte[] data = val.getBytes(ANSI);
        this.putRaw(tag, data);
    }

    public void putAnsiIf(int tag, String val) throws IOException {
        if (val == null || val.isEmpty()) {
            return;
        }
        this.putAnsi(tag, val);
    }

    public void putUnicode(int tag, String val) throws IOException {
        byte[] data = val.getBytes(UTF16LE);
        this.putRaw(tag, data);
    }

    public void putSignature() throws IOException {
        this.writeTagHeader(201, 6);
        String tio = "tio";
        byte[] data = tio.getBytes(ANSI);
        this.stream.write(data);
        this.stream.writeByte(0);
        this.stream.writeByte(1);
        this.stream.writeByte(0);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void reset(OutputStream dataStream) throws IOException {
        this.flush();
        this.stream = new LittleEndianDataOutputStream(dataStream);
    }

    public void notifyReady() throws Exception {
    }
}

