/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import com.sun.management.HotSpotDiagnosticMXBean;
import inform.adt.InformException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class HeapDumper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    public static void dumpHeap(String fileName, boolean live) {
        HeapDumper.initHotspotMBean();
        try {
            hotspotMBean.dumpHeap(fileName, live);
        }
        catch (Throwable exp) {
            throw InformException.wrap(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<HeapDumper> clazz = HeapDumper.class;
        synchronized (HeapDumper.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDumper.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            return bean;
        }
        catch (Throwable exp) {
            throw InformException.wrap(exp);
        }
    }
}

