/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.Collections;
import inform.adt.DateTime;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.DatasourceStatistics;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Statistics {
    public final AtomicInteger rqCount = new AtomicInteger();
    public final AtomicLong rqTime = new AtomicLong();
    public final AtomicInteger sqlCount = new AtomicInteger();
    public final AtomicLong sqlTime = new AtomicLong();
    public final AtomicInteger sqlRowsFetched = new AtomicInteger();
    public final AtomicInteger sqlRowsModified = new AtomicInteger();
    private volatile boolean collectDSStatistics = false;
    private double curDatasourceId = 0.0;
    DoubleHash<DatasourceStatistics> dsStatistics = new DoubleHash();

    public synchronized void clearDSStatistics() {
        this.dsStatistics.clear();
    }

    public void startDSStatistics() {
        this.collectDSStatistics = true;
    }

    public void stopDSStatistics() {
        this.collectDSStatistics = false;
    }

    public void request(long duration) {
        this.rqCount.incrementAndGet();
        this.rqTime.addAndGet(duration);
        this.modified();
    }

    public synchronized DatasourceStatistics getDSS(double dsId) {
        if (dsId == 0.0) {
            return null;
        }
        double key = dsId;
        DatasourceStatistics dss = this.dsStatistics.get(key);
        if (dss == null) {
            dss = new DatasourceStatistics(key, false);
            this.dsStatistics.add(dss);
        }
        return dss;
    }

    public synchronized DatasourceStatistics getDSSSummary() {
        DatasourceStatistics result = new DatasourceStatistics(0.0, true);
        for (DatasourceStatistics val : this.dsStatistics) {
            result.addSQLCount(val.getCount());
            result.addSQLRowsFetched(val.getRowsFetched());
            result.addSQLTime(val.getTime());
            result.pushLog(String.format("Datasource ID = %.0f\nTime (ms) = %d\nNumber of SQLs = %d\nRows fetched = %d", val.key(), val.getTime(), val.getCount(), val.getRowsFetched()));
        }
        return result;
    }

    public void sql(long duration) {
        if (this.collectDSStatistics && this.curDatasourceId != 0.0) {
            DatasourceStatistics dss = this.getDSS(this.curDatasourceId);
            dss.addSQLTime(duration);
            dss.addSQLCount(1);
        }
        this.sqlCount.incrementAndGet();
        this.sqlTime.addAndGet(duration);
        this.modified();
    }

    public void sqlRowsModified(int count) {
        this.sqlRowsModified.addAndGet(count);
        this.modified();
    }

    public void sqlRowsFetched(int rowsCount) {
        if (this.collectDSStatistics && this.curDatasourceId != 0.0) {
            DatasourceStatistics dss = this.getDSS(this.curDatasourceId);
            dss.addSQLRowsFetched(rowsCount);
        }
        this.sqlRowsFetched.addAndGet(rowsCount);
        this.modified();
    }

    protected void modified() {
    }

    public synchronized void pickDatasource(double nodeId) {
        this.curDatasourceId = nodeId;
    }

    public static class WithHistory
    extends Statistics {
        private final Collections.Timeline<Slice> slices;
        private final long sliceInterval;
        private long lastSliceTime;

        public WithHistory(int capacity, long sliceInterval) {
            this.slices = new Collections.Timeline(capacity);
            this.sliceInterval = sliceInterval;
        }

        public synchronized void trySlice(long time) {
            if (time - this.lastSliceTime > this.sliceInterval) {
                Slice n = new Slice(time, this.rqCount.get(), this.rqTime.get(), this.sqlCount.get(), this.sqlRowsFetched.get(), this.sqlRowsModified.get(), this.sqlTime.get());
                Slice o = this.slices.last();
                if (o == null || !n.equalsTo(o)) {
                    this.slices.append(n);
                }
                this.lastSliceTime = time;
            }
        }

        public synchronized void write(long from, long to, TaggedWriter out, double oid) throws IOException {
            for (Slice s : this.slices) {
                if (from > s.time || s.time > to) continue;
                s.write(out, oid);
            }
        }
    }

    public static class Slice
    implements Collections.Timeline.Slice {
        public final int rqCount;
        public final int sqlCount;
        public final int sqlRFetched;
        public final int sqlRModified;
        public final long time;
        public final long rqTime;
        public final long sqlTime;

        public Slice(long time, int rqCount, long rqTime, int sqlCount, int sqlRFetched, int sqlRModified, long sqlTime) {
            this.time = time;
            this.rqCount = rqCount;
            this.rqTime = rqTime;
            this.sqlCount = sqlCount;
            this.sqlRFetched = sqlRFetched;
            this.sqlRModified = sqlRModified;
            this.sqlTime = sqlTime;
        }

        @Override
        public long time() {
            return this.time;
        }

        public boolean equalsTo(Slice s) {
            return this.rqCount == s.rqCount && this.rqTime == s.rqTime && this.sqlCount == s.sqlCount && this.sqlRFetched == s.sqlRFetched && this.sqlRModified == s.sqlRModified && this.sqlTime == s.sqlTime;
        }

        public void write(TaggedWriter out, double oid) throws IOException {
            out.putDouble(1, DateTime.fromUnixTime(this.time));
            if (this.sqlCount > 0) {
                out.putInt32(4, this.sqlCount);
            }
            if (this.sqlTime > 0L) {
                out.putDouble(5, DateTime.fromMillis(this.sqlTime));
            }
            if (this.sqlRFetched > 0) {
                out.putInt32(7, this.sqlRFetched);
            }
            if (this.sqlRModified > 0) {
                out.putInt32(6, this.sqlRModified);
            }
            if (this.rqCount > 0) {
                out.putInt32(2, this.rqCount);
            }
            if (this.rqTime > 0L) {
                out.putDouble(3, DateTime.fromMillis(this.rqTime));
            }
            if (oid > 0.0) {
                out.putDouble(8, oid);
            }
        }
    }
}

