/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.agent.db.types.DataType;
import java.util.ArrayList;
import java.util.List;

public class LinkField {
    public static final int LFT_NONE = 0;
    public static final int LFT_CONST = 1;
    public static final int LFT_FIELD = 2;
    public static final int LFT_FIELD_KEY = 3;
    public static final int LFT_NULL = 4;
    private int fieldId;
    private DataType constType;
    private int linkType = 0;
    private double numberValue;
    private Object complexValue;
    private int linkField;

    public LinkField(int fieldId) {
        this.fieldId = fieldId;
    }

    public void setFieldIdLink(int linkFieldId) {
        this.linkType = 2;
        this.linkField = linkFieldId;
    }

    public void setPrimaryKeyLink() {
        this.linkType = 3;
    }

    public void setNullLink() {
        this.linkType = 4;
    }

    public void setConstIntLink(int value) {
        this.linkType = 1;
        this.constType = DataType.INTEGER;
        this.numberValue = value;
    }

    public void setConstDoubleLink(double value) {
        this.linkType = 1;
        this.constType = DataType.FLOAT;
        this.numberValue = value;
    }

    public void setConstDateTimeLink(double value) {
        this.linkType = 1;
        this.constType = DataType.DATE_TIME;
        this.numberValue = value;
    }

    public void setConstAnsiStringLink(String value) {
        this.linkType = 1;
        this.constType = DataType.STRING;
        this.complexValue = value;
    }

    public void setConstUTFStringLink(String value) {
        this.linkType = 1;
        this.constType = DataType.UNICODE;
        this.complexValue = value;
    }

    public DataType getConstType() {
        return this.constType;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public int getLinkField() {
        return this.linkField;
    }

    public int getLinkType() {
        return this.linkType;
    }

    public double getNumberValue() {
        return this.numberValue;
    }

    public String getStringValue() {
        return (String)this.complexValue;
    }

    public int getValueCount() {
        if (this.complexValue instanceof List) {
            return ((List)this.complexValue).size();
        }
        return 1;
    }

    public Object getValueByIndex(int index) {
        if (index == 0 && !(this.complexValue instanceof List)) {
            return this.toComplexValue();
        }
        return ((List)this.complexValue).get(index);
    }

    private Object toComplexValue() {
        if (this.constType != null && this.constType.isNumeric()) {
            return this.numberValue;
        }
        return this.complexValue;
    }

    public void appendConstNumberLink(double value, DataType dataType) {
        if (this.linkType != 0) {
            this.appendToComplexList(value, dataType);
        } else {
            this.linkType = 1;
            this.constType = dataType;
            this.numberValue = value;
        }
    }

    public void appendConstValueLink(Object value, DataType dataType) {
        if (this.linkType != 0) {
            this.appendToComplexList(value, dataType);
        } else if (value == null) {
            this.linkType = 4;
        } else {
            this.linkType = 1;
            this.constType = dataType;
            this.complexValue = value;
        }
    }

    private void appendToComplexList(Object value, DataType dataType) {
        assert (this.linkType == 1 || this.linkType == 4);
        assert (this.constType == dataType);
        ArrayList<Object> list = (ArrayList<Object>)this.complexValue;
        if (list == null) {
            list = new ArrayList<Object>();
            if (this.linkType == 4) {
                list.add(null);
                this.linkType = 1;
            } else {
                list.add(this.toComplexValue());
            }
            this.complexValue = list;
        }
        list.add(value);
    }
}

