/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.agent.Core;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.types.SqlDataType;

public enum DatabaseType {
    INTERBASE(DatabaseCaps.ODBC),
    ODBC(DatabaseCaps.ODBC),
    ORACLE_ODBC(DatabaseCaps.ORACLE),
    MSSQL_ODBC(DatabaseCaps.MSSQL),
    METABASE(null){

        @Override
        public DatabaseCaps caps() {
            return DatabaseType.get((int)Core.getMetadataDBKind()).caps;
        }
    }
    ,
    INSQL_ODBC(DatabaseCaps.MSSQL),
    ORACLE(DatabaseCaps.ORACLE, "ORA"),
    JDBC(DatabaseCaps.JDBC),
    POSTGRESQL(DatabaseCaps.POSTGRESQL, "PGSQL"),
    MYSQL(DatabaseCaps.MYSQL),
    H2(DatabaseCaps.H2);

    public static final int UNASSIGNED = -500;
    private final DatabaseCaps caps;
    private final String shortName;

    private DatabaseType(DatabaseCaps caps) {
        this.caps = caps;
        this.shortName = this.name();
    }

    private DatabaseType(DatabaseCaps caps, String shortName) {
        this.caps = caps;
        this.shortName = shortName;
    }

    public String shortName() {
        return this.shortName;
    }

    public DatabaseCaps caps() {
        return this.caps;
    }

    public static DatabaseType get(int id) {
        DatabaseType[] values = DatabaseType.values();
        if (id < 0 || id >= values.length) {
            throw new IllegalArgumentException("Unknown database type: " + id);
        }
        return DatabaseType.values()[id];
    }

    public static DatabaseType getMetabaseType() {
        return DatabaseType.get(Core.getMetadataDBKind());
    }

    public boolean isOracle() {
        return this == ORACLE || this == ORACLE_ODBC;
    }

    public boolean useUserScheme() {
        return this == ORACLE || this == ORACLE_ODBC || this == POSTGRESQL;
    }

    public String toString() {
        return this.name();
    }

    public static class FunctionArgument {
        public Object value;
        public SqlDataType sqlType;
        public boolean inlined;
    }
}

