/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mssql;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.mssql.schema.Scheme;
import inform.agent.db.schema.DbScheme;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Connection
extends DatabaseConnection {
    private static final int UNIQUE_INDEX_CONSTR_MS_SQL_ERROR = 2601;
    private static final Pattern RG_URL = Pattern.compile("//([^/]+)/(.+)");
    private static final Pattern RG_HOST = Pattern.compile("([^:]+):(\\d+)");
    private static final Pattern RG_INST = Pattern.compile("([^/]+)/(.+)");

    public Connection(DatabaseDescriptor descriptor) throws SQLException, InformException {
        super(descriptor);
    }

    private String getDriver() {
        String dsn = this.descriptor.getServer();
        String url = dsn.startsWith("//") ? dsn : Core.odbcDSNtoURL(dsn);
        if (url.startsWith("//")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    private String getUrl() {
        String dsn = this.descriptor.getServer();
        String url = dsn.startsWith("//") ? dsn : Core.odbcDSNtoURL(dsn);
        if (url.startsWith("//")) {
            Matcher m = RG_URL.matcher(url);
            if (m.matches()) {
                String host = m.group(1);
                String port = null;
                String instance = null;
                String db = m.group(2);
                m = RG_HOST.matcher(host);
                if (m.matches()) {
                    host = m.group(1);
                    port = m.group(2);
                }
                if ((m = RG_INST.matcher(db)).matches()) {
                    instance = m.group(1);
                    db = m.group(2);
                }
                StringBuilder result = new StringBuilder();
                result.append("//").append(host);
                if (port != null) {
                    result.append(':').append(port);
                }
                if (!Strings.isVoid(instance)) {
                    result.append(";instanceName=").append(instance);
                }
                if (!Strings.isVoid(db)) {
                    result.append(";databaseName=").append(db);
                }
                url = result.toString();
            }
            return "jdbc:sqlserver:" + url;
        }
        return "jdbc:odbc:" + dsn;
    }

    @Override
    protected String connectionString() {
        return this.getDriver() + "#" + this.getUrl() + "@" + this.descriptor.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected java.sql.Connection establishConnection() throws SQLException, InformException {
        String url = this.getUrl();
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(this.descriptor.getLogConnectionString(url), ex);
        }
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", this.descriptor.getUserName());
        connectionProperties.put("password", this.descriptor.getPassword());
        connectionProperties.put("charSet", "Cp1251");
        java.sql.Connection c = null;
        try {
            c = DriverManager.getConnection(url, connectionProperties);
            Statement stmt = c.createStatement();
            try {
                stmt.execute("SET DATEFIRST 1");
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
        }
        catch (Exception ex) {
            throw InformException.wrap(ex, String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0411\u0414. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f [ \u0443\u0437\u0435\u043b: %.0f ]", this.descriptor.getNodeId()));
        }
        return c;
    }

    @Override
    public DbScheme openScheme(String name) {
        return new Scheme(name, this, this.jdbcMetadata);
    }

    @Override
    public boolean isUniqueIndexConstraintException(SQLException ex) {
        return ex.getErrorCode() == 2601;
    }

    @Override
    public SQLException prepareException(SQLException e) {
        if (e.getErrorCode() == 242) {
            return new SQLException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u0442\u044b \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430", e);
        }
        return super.prepareException(e);
    }
}

