/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mysql;

import inform.adt.InformException;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.mysql.schema.Scheme;
import inform.agent.db.schema.DbScheme;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;

public class Connection
extends DatabaseConnection {
    private static final Pattern RG_SSRV = Pattern.compile("//[^/:]+(:\\d+)?/[^/]+");

    public Connection(DatabaseDescriptor descriptor) throws InformException, SQLException {
        super(descriptor);
    }

    @Override
    protected String connectionString() {
        return this.descriptor.getServer() + "@" + this.descriptor.getUserName();
    }

    @Override
    protected java.sql.Connection establishConnection() throws SQLException, InformException {
        String ss = this.descriptor.getServer();
        if (ss == null || ss.isEmpty()) {
            throw new SQLException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0411\u0414 MySQL " + this.descriptor.getLogConnectionString(null));
        }
        if (!RG_SSRV.matcher(ss).matches()) {
            throw new SQLException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u043c\u0435\u043d\u0438 \u0411\u0414 MySQL (\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f: \"//<host>[:<port>]/<db>\")");
        }
        String url = "jdbc:mysql:" + this.descriptor.getServer() + "?zeroDateTimeBehavior=convertToNull";
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException ex) {
            throw InformException.detail(ex, this.descriptor.getLogConnectionString(url));
        }
        Properties properties = new Properties();
        properties.setProperty("user", this.descriptor.getUserName());
        properties.setProperty("password", this.descriptor.getPassword());
        properties.setProperty("useUnicode", "true");
        properties.setProperty("characterEncoding", "UTF-8");
        java.sql.Connection result = DriverManager.getConnection(url, properties);
        result.setAutoCommit(false);
        return result;
    }

    @Override
    public DbScheme openScheme(String name) {
        return new Scheme(name, this, this.jdbcMetadata);
    }
}

