/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mysql.schema;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.mysql.schema.Column;
import inform.agent.db.connect.mysql.schema.Index;
import inform.agent.db.connect.mysql.schema.Scheme;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;

class Table
extends DbTable {
    Table(String name, Scheme scheme) {
        super(name, scheme);
    }

    @Override
    protected DbColumn newColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException {
        Column result = new Column(name, type, brt, nullable, size, this);
        statement.execute(ssContext, String.format("ALTER TABLE %s ADD COLUMN %s %s %s %s", this.fullName(), result.name(), result.getSqlType(), this.scheme.columnDefValue(fd, true), nullable ? "" : " NOT NULL"));
        this.addForeignKey(ssContext, statement, result.name(), fd);
        return result;
    }

    @Override
    protected DbColumn newColumnObject(String name) {
        return new Column(name, DataType.NONE, FieldDescriptor.BlobRawType.BINARY, true, 0, this);
    }

    @Override
    protected DbIndex newIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException {
        Index result = new Index(this.scheme.toCaseIfNeed(id.getRawName()), this);
        statement.execute(ssContext, String.format("ALTER TABLE %s ADD %s INDEX %s ( %s )", this.fullName(), id.isUnique() ? "UNIQUE" : "", result.name(), id.fieldsList()));
        return result;
    }

    @Override
    protected DbIndex newIndexObject(String name, int type, String condition) {
        return new Index(name, this);
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, "ALTER TABLE " + this.fullName() + " RENAME TO " + to);
    }
}

