/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.connect.oracle.Connection;
import inform.common.Empty;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.spatial.geometry.JGeometry;

public abstract class Geometry
extends inform.agent.db.types.Geometry {
    public Geometry(int version) {
        super(version);
    }

    abstract void apply(Connection var1, PreparedStatement var2, int var3) throws SQLException;

    private static void toWKB(JGeometry g, LittleEndianDataOutputStream s) throws IOException {
        throw new InformException("\u0422\u0438\u043f \u043f\u043e\u043b\u044f \"\u0413\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (\u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0432\u0435\u0440\u0441\u0438\u0438 5.2.2001)");
    }

    public static class New
    extends Geometry {
        private final byte[] data;

        New(byte[] data) {
            super(1);
            this.data = data;
        }

        public New(TaggedReader reader) throws IOException, TaggedReaderException {
            super(1);
            this.data = reader.next() ? reader.getRaw(2) : Empty.byteArray;
        }

        @Override
        protected void store(TaggedWriter out) throws IOException {
            if (this.data.length != 0) {
                out.putRaw(2, this.data);
            }
        }

        @Override
        protected void apply(Connection connection, PreparedStatement ps, int parameterIndex) throws SQLException {
            throw new InformException("\u0422\u0438\u043f \u043f\u043e\u043b\u044f \"\u0413\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (\u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0432\u0435\u0440\u0441\u0438\u0438 5.2.2001)");
        }

        @Override
        public byte[] toWKB() throws SQLException {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                LittleEndianDataOutputStream s = new LittleEndianDataOutputStream(out);
                JGeometry g = JGeometry.load((byte[])this.data);
                Geometry.toWKB(g, s);
                s.flush();
                return out.toByteArray();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
    }

    public static class Old
    extends Geometry {
        private static final int TAG_GEOM_TYPE = 2;
        private static final int TAG_GEOM_SRID = 3;
        private static final int TAG_GEOM_ORDS = 4;
        private static final int TAG_GEOM_ELEM = 5;
        private static final int TAG_GEOM_POINT = 6;
        private final int type;
        private final int srid;
        private final int linfo;
        private final int dim;
        private final double[] cords;
        private final int[] elems;
        private final double[] point;

        public Old(TaggedReader r) throws IOException, TaggedReaderException {
            super(0);
            this.type = r.getInt(2);
            this.srid = r.getInt(3);
            this.cords = LittleEndian.toDoubleArray(r.getRaw(4));
            this.elems = LittleEndian.toIntArray(r.getRaw(5));
            this.point = r.next() ? LittleEndian.toDoubleArray(r.getRaw(6)) : null;
            this.dim = 0;
            this.linfo = 0;
        }

        public Old(JGeometry g) throws IOException, TaggedReaderException {
            super(0);
            this.type = g.getType();
            this.srid = g.getSRID();
            this.cords = g.getOrdinatesArray();
            this.elems = g.getElemInfo();
            this.point = g.getPoint();
            this.linfo = g.getLRMDimension();
            this.dim = g.getDimensions();
        }

        private static void checkLRS(int dim, double[] ... ords) {
            int step = dim + 1;
            double sign = 0.0;
            double lm = Double.NaN;
            double llm = Double.NaN;
            for (int l = 0; l < ords.length; ++l) {
                double[] o = ords[l];
                int p = dim;
                int i = 0;
                while (p < o.length) {
                    double m = o[p];
                    double s = m - lm;
                    if (s * sign < 0.0) {
                        throw new InformException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0438\u043a\u0435\u0442\u043e\u0432 \u043d\u0435 \u043c\u043e\u043d\u043e\u0442\u043e\u043d\u043d\u044b(" + llm + "," + lm + "," + m + ") (\u043b\u0438\u043d\u0438\u044f:" + l + ",\u0432\u0435\u0440\u0448\u0438\u043d\u0430:" + i + ")");
                    }
                    llm = lm;
                    lm = m;
                    if (s != 0.0) {
                        sign = s;
                    }
                    p += step;
                    ++i;
                }
            }
        }

        @Override
        protected void store(TaggedWriter out) throws IOException {
            throw new UnsupportedOperationException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 GeometryOld \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u043c");
        }

        @Override
        protected void apply(Connection connection, PreparedStatement ps, int parameterIndex) throws SQLException {
            throw new InformException("\u0422\u0438\u043f \u043f\u043e\u043b\u044f \"\u0413\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (\u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0432\u0435\u0440\u0441\u0438\u0438 5.2.2001)");
        }

        private JGeometry toGeometry() {
            int typ = this.type + this.linfo * 100 + this.dim * 1000;
            if (this.point == null) {
                return new JGeometry(typ, this.srid, this.elems, this.cords);
            }
            return new JGeometry(typ, this.srid, this.point.length > 0 ? this.point[0] : 0.0, this.point.length > 1 ? this.point[1] : 0.0, this.point.length > 2 ? this.point[2] : 0.0, this.elems, this.cords);
        }

        @Override
        public byte[] toWKB() throws SQLException {
            try {
                JGeometry g = this.toGeometry();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                LittleEndianDataOutputStream s = new LittleEndianDataOutputStream(out);
                Geometry.toWKB(g, s);
                s.flush();
                return out.toByteArray();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }
    }
}

