/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.postgresql;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.BatchInsertEngine;
import inform.agent.db.BatchInsertEnginePGSQL;
import inform.agent.db.connect.CallableStatement;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.FetchHint;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.postgresql.PreparedStatement;
import inform.agent.db.connect.postgresql.schema.Scheme;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.types.SqlDataType;
import inform.agent.scripts.SSContext;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.postgresql.PGConnection;

public class Connection
extends DatabaseConnection {
    private static final Pattern RG_SSRV = Pattern.compile("//[^/:]+(:\\d+)?/[^/]+");

    public Connection(DatabaseDescriptor descriptor) throws InformException, SQLException {
        super(descriptor);
        this.anycaseFixationNeed = true;
    }

    @Override
    protected String connectionString() {
        return this.descriptor.getServer() + "@" + this.descriptor.getUserName();
    }

    @Override
    protected inform.agent.db.connect.PreparedStatement newPreparedStatement(String comment, String sql) throws SQLException {
        java.sql.PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        preparedStatement.setFetchSize(1024);
        return new PreparedStatement(comment, sql, preparedStatement, this);
    }

    @Override
    protected inform.agent.db.connect.PreparedStatement newPreparedStatement(String comment, String sql, FetchHint hint) throws SQLException {
        switch (hint) {
            case BLOBS: {
                java.sql.PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
                preparedStatement.setFetchSize(4);
                return new PreparedStatement(comment, sql, preparedStatement, this);
            }
        }
        return this.newPreparedStatement(comment, sql);
    }

    @Override
    protected Plan newExplainPlan(boolean trace, String sqlText) throws SQLException, InformException {
        return new Plan(this.prepareStatement("explain(" + (trace ? "analyse, buffers, timing, " : "") + "costs, verbose) " + sqlText)){

            @Override
            public ResultSet explain(SSContext ssContext) throws SQLException {
                return this.statement.executeQuery(ssContext);
            }
        };
    }

    private String getAppName() {
        StringBuilder r = new StringBuilder();
        if (Strings.isVoid(Ini.AgentID)) {
            r.append(Ini.AgentName);
        } else {
            r.append(Ini.AgentID);
        }
        if (!Strings.isVoid(Ini.ServerID)) {
            r.append('@').append(Ini.ServerID);
        }
        long nodeID = (long)this.descriptor.getNodeId();
        r.append("_p").append(Ini.ProcessID).append('n').append(nodeID).append('#').append(this.id);
        return r.toString();
    }

    @Override
    protected java.sql.Connection establishConnection() throws SQLException, InformException {
        String ss = this.descriptor.getServer();
        if (ss == null || ss.isEmpty()) {
            throw new SQLException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0411\u0414 PostgreSQL " + this.descriptor.getLogConnectionString(null));
        }
        if (!RG_SSRV.matcher(ss).matches()) {
            throw new SQLException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u043c\u0435\u043d\u0438 \u0411\u0414 PostgreSQL (\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f: \"//<host>[:<port>]/<db>\")");
        }
        String url = "jdbc:postgresql:" + this.descriptor.getServer();
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException ex) {
            throw InformException.detail(ex, this.descriptor.getLogConnectionString(null));
        }
        Properties connInfo = new Properties();
        connInfo.setProperty("user", this.descriptor.getUserName());
        connInfo.setProperty("password", this.descriptor.getPassword());
        connInfo.setProperty("ApplicationName", this.getAppName());
        connInfo.setProperty("preparedStatementCacheQueries", "0");
        java.sql.Connection result = DriverManager.getConnection(url, connInfo);
        result.setAutoCommit(false);
        return result;
    }

    @Override
    public void commitForReleaseSelectLocks() throws SQLException {
        this.commit();
    }

    @Override
    public DbScheme openScheme(String name) {
        return new Scheme(name, this, this.jdbcMetadata);
    }

    @Override
    public void restoreTransactionAfterException(boolean commit) throws SQLException {
        if (commit) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public boolean isUniqueIndexConstraintException(SQLException ex) {
        return "23505".equals(ex.getSQLState());
    }

    @Override
    protected CallableStatement newCallableStatement(String comment, String sql) throws SQLException {
        return new inform.agent.db.connect.postgresql.CallableStatement(comment, sql, this.connection.prepareCall(sql), this);
    }

    @Override
    protected void custom_PreparedStatement_setNull(java.sql.PreparedStatement statement, int parameterIndex, SqlDataType type) throws SQLException {
        switch (type) {
            case BLOB: {
                statement.setNull(parameterIndex, -2);
                break;
            }
            case DATE_TIME: {
                statement.setNull(parameterIndex, 93);
                break;
            }
            default: {
                super.custom_PreparedStatement_setNull(statement, parameterIndex, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllConstraintsDeferred(SSContext ssContext) throws SQLException {
        if (this.deferredCheckConstraints) {
            return;
        }
        super.setAllConstraintsDeferred(ssContext);
        Statement statement = this.createStatement();
        try {
            statement.execute(ssContext, "set constraints all deferred");
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
        }
    }

    @Override
    public BatchInsertEngine createBatchInsertEngine(AbstractConnectionManager connectionManager) throws SQLException {
        assert (this.connection instanceof PGConnection);
        return new BatchInsertEnginePGSQL(connectionManager, this, ((PGConnection)this.connection).getCopyAPI());
    }
}

