/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.postgresql.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

class Column
extends DbColumn {
    public Column(String name, DataType type, FieldDescriptor.BlobRawType brt, boolean nullable, int size, DbTable table) {
        super(name, type, brt, nullable, size, table);
    }

    @Override
    public void internal_setType(SSContext ssContext, Statement statement, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, boolean keyable, FieldDescriptor fd) throws SQLException {
        try {
            this.sqlTypeName = this.scheme().ct2sql(fd);
            if (type != this.type || size != this.size) {
                Object using = "";
                block1 : switch (this.type) {
                    case STRING: 
                    case UNICODE: {
                        switch (type) {
                            case INTEGER: {
                                using = " USING " + this.name() + "::integer";
                                break block1;
                            }
                            case FLOAT: {
                                if (fd.isRecordIdPresentation()) {
                                    using = " USING " + this.name() + "::double precision";
                                    break block1;
                                }
                                using = " USING " + this.name() + "::numeric";
                                break block1;
                            }
                            case DIRECTORY: 
                            case METATREE_NODE: 
                            case PRIMARY_KEY: {
                                using = " USING " + this.name() + "::double precision";
                                break block1;
                            }
                            case INTERVAL: {
                                using = " USING " + this.name() + "::numeric";
                            }
                        }
                    }
                }
                statement.execute(ssContext, String.format("ALTER TABLE %s ALTER COLUMN %s TYPE %s%s", this.table.fullName(), this.name(), this.sqlTypeName, using));
            }
            if (fd.isHasDefValue() != this.hasDefValue) {
                statement.execute(ssContext, String.format("ALTER TABLE %s ALTER COLUMN %s %s", this.table.fullName(), this.name(), fd.isHasDefValue() ? this.scheme().columnDefValue(fd, true) : "DROP DEFAULT"));
            }
            if (nullable != this.nullable) {
                statement.execute(ssContext, String.format("ALTER TABLE %s ALTER COLUMN %s %s NOT NULL", this.table.fullName(), this.name(), nullable ? "DROP" : "SET"));
            }
        }
        catch (SQLException e) {
            Throwable c = e.getCause();
            if (c instanceof SQLException && "42804".equals(((SQLException)c).getSQLState())) {
                throw new SQLFeatureNotSupportedException(c);
            }
            throw e;
        }
    }

    @Override
    protected void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        if (this.isForeignKey() && !Strings.isVoid(this.foreignKeyName)) {
            statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP CONSTRAINT " + this.foreignKeyName);
        }
        statement.execute(ssContext, String.format("ALTER TABLE %s DROP COLUMN %s", this.table.fullName(), this.scheme().enquoteIfNeed(this.name())));
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, String.format("ALTER TABLE %s RENAME %s TO %s", this.table.fullName(), this.scheme().enquoteIfNeed(this.name()), this.scheme().enquoteIfNeed(to)));
    }

    @Override
    public boolean compatibleTo(FieldDescriptor fd) {
        if (this.equals(fd)) {
            if (fd.getType() == DataType.FLOAT) {
                return fd.isRecordIdPresentation() == this.keyable;
            }
            return true;
        }
        return false;
    }

    @Override
    public void appendConvertTo(DbColumn to, StringBuilder out) {
        if (this.type.canHoldsIn(to.getType()) && this.size <= to.getSize()) {
            super.appendConvertTo(to, out);
        } else {
            out.append(this.name).append("::").append(this.scheme().toCaseIfNeed(this.sqlTypeName));
        }
    }

    @Override
    protected boolean isTypesCompatible(DataType type1, DataType type2) {
        return type1.canHoldsIn(type2);
    }

    @Override
    public String getSqlType() {
        if ("tsvector".equals(this.sqlTypeName)) {
            return this.sqlTypeName;
        }
        return super.getSqlType();
    }

    @Override
    public boolean equals(FieldDescriptor fd) {
        if (!this.scheme().ct2sql(fd).equals(this.getSqlType())) {
            return false;
        }
        return "tsvector".equals(this.sqlTypeName) ? this.nullable == fd.isNullable() : super.equals(fd);
    }
}

