/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.filters;

public class Range {
    public static final Range EMPTY = new Range(0, -1);
    public final int first;
    public final int last;

    public Range(int first, int last) {
        this.first = first;
        this.last = last;
    }

    public boolean empty() {
        return this.first > this.last;
    }

    public int median() {
        return (this.first + this.last) / 2;
    }

    public int length() {
        return this.last - this.first + 1;
    }

    public Range intersect(Range r) {
        if (this.first <= r.first) {
            if (this.last >= r.last) {
                return r;
            }
            return new Range(r.first, this.last);
        }
        if (this.last <= r.last) {
            return this;
        }
        return new Range(this.first, r.last);
    }

    public String toString() {
        return String.format("[%d..%d]", this.first, this.last);
    }
}

