/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.Restructure;
import java.util.ArrayList;

public class CheckSystemTables
extends Request {
    private static final int TAG_CTS_LOG = 1;

    public CheckSystemTables(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        DatabaseDescriptor dd = DatabaseDescriptor.getDatabase(this.createRequestContentReader());
        if (!dd.isAuditEnabled()) {
            return;
        }
        try (DatabaseConnection connection = dd.connect(this, "rq:CheckSystemTables");){
            String sName = dd.getAuditScheme();
            if (sName == null || sName.isEmpty()) {
                sName = dd.getScheme();
            }
            DbScheme scheme = connection.openScheme(sName);
            DbScheme detailScheme = null;
            sName = dd.getDetailAuditScheme();
            detailScheme = sName == null || sName.isEmpty() ? scheme : connection.openScheme(sName);
            final ArrayList log = new ArrayList();
            Restructure.RealLogger logger = new Restructure.RealLogger(){

                @Override
                public void info(String line) {
                    super.info(line);
                    log.add(line);
                }

                @Override
                public void log(TableDescriptor context, String line) {
                    super.log(context, line);
                    log.add(line);
                }
            };
            try (Statement statement = connection.createStatement();){
                Restructure.upcreateTable(null, scheme, statement, TableDataAudit.getSystemChangelogDescriptor(), logger, true);
                connection.commit();
                Restructure.upcreateTable(null, scheme, statement, TableDataAudit.getSystemTransChangelogDescriptor(), logger, true);
                connection.commit();
                Restructure.upcreateTable(null, detailScheme, statement, TableDataAudit.getSystemChangelogValDescriptor(), logger, true);
                connection.commit();
                Restructure.upcreateTable(null, detailScheme, statement, TableDataAudit.getSystemChangelogBlobDescriptor(), logger, true);
                connection.commit();
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(result);
            if (log.isEmpty()) {
                writer.putAnsi(1, "\u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c");
            } else {
                for (String msg : log) {
                    writer.putAnsi(1, msg);
                }
            }
            writer.flush();
            this.sendResult(result.internalBuffer(), result.size());
        }
    }
}

