/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbColumnable;
import inform.agent.db.schema.DbScheme;
import inform.agent.mtd.nodes.DatabaseNode;

public class DescribePhysicalTable
extends Request {
    public static final int TAG_PHYSICAL_TABLE_NAME = 1;
    public static final int TAG_DESCR_TABLE_DESCRIPTION = 2;
    public static final int TAG_DESCR_FIELD_HEADER = 3;
    public static final int TAG_DESCR_FIELD_NAME = 4;
    public static final int TAG_DESCR_FIELD_DESCRIPTION = 5;

    public DescribePhysicalTable(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        DatabaseNode node = this.getNode(this.getTranslatedNodeID(), DatabaseNode.class);
        DatabaseDescriptor dd = node.getDescriptor();
        try (DatabaseConnection connection = dd.connect(this, "rq:DescribePhysicalTable");){
            TaggedReader in = this.createRequestContentReader();
            String rawTableName = in.getAnsi(1);
            String scheme = dd.getScheme();
            int dotIndex = rawTableName.indexOf(46);
            if (dotIndex >= 0) {
                scheme = rawTableName.substring(0, dotIndex);
                rawTableName = rawTableName.substring(dotIndex + 1);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(result);
            writer.putAnsi(1, rawTableName);
            DbScheme dbScheme = connection.openScheme(scheme);
            DbColumnable t = dbScheme.getColumnableObject(null, rawTableName);
            if (t != null) {
                for (DbColumn c : t.getColumns(null).values()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    LittleEndianDataOutputStream los = new LittleEndianDataOutputStream(out);
                    los.writeInt(c.getType().getTypeId());
                    los.writeInt(c.getSize());
                    los.writeInt(c.isNullable() ? 0 : 1);
                    los.writeInt(0);
                    los.flush();
                    writer.putRaw(3, out.toByteArray());
                    writer.putAnsi(4, c.name());
                }
            } else {
                throw new InformException(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \"%s\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", rawTableName)).detail(String.format("\u0411\u0414:\"%s\", \u0441\u0445\u0435\u043c\u0430:\"%s\"", node.getName(), dd.getScheme()));
            }
            writer.flush();
            this.sendResult(result.internalBuffer(), result.size());
        }
    }
}

