/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.mtd.nodes.DatabaseNode;

public class DescribePhysicalTableIndices
extends Request {
    public DescribePhysicalTableIndices(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        DatabaseNode node = this.getNode(this.getTranslatedNodeID(), DatabaseNode.class);
        DatabaseDescriptor dd = node.getDescriptor();
        try (DatabaseConnection connection = dd.connect(this, "rq:DescribePhysicalTable");){
            TaggedReader in = this.createRequestContentReader();
            String rawTableName = in.getAnsi(23);
            String scheme = dd.getScheme();
            int dotIndex = rawTableName.indexOf(46);
            if (dotIndex >= 0) {
                scheme = rawTableName.substring(0, dotIndex);
                rawTableName = rawTableName.substring(dotIndex + 1);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(result);
            DbScheme dbScheme = connection.openScheme(scheme);
            DbTable t = dbScheme.getTable(null, rawTableName);
            if (t != null) {
                for (DbIndex index : t.getIndexes(null).values()) {
                    if (!index.isValid() || index.name().toUpperCase().startsWith("SYS")) continue;
                    out.putString(5, index.name());
                    if (index.isUnique()) {
                        out.putEmpty(4);
                    }
                    if (!index.isUsageClustered()) {
                        out.putInt32(17, 1);
                    } else if (index.isClustered()) {
                        out.putEmpty(7);
                    }
                    if (!index.isUsageCompressedFields()) {
                        out.putInt32(17, 2);
                    } else if (index.getCompressedFields() != 0) {
                        out.putInt32(8, index.getCompressedFields());
                    }
                    if (!index.isUsageBitmap()) {
                        out.putInt32(17, 0);
                    } else if (index.isBitmap()) {
                        out.putEmpty(9);
                    }
                    for (DbColumn c : index.getColumns()) {
                        if (c == null) {
                            out.putEmpty(100);
                            continue;
                        }
                        out.putString(99, c.name());
                    }
                }
            } else {
                throw new InformException(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \"%s\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", rawTableName)).detail(String.format("\u0411\u0414:\"%s\", \u0441\u0445\u0435\u043c\u0430:\"%s\"", node.getName(), dd.getScheme()));
            }
            out.flush();
            this.sendResult(result.internalBuffer(), result.size());
        }
    }
}

