/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.request.GetMD5;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.scripts.libs.MessageDigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;

public class GetMD5Fields
extends Request {
    DatabaseDescriptor databaseDescriptor;
    DatabaseConnection connection;
    String sqlText;
    SqlParameterList params;
    ArrayList<FieldDescriptor> fields;
    RequestResult result;
    TaggedWriter out;

    public GetMD5Fields(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        DoubleSet rows = new DoubleSet();
        IntegerSet fieldIds = new IntegerSet();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 5: {
                    fieldIds.add(in.getInt());
                    break;
                }
                case 7: {
                    rows.add(in.getDouble());
                }
            }
        }
        if (fieldIds.empty()) {
            return;
        }
        if (rows.empty()) {
            return;
        }
        TableDescriptor table = this.getNode(this.rq.nodeId, TableNode.class).getDescriptor();
        if (table.getKind() == TableDescriptor.Kind.VIRTUAL) {
            this.sendResult();
            return;
        }
        if (!table.hasStandartPrimaryKey()) {
            this.sendResult();
            return;
        }
        FieldDescriptor pk = table.getRecordIdField();
        if (pk == null) {
            this.sendResult();
            return;
        }
        this.fields = new ArrayList();
        for (Cursor.Integer fieldId : fieldIds) {
            this.fields.add(table.getExistingFieldDescriptor(fieldId.value));
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ").append(pk);
        for (FieldDescriptor field : this.fields) {
            sql.append(", ").append(field);
        }
        sql.append(" from ");
        sql.append(table);
        sql.append(" where ").append(pk);
        this.sqlText = sql.toString();
        this.params = new SqlParameterList();
        this.databaseDescriptor = table.getDatabaseDescriptor();
        this.result = new RequestResult(this, 8192);
        this.out = this.result.getWriter();
        this.connection = this.databaseDescriptor.connect(this, "GetMD5Fields");
        try {
            for (Cursor.Double rowId : rows) {
                this.params.add(new SqlParameter().setDouble(rowId.value));
                if (this.params.size() <= 90) continue;
                this.flush();
            }
            this.flush();
            this.result.sendResult();
            this.connection.commit();
        }
        finally {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws Exception {
        if (this.params.isEmpty()) {
            return;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append(this.sqlText);
        if (this.params.size() == 1) {
            sql.append("=?");
        } else {
            sql.append(" in (");
            int sep = 32;
            for (SqlParameter p : this.params) {
                sql.append((char)sep).append('?');
                sep = 44;
            }
            sql.append(')');
        }
        try (PreparedStatement statement = this.connection.prepareStatement(sql.toString());){
            this.params.applyTo(statement);
            this.params = new SqlParameterList();
            try (ResultSet rs = statement.executeQuery(this.getSSContext());){
                while (rs.next()) {
                    double recordId = rs.getDouble(1);
                    this.out.putDouble(7, recordId);
                    byte[] digest = null;
                    int count = this.fields.size();
                    block16: for (int i = 0; i < count; ++i) {
                        FieldDescriptor f = this.fields.get(i);
                        if (f == null) continue;
                        int ci = i + 2;
                        MessageDigest md5 = MessageDigest.getInstance("md5");
                        LittleEndianDataOutputStream mds = new LittleEndianDataOutputStream(new MessageDigestOutputStream(md5));
                        boolean isNull = false;
                        switch (f.getType()) {
                            case BOOLEAN: {
                                int intVal = rs.getAsInteger(ci);
                                isNull = rs.wasNull();
                                if (isNull) break;
                                mds.writeBoolean(intVal != 0);
                                break;
                            }
                            case INTEGER: {
                                int intVal = rs.getAsInteger(ci);
                                isNull = rs.wasNull();
                                if (isNull) break;
                                mds.writeInt(intVal);
                                break;
                            }
                            case PRIMARY_KEY: 
                            case FLOAT: 
                            case DATE_TIME: 
                            case INTERVAL: 
                            case DIRECTORY: 
                            case METATREE_NODE: {
                                double doubleVal = rs.getAsInteger(ci);
                                isNull = rs.wasNull();
                                if (isNull) break;
                                mds.writeDouble(doubleVal);
                                break;
                            }
                            case STRING: 
                            case BIG_NUMBER: 
                            case UNICODE: {
                                String stringVal = rs.getString(ci);
                                isNull = rs.wasNull();
                                if (isNull) break;
                                mds.writeUTF8(stringVal);
                                break;
                            }
                            case BLOB: 
                            case FILE: {
                                digest = GetMD5.blobMD5digest(rs, f, ci);
                                isNull = digest == null;
                                break;
                            }
                            case GEOMETRY: {
                                digest = GetMD5.geometryMD5digest(rs, f, ci);
                                isNull = digest == null;
                                break;
                            }
                            default: {
                                continue block16;
                            }
                        }
                        if (isNull) continue;
                        if (digest == null) {
                            mds.flush();
                            digest = md5.digest();
                        }
                        this.out.putInt32(5, f.getId());
                        this.out.putRaw(4, digest);
                        this.result.sendChunkIf(4032);
                    }
                }
            }
        }
    }
}

